///////////////////////////////////////////////////////////////////////////////
// $Id: PushButton.hxx,v 1.1 1995/01/08 06:51:28 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// PushButton.hxx - Push button widget
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 12,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: PushButton.hxx,v $
// Revision 1.1  1995/01/08  06:51:28  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef PUSHBUTTON_HXX
#define PUSHBUTTON_HXX

#include "BasicWidget.hxx"
#include "Command.hxx"

class PushButton : public BasicWidget {
  private:
    const char *const myLabel;
    Command* myCommand;

  protected:
    // Called whenever an event arrives for me (I need to override the default)
    virtual void handleEvent(XEvent* event);

    // Update the graphical view of myself
    void updateView();
 
  public:
    // Constructor
    PushButton(ContainerWidget *const parent, const char *const widgetName,
        int x, int y, int width, int height, 
        const char* label, Command* pushCommand);

    // Destructor
    virtual ~PushButton();

    // Answer my class
    virtual const char *const className() const { return("PushButton"); }
};
#endif

