/* Copyright (C) 1979-1998 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

#include "mysql_priv.h"
#include "sql_lex.h"
#include <m_ctype.h>
#include <nisam.h>
#include <thr_alarm.h>
#ifdef	__cplusplus
extern "C" {					// Because of SCO 3.2V4.2
#endif
#include <errno.h>
#include <sys/stat.h>
#ifndef __GNU_LIBRARY__
#define __GNU_LIBRARY__				// Skipp warnings in getopt.h
#endif
#include <getopt.h>
#ifdef HAVE_SYSENT
#include <sysent.h>
#endif

#ifndef __WIN32__
#include <sys/resource.h>
#ifdef HAVE_SYS_UN_H
#  include <sys/un.h>
#endif
#include <netdb.h>
#ifdef HAVE_SELECT_H
#  include <select.h>
#endif
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#include <sys/utsname.h>
#else
#include <windows.h>
#endif // __WIN32__
#ifdef	__cplusplus
}
#endif

#ifdef HAVE_LINUXTHREADS
#include <gnu/types.h>
#define THR_KILL_SIGNAL SIGINT
#else
#include <my_pthread.h>			// For thr_setconcurency()
#define THR_KILL_SIGNAL SIGUSR2		// Can't use this with LinuxThreads
#endif
#if defined(HAVE_GETRLIMIT) && defined(RLIMIT_NOFILE) && !defined(__linux__) && !defined(HAVE_mit_thread)
#define SET_RLIMIT_NOFILE
#endif
#ifdef __WIN32__
static const char* default_dbug_option="d:t:i:O,\\mysqld.trace";
#else
static const char *default_dbug_option="d:t:i:o,/tmp/mysqld.trace";
#endif

static Socket unix_sock= (Socket) -1,ip_sock= (Socket) -1;
static ulong max_connections,back_log;
static ulong opt_specialflag=SPECIAL_ENGLISH;
static ulong thread_id=1L;
static my_string opt_logname=0,opt_update_logname=0;
static char mysql_home[FN_REFLEN],pidfile_name[FN_REFLEN];
static pthread_cond_t COND_thread_count;
static pthread_attr_t connection_attrib;
static pthread_t select_thread;
static bool opt_log,opt_update_log,opt_noacl,opt_disable_networking=0,
	    opt_secure=0;
static bool kill_in_progress=FALSE;

uint mysql_port;
uint test_flags,thread_count=0,select_errors=0,thd_startup_options=0;
uint current_pid,protocol_version=PROTOCOL_VERSION;
ulong keybuff_size,sortbuff_size,max_item_sort_length,table_cache_size,
      max_join_size,join_buff_size,tmp_table_size,thread_stack;
bool opt_endinfo;
bool volatile abort_loop,select_thread_in_use;
ulong reload_version=1L;		/* Increments on each reload */
ulong query_id=1L;
ulong specialflag=0,opened_tables=0;
char mysql_data_home[FN_REFLEN],language[LIBLEN],reg_ext[FN_EXTLEN],
     blob_newline,f_fyllchar,max_sort_char;
char server_version[40]=MYSQL_SERVER_VERSION;
char **errmesg;				/* Error messages */
byte last_ref[MAX_REFLENGTH];		/* Index ref of keys */
my_string mysql_unix_port,mysql_tmpdir;
ulong my_bind_addr;			/* the address we bind to */
DATE_FORMAT dayord;
double log_10[32];			/* 10 potences */
I_List<THD> threads;
time_t start_time;
pthread_key(MEM_ROOT*,THR_MALLOC);
pthread_key(THD*, THR_THD);
pthread_key(NET*, THR_NET);
pthread_mutex_t LOCK_mysql_create_db, LOCK_Acl, LOCK_open, LOCK_thread_count,
		LOCK_mapped_file;
pthread_t signal_thread;


#ifdef __WIN32__
#undef	 getpid
#include <process.h>
HANDLE hEventShutdown;
#include "nt_servc.h"
static	 NTService  Service;	      // Service object for WinNT
#endif

static void *signal_hand(void *arg);
static void get_options(int argc,char **argv);
static char *get_relative_path(char *path);
static void fix_paths(void);
static void handle_connections(void);
static my_string get_hostname(struct sockaddr_in *remote);
static void application_end(void);
#ifdef SET_RLIMIT_NOFILE
static uint set_maximum_open_files(uint max_file_limit);
#endif

static void close_connections(void)
{
  NET net;
  DBUG_ENTER("close_connections");

  /* kill first connection thread */
#ifndef __WIN32__
  VOID(pthread_mutex_lock(&LOCK_thread_count));
  DBUG_PRINT("info",("waiting for select thread: %lx",select_thread));
  while (select_thread_in_use)
  {
    struct timespec abstime;
    if (pthread_kill(select_thread,THR_CLIENT_ALARM))
      break;					// allready dead
#ifdef HAVE_TIMESPEC_TS_SEC
    abstime.ts_sec=time(NULL)+1;		// Bsd 2.1
    abstime.ts_nsec=0;
#else
    abstime.tv_sec=time(NULL)+1;		// Linux or Solairs
    abstime.tv_nsec=0;
#endif
    VOID(pthread_cond_timedwait(&COND_thread_count,&LOCK_thread_count,
				&abstime));
#ifdef AIX_3_2
    if (ip_sock != (Socket) -1)
    {
      VOID(shutdown(ip_sock,2));
      VOID(closesocket(ip_sock));
      VOID(shutdown(unix_sock,2));
      VOID(closesocket(unix_sock));
      VOID(unlink(mysql_unix_port));
      ip_sock=unix_sock= (Socket) -1;
    }
#endif
  }
  VOID(pthread_mutex_unlock(&LOCK_thread_count));
#else
//   there are some problems with this: it should be done later
//   abort_loop=1;
#endif /* __WIN32__ */

  /* Abort listening to new connections */
  DBUG_PRINT("info",("Closing sockets"));
  if (ip_sock != (Socket) -1)
  {
    VOID(shutdown(ip_sock,2));
    VOID(closesocket(ip_sock));
    ip_sock= (Socket) -1;
  }
#ifdef HAVE_SYS_UN_H
  if (unix_sock != (Socket) -1)
  {
    VOID(shutdown(unix_sock,2));
    VOID(closesocket(unix_sock));
    VOID(unlink(mysql_unix_port));
    unix_sock= (Socket) -1;
  }
#endif
  end_thr_alarm();			 // Don't allow alarms

  VOID(my_net_init(&net,0));
  for (;;)
  {
    THD *tmp;
    DBUG_PRINT("mutex",("Locking LOCK_thread_count"));
    VOID(pthread_mutex_lock(&LOCK_thread_count)); // For unlink from list
    if (!(tmp=threads.get()))
    {
      VOID(pthread_mutex_unlock(&LOCK_thread_count));
      break;
    }
    tmp->killed=1;
#ifndef __bsdi__				// Bug in BSDI kernel
    if ((net.fd=tmp->net.fd) >= 0)
    {
      fprintf(stderr,ER(ER_FORCING_CLOSE),my_progname,
	      tmp->thread_id,tmp->user);
      close_connection(&net,0,0);
    }
#endif
    DBUG_PRINT("mutex",("Unlocking LOCK_thread_count"));
    VOID(pthread_mutex_unlock(&LOCK_thread_count));
  }
  net_end(&net);
  /* abort all threads */
  DBUG_PRINT("mutex",("Waiting for threads to die (count=%u)",thread_count));
  VOID(pthread_mutex_lock(&LOCK_thread_count));
  while (thread_count)
  {
    VOID(pthread_cond_wait(&COND_thread_count,&LOCK_thread_count));
    DBUG_PRINT("mutex",("One thread died (count=%u)",thread_count));
  }
  VOID(pthread_mutex_unlock(&LOCK_thread_count));

#ifdef __WIN32__
  abort_loop=1;
#endif
  mysql_log.close();
  mysql_update_log.close();
  DBUG_VOID_RETURN;
}

	/* Force server down. kill all connections and threads and exit */

#ifndef __WIN32__
static void *kill_server(void *sig_ptr)
#define RETURN_FROM_KILL_SERVER return 0
#else
static void __cdecl kill_server(int sig_ptr)
#define RETURN_FROM_KILL_SERVER return
#endif
{
  int sig=(int) (long) sig_ptr;			// This is passed a int
  DBUG_ENTER("kill_server");

  // if there is a signal during the kill in progress, we do not need
  // another one
  if (kill_in_progress)
    RETURN_FROM_KILL_SERVER;
  kill_in_progress=TRUE;
  signal(sig,SIG_IGN);
  if (sig == SIGQUIT || sig == 0)
    fprintf(stderr,ER(ER_NORMAL_SHUTDOWN),my_progname);
  else
    fprintf(stderr,ER(ER_GOT_SIGNAL),my_progname,sig); /* purecov: inspected */

#if defined(USE_ONE_SIGNAL_HAND) && !defined(__WIN32__)
  my_thread_init();				// If this is a new thread
#endif
  close_connections();
  fprintf(stderr,ER(ER_SHUTDOWN_COMPLETE),my_progname);
  if (sig != SIGQUIT)
  {
    application_end();				// Free application data
    unireg_abort(1);				/* purecov: inspected */
  }
  else
  {
    application_end();				// Free application data
    unireg_end(0);
  }
  pthread_exit(0);				/* purecov: deadcode */
  RETURN_FROM_KILL_SERVER;
}


/****************************************************************************
** Init IP and UNIX socket
****************************************************************************/

static void set_ports()
{
  char	*env;
  if (!mysql_port)
  {					// Get port if not from commandline
    struct  servent *serv_ptr;
    mysql_port = MYSQL_PORT;
    if ((serv_ptr = getservbyname("mysql", "tcp")))
      mysql_port = ntohs((u_short) serv_ptr->s_port); /* purecov: inspected */
    if ((env = getenv("MYSQL_TCP_PORT")))
      mysql_port = (uint) atoi(env);		/* purecov: inspected */
  }
  if (!mysql_unix_port)
  {
    mysql_unix_port = MYSQL_UNIX_ADDR;
    if ((env = getenv("MYSQL_UNIX_PORT")))
      mysql_unix_port = env;			/* purecov: inspected */
  }
}


static void server_init(void)
{
  struct sockaddr_in	IPaddr;
#ifdef HAVE_SYS_UN_H
  struct sockaddr_un	UNIXaddr;
#endif
  int	arg=1;
  DBUG_ENTER("server_init");

#ifdef	__WIN32__
   WSADATA WsaData;
   if (SOCKET_ERROR == WSAStartup (0x0101, &WsaData))
   {
     my_message(0,"WSAStartup Failed\n",MYF(0));
     unireg_abort(1);
   }
#endif /* __WIN32__ */

  set_ports();

  if (mysql_port != 0 && !opt_disable_networking)
  {
    DBUG_PRINT("general",("IP Socket is %d",mysql_port));
    ip_sock = socket(AF_INET, SOCK_STREAM, 0);
    if (ip_sock == (Socket) -1)
    {
      DBUG_PRINT("error",("Got error: %d from socket()",socket_errno));
      perror(ER(ER_IPSOCK_ERROR));		/* purecov: tested */
      unireg_abort(1);				/* purecov: tested */
    }
    bzero(&IPaddr, sizeof(IPaddr));
    IPaddr.sin_family = AF_INET;
    IPaddr.sin_addr.s_addr = my_bind_addr;
    IPaddr.sin_port = (unsigned short) htons((unsigned short) mysql_port);
    (void) setsockopt(ip_sock,SOL_SOCKET,SO_REUSEADDR,(char*)&arg,sizeof(arg));
    for(;;)
    {
      if (bind(ip_sock, (struct sockaddr *)&IPaddr, sizeof(IPaddr)) >= 0)
	break;
      DBUG_PRINT("error",("Got error: %d from bind",socket_errno));
      perror("Can't start server: Bind on TCP/IP port");/* Had a loop here */
      application_end();
      unireg_abort(1);
    }
    VOID(listen(ip_sock,(int) back_log));
  }

#if defined(HAVE_SYS_UN_H) && !defined(HAVE_mit_thread)
  /*
  ** Create the UNIX socket
  */
  DBUG_PRINT("general",("UNIX Socket is %s",mysql_unix_port));

  if ((unix_sock = socket(AF_UNIX, SOCK_STREAM, 0)) < 0)
  {
    perror("Can't start server : UNIX Socket "); /* purecov: inspected */
    application_end();
    unireg_abort(1);				/* purecov: inspected */
  }
  bzero(&UNIXaddr, sizeof(UNIXaddr));
  UNIXaddr.sun_family = AF_UNIX;
  strmov(UNIXaddr.sun_path, mysql_unix_port);
  VOID(unlink(mysql_unix_port));
  (void) setsockopt(unix_sock,SOL_SOCKET,SO_REUSEADDR,(char*)&arg,sizeof(arg));
  umask(0);
  if (bind(unix_sock, (struct sockaddr *)&UNIXaddr, sizeof(UNIXaddr)) < 0)
  {
    perror("Can't start server : Bind on unix socket"); /* purecov: tested */
    application_end();
    unireg_abort(1);					/* purecov: tested */
  }
  umask(((~my_umask) & 0666));
#if defined(S_IFSOCK) && defined(SECURE_SOCKETS)
  VOID(chmod(mysql_unix_port,S_IFSOCK));	/* Fix solaris 2.6 bug */
#endif
  VOID(listen(unix_sock,(int) back_log));
#endif
  DBUG_PRINT("info",("server started"));
  DBUG_VOID_RETURN;
}


void yyerror(char *s)
{
  NET *net=my_pthread_getspecific_ptr(NET*,THR_NET);
  char *yytext=(char*) current_lex->tok_start;
  net_printf(net,ER_PARSE_ERROR, s, yytext ? (char*) yytext : "",
	     current_lex->yylineno);
}


void close_connection(NET *net,uint errcode,bool lock)
{
  Socket fd;
  DBUG_ENTER("close_connection");
  DBUG_PRINT("enter",("error: '%s'",errcode ? ER(errcode) : ""));
  if (lock)
    VOID(pthread_mutex_lock(&LOCK_thread_count));
  if ((fd=net->fd) != INVALID_SOCKET)
  {
    if (errcode)
      send_error(net,errcode,ER(errcode));	/* purecov: inspected */
    net->fd= INVALID_SOCKET;
    VOID(shutdown(fd,2));
    VOID(closesocket(fd));
    net_end(net);
  }
  if (lock)
    VOID(pthread_mutex_unlock(&LOCK_thread_count));
  DBUG_VOID_RETURN;
}

	/* Called when a thread is aborted */
	/* ARGSUSED */

sig_handler end_thread(int sig __attribute__((unused)))
{
  THD *thd=current_thd;
  DBUG_ENTER("end_thread");
  if (thd)
  {
    VOID(pthread_mutex_lock(&LOCK_thread_count));
    free_root(&thd->alloc);
    thread_count--;
    delete thd;
    VOID(pthread_cond_signal(&COND_thread_count)); /* Tell main we are ready */
    VOID(pthread_mutex_unlock(&LOCK_thread_count));
    pthread_exit(0);
  }
  DBUG_VOID_RETURN;				/* purecov: deadcode */
}

	/*
	** Aborts a thread nicely. Commes here on SIGPIPE
	** TODO: One should have to fix that thr_alarm know about this
	** thread too
	*/

#ifdef THREAD_SPECIFIC_SIGPIPE
static sig_handler abort_thread(int sig __attribute__((unused)))
{
  THD *thd=current_thd;
  DBUG_ENTER("abort_thread");
  if (thd)
    thd->killed=1;
  DBUG_VOID_RETURN;
}
#endif

/******************************************************************************
** Setup a signal thread with handles all signals
** Because linux doesn't support scemas use a mutex to check that
** the signal thread is ready before continuing
******************************************************************************/

#ifdef __WIN32__
static void init_signals(void)
{
  int signals[7] = {SIGINT,SIGILL,SIGFPE,SIGSEGV,SIGTERM,SIGABRT } ;
  for (uint i=0 ; i < 7 ; i++)
    signal( signals[i], kill_server) ;
  signal(SIGBREAK,SIG_IGN);	//ignore SIGBREAK for NT
}
#else

static void init_signals(void)
{
  sigset_t set;
  pthread_attr_t thr_attr;
  int error;
  DBUG_ENTER("init_signals");

  (void) sigset(THR_KILL_SIGNAL,end_thread);
#ifdef THREAD_SPECIFIC_SIGPIPE
  (void) sigset(SIGPIPE,abort_thread);
  sigaddset(&set,SIGPIPE);
#else
  VOID(signal(SIGPIPE,SIG_IGN));		// Can't know which thread
#endif
  (void) sigemptyset(&set);
  sigaddset(&set,SIGINT);
  sigaddset(&set,SIGQUIT);
  sigaddset(&set,SIGTERM);
  sigaddset(&set,SIGHUP);
  sigaddset(&set,SIGTSTP);
  sigaddset(&set,THR_SERVER_ALARM);
  sigdelset(&set,THR_KILL_SIGNAL);		// May be SIGINT
  sigdelset(&set,THR_CLIENT_ALARM);		// For alarms
  (void) pthread_sigmask(SIG_SETMASK,&set,NULL);

  VOID(pthread_attr_init(&thr_attr));
  pthread_attr_setscope(&thr_attr,PTHREAD_SCOPE_SYSTEM);
  VOID(pthread_attr_setdetachstate(&thr_attr,PTHREAD_CREATE_DETACHED));
  if (!(opt_specialflag & SPECIAL_NO_PRIOR))
    my_pthread_attr_setprio(&thr_attr,INTERRUPT_PRIOR);
  pthread_attr_setstacksize(&thr_attr,32768);

  VOID(pthread_mutex_lock(&LOCK_thread_count));
  if ((error=pthread_create(&signal_thread,&thr_attr,signal_hand,0)))
  {
    fprintf(stderr,"Can't create interrupt-thread (error %d, errno: %d)\n",
	    error,errno);
    exit(1);
  }
  VOID(pthread_cond_wait(&COND_thread_count,&LOCK_thread_count));
  pthread_mutex_unlock(&LOCK_thread_count);

  VOID(pthread_attr_destroy(&thr_attr));
  DBUG_VOID_RETURN;
}


/*
** This threads handles all signals and alarms
*/

/* ARGSUSED */
static void *signal_hand(void *arg __attribute__((unused)))
{
  sigset_t set;
  int sig;
  DBUG_ENTER("signal_hand");

  my_thread_init();				// Init new thread
  init_thr_alarm(max_connections+3);		// Setup alarm handler
#if SIGINT != THR_KILL_SIGNAL
  VOID(sigemptyset(&set));			// Setup up SIGINT for debug
  VOID(sigaddset(&set,SIGINT));			// For debugging
  VOID(pthread_sigmask(SIG_UNBLOCK,&set,NULL));
#endif
  VOID(sigemptyset(&set));			// Setup up SIGINT for debug
#ifdef USE_ONE_SIGNAL_HAND
  VOID(sigaddset(&set,THR_SERVER_ALARM));	// For alarms
#endif
  VOID(sigaddset(&set,SIGQUIT));
  VOID(sigaddset(&set,SIGTERM));
  VOID(sigaddset(&set,SIGHUP));
  VOID(sigaddset(&set,SIGTSTP));

  /* Save pid to this process (or thread on Linux) */
  {
    FILE	*pidFile;
    if ((pidFile = my_fopen(pidfile_name,O_WRONLY,MYF(MY_WME))))
    {
      fprintf(pidFile,"%d",current_pid);
      VOID(my_fclose(pidFile,MYF(0)));
      VOID(chmod(pidfile_name,0644));
    }
  }
  VOID(pthread_mutex_lock(&LOCK_thread_count));
  VOID(pthread_cond_signal(&COND_thread_count)); /* continue init_signals */
  pthread_mutex_unlock(&LOCK_thread_count);

  for (;;)
  {
    int error;
    while ((error=my_sigwait(&set,&sig)) == EINTR) ;
    switch (sig) {
    case SIGQUIT:
    case SIGKILL:
    case SIGTERM:
      DBUG_PRINT("info",("Got signal: %d  abort_loop: %d",sig,abort_loop));
      if (!abort_loop)
      {
	abort_loop=1;				// mark abort for threads
#ifdef USE_ONE_SIGNAL_HAND
	pthread_t tmp;
	if (!(opt_specialflag & SPECIAL_NO_PRIOR))
	  my_pthread_attr_setprio(&connection_attrib,INTERRUPT_PRIOR);
	pthread_create(&tmp,&connection_attrib, kill_server, (void*) sig);
#else
	kill_server((void*) sig);		// MIT THREAD has a alarm thread
#endif
      }
      break;
    case SIGHUP:
      reload_acl_and_cache(REFRESH_GRANT | REFRESH_TABLES); // Flush everything
      break;
#ifdef USE_ONE_SIGNAL_HAND
    case THR_SERVER_ALARM:
      process_alarm(sig);			// Trigger alarms.
      break;
#endif
    default:
      fprintf(stderr,"Warning: Got signal: %d, error: %d\n",sig,error); /* purecov: tested */
      break;					/* purecov: tested */
    }
  }
  return(0);					/* purecov: deadcode */
}

#endif	/* WIN32 */


	/* ARGSUSED */
static int my_message_sql(uint my_error, const char *str,
			  myf MyFlags __attribute__((unused)))
{
  NET *net;
  DBUG_ENTER("my_message_sql");
  DBUG_PRINT("error",("Message: '%s'",str));
  if ((net=my_pthread_getspecific_ptr(NET*,THR_NET)))
  {
    if (!net->last_error[0])			// Return only first message
    {
      strmake(net->last_error,str,sizeof(net->last_error)-1);
      net->last_errno=my_error ? my_error : ER_UNKNOWN_ERROR;
    }
  }
  else
    fprintf(stderr,"%s: %s\n",my_progname,str); /* purecov: inspected */
  DBUG_RETURN(0);
}

#ifdef __WIN32__
#undef errno
#undef EINTR
#define errno WSAGetLastError()
#define EINTR WSAEINTR

struct utsname
{
  char nodename[FN_REFLEN];
};

int uname(struct utsname *a)
{
  return -1;
}
#endif


#ifdef __WIN32__
pthread_handler_decl(handle_shutdown,arg)
{
  MSG msg;

  /* this must be here to be initialized with this thread ID */
  VOID(pthread_cond_init(&COND_thread_count,NULL));

  /* this call should create the message queue for this thread */
  PeekMessage(&msg, NULL, 1, 65534,PM_NOREMOVE);

  if (WaitForSingleObject(hEventShutdown,INFINITE)==WAIT_OBJECT_0)
     kill_server(SIGQUIT);
  return 0;
}

int __stdcall handle_kill(ulong ctrl_type)
{
  if (ctrl_type == CTRL_CLOSE_EVENT ||
      ctrl_type == CTRL_SHUTDOWN_EVENT)
  {
    kill_server(SIGQUIT);
    return TRUE;
  }
  return FALSE;
}
#endif


#ifdef __WIN32__
int win_main(int argc, char **argv)
#else
int main(int argc, char **argv)
#endif
{
  DEBUGGER_OFF;
  struct utsname uts_name;

  my_umask=0660;		// Default umask for new files
  MY_INIT(argv[0]);		// init my_sys library & pthreads

  start_time=time((time_t*) 0);
  if (uname(&uts_name) < 0)
    strmov(uts_name.nodename,"mysql");
  strmov(strmov(pidfile_name,uts_name.nodename),".pid");
#ifndef DBUG_OFF
  strcat(server_version,"-debug");
#endif
  get_options(argc,argv);
  if (opt_log || opt_update_log)
    strcat(server_version,"-log");
  DBUG_PRINT("info",("%s  Ver %s for %s on %s\n",my_progname,
		     server_version, SYSTEM_TYPE,MACHINE_TYPE));

  if (!(opt_specialflag & SPECIAL_NO_PRIOR))
    my_pthread_setprio(pthread_self(),CONNECT_PRIOR);
  /* Parameter for threads created for connections */
  VOID(pthread_attr_init(&connection_attrib));
  VOID(pthread_attr_setdetachstate(&connection_attrib,
				   PTHREAD_CREATE_DETACHED));
  pthread_attr_setstacksize(&connection_attrib,thread_stack);

  if (!(opt_specialflag & SPECIAL_NO_PRIOR))
    my_pthread_attr_setprio(&connection_attrib,WAIT_PRIOR);
  pthread_attr_setscope(&connection_attrib, PTHREAD_SCOPE_SYSTEM);

#ifndef __WIN32__
  VOID(pthread_cond_init(&COND_thread_count,NULL));
#endif
  VOID(pthread_mutex_init(&LOCK_mysql_create_db,NULL));
  VOID(pthread_mutex_init(&LOCK_Acl,NULL));
  VOID(pthread_mutex_init(&LOCK_open,NULL));
  VOID(pthread_mutex_init(&LOCK_thread_count,NULL));
  VOID(pthread_mutex_init(&LOCK_mapped_file,NULL));
  /* VOID(pthread_mutex_init(&THR_LOCK_dbug,NULL)); */

#ifdef SET_RLIMIT_NOFILE
  /* connections and databases neads lots of files */
  {
    uint wanted_files=10+(uint) max(max_connections*5,
				    max_connections+table_cache_size*2);
    uint files=set_maximum_open_files(wanted_files);
    if (files && files < wanted_files)		// Some systems return 0
    {
      max_connections=	(ulong) (files-10)/5;
      table_cache_size= (ulong) (files-10-max_connections)/2;
      DBUG_PRINT("warning",
		 ("Changed limits: max_connections: %ld  table_cache: %ld",
		  max_connections,table_cache_size));
      fprintf(stderr,"Warning: Changed limits: max_connections: %ld  table_cache: %ld\n",max_connections,table_cache_size);
    }
  }
#endif
  unireg_init(opt_specialflag); /* Set up extern variabels */
  init_errmessage();		/* Read error messages from file */
  lex_init();
  item_init();
  mysys_uses_curses=0;
  if (!(mysql_tmpdir=getenv("TMPDIR"))) /* Use this if possibly */
    mysql_tmpdir=P_tmpdir;		/* Use system default */ /* purecov: inspected */
#ifdef USE_REGEX
  regex_init();
#endif
  select_thread=pthread_self();
  select_thread_in_use=1;

  /*
  ** We have enough space for fiddling with the argv, continue
  */
  umask(((~my_umask) & 0666));
  if (my_setwd(mysql_data_home,MYF(MY_WME)))
  {
    application_end();				// Free application data
    unireg_abort(1);				/* purecov: inspected */
  }
  mysql_data_home[0]=FN_CURLIB;		// all paths are relative from here
  mysql_data_home[1]=0;
  server_init();
  table_cache_init();

  /* Setup log files */
  if (opt_log)
  {
    char tmp[FN_REFLEN];
    if (!opt_logname)
    {
      strmov(strnmov(tmp,uts_name.nodename,FN_REFLEN-5),".log");
      opt_logname=tmp;
    }
    mysql_log.open(opt_logname,MYSQL_LOG::NORMAL);
  }
  if (opt_update_log)
    mysql_update_log.open(opt_update_logname ? opt_update_logname :
			  uts_name.nodename,
			  MYSQL_LOG::NEW);
#ifdef __WIN32__
#define MYSQL_ERR_FILE "mysql.err"
    freopen(MYSQL_ERR_FILE,"a+",stdout);
    freopen(MYSQL_ERR_FILE,"a+",stderr);
    FreeConsole();				// Remove window
#endif

  /*
    init signals & alarm
    After this we can't quit by a simple unireg_abort
    */
  if (pthread_key_create(&THR_THD,NULL) || pthread_key_create(&THR_NET,NULL) ||
      pthread_key_create(&THR_MALLOC,NULL))
  {
    my_message(0,"Can't create thread-keys",MYF(0));
    exit(1);
  }
  init_signals();
  if (!opt_noacl && acl_init())
  {
    select_thread_in_use=0;
    (void) pthread_kill(signal_thread,SIGQUIT);
    (void) my_delete(pidfile_name,MYF(0));		// Not neaded anymore
    exit(1);
  }
#ifdef HAVE_DLOPEN
  if (!opt_noacl)
    udf_init();
#endif

  error_handler_hook = my_message_sql;
#ifdef HAVE_THR_SETCONCURRENCY
  VOID(thr_setconcurrency(20));			// We are iobound
#endif
#ifdef __WIN32__       //IRENA
  {
    hEventShutdown=CreateEvent(0, FALSE, FALSE, "MySqlShutdown");
    pthread_t hThread;
    pthread_create(&hThread,&connection_attrib,handle_shutdown,0);

    // On "Stop Service" we have to do regular shutdown
    Service.SetShutdownEvent(hEventShutdown);
  }
#endif

  printf(ER(ER_READY),my_progname,server_version,"");
  fflush(stdout);
  handle_connections();

  VOID(pthread_attr_destroy(&connection_attrib));
  (void) my_delete(pidfile_name,MYF(0));		// Not neaded anymore

#ifndef __WIN32__
  VOID(pthread_mutex_lock(&LOCK_thread_count));
  select_thread_in_use=0;			// For close_connections
  VOID(pthread_cond_signal(&COND_thread_count));
  VOID(pthread_mutex_unlock(&LOCK_thread_count));
#else
  // remove the event, because it will not be valid anymore
  Service.SetShutdownEvent(0);
  if(hEventShutdown) CloseHandle(hEventShutdown);
  // if it was started as service on NT try to stop the service
  if(Service.IsNT())
     Service.Stop();
#endif

  pthread_exit(0);
  return(0);					/* purecov: deadcode */
}

#ifdef __WIN32__
/* ------------------------------------------------------------------------
   main and thread entry function for Win32
   (all this is needed only to run mysqld as a service on WinNT)
 -------------------------------------------------------------------------- */
int mysql_service(void *p)
{
  win_main(Service.my_argc, Service.my_argv);
  return 0;
}

int main(int argc, char **argv)
{
  // check  environment variable OS
  if (Service.GetOS())  // "OS" defined; Should be NT
  {
    if (argc == 2)
    {
      if (!strcmp(argv[1],"-install") || !strcmp(argv[1],"--install"))
      {
	char path[FN_REFLEN];
	my_path(path, argv[0], "");                // Find name in path
	fn_format(path,argv[0],path,"",1+4+16);	   // Force use of full path
	if (!Service.Install("MySql","MySql",path))
	  MessageBox(NULL,"Failed to install Service","MySql",
		     MB_OK|MB_ICONSTOP);
	return 0;
      }
      else if (!strcmp(argv[1],"-remove") || !strcmp(argv[1],"--remove"))
      {
	Service.Remove("MySql");
	return 0;
      }
    }
    else if (argc == 1)            // No arguments; start as a service
    {
      // init service
      Service.Init("MySql",mysql_service);
      return 0;
    }
  }

  // This is a WIN95 machine or a start of mysqld as a standalone program
  // we have to pass the arguments, in case of NT-service this will be done
  // by ServiceMain()

  Service.my_argc=argc;
  Service.my_argv=argv;
  mysql_service(NULL);
  return 0;
}
/* ------------------------------------------------------------------------ */
#endif

	/* Handle new connections and spawn new process to handle them */

static void handle_connections(void)
{
  Socket sock,new_sock;
  uint opt,pkt_len,error_count=0,old_timeout;
  uint max_used_connection= (uint) (max(ip_sock,unix_sock)+1);
  fd_set readFDs,clientFDs;
  THD *thd;
  struct sockaddr_in cAddr;
  struct rand_struct rand;
  char scramble[9],*passwd;
  int error,ip_flags=0,socket_flags=0,flags;
  DBUG_ENTER("handle_connections");
  (void) my_pthread_getprio(pthread_self());		// For debugging

  randominit(&rand,(ulong) start_time,(ulong) start_time/2);
  FD_ZERO(&clientFDs);
  if (ip_sock != (Socket) -1)
  {
    FD_SET(ip_sock,&clientFDs);
#ifdef HAVE_FCNTL
    ip_flags = fcntl(ip_sock, F_GETFL, 0);
#endif
  }
#ifdef HAVE_SYS_UN_H
  FD_SET(unix_sock,&clientFDs);
  socket_flags=fcntl(unix_sock, F_GETFL, 0);
#endif
  pkt_len=0;

  DBUG_PRINT("general",("Waiting for connections."));
  while (!abort_loop)
  {
    memcpy(&readFDs,&clientFDs,sizeof(readFDs));
#ifdef HPUX
    if (select(max_used_connection,(int*) &readFDs,0,0,0) < 0)
      continue;
#else
    if (select((int) max_used_connection,&readFDs,0,0,0) < 0)
    {
      if (errno != EINTR)
      {
	if (!select_errors++ && !abort_loop)	/* purecov: inspected */
	  fprintf(stderr,"mysqld: Got error %d from select\n",errno); /* purecov: inspected */
      }
      continue;
    }
#endif	/* HPUX */
    /*
    ** Is this a new connection request
    */

#ifdef HAVE_SYS_UN_H
    if (FD_ISSET(unix_sock,&readFDs))
    {
      sock = unix_sock;
      flags= socket_flags;
    }
    else
#endif
    {
      sock = ip_sock;
      flags= ip_flags;
    }

#if !defined(NO_FCNTL_NONBLOCK)
    if (!(test_flags & 8))
    {
#if defined(O_NONBLOCK)
      fcntl(sock, F_SETFL, flags | O_NONBLOCK);
#elif defined(O_NDELAY)
      fcntl(sock, F_SETFL, flags | O_NDELAY);
#endif
    }
#endif /* NO_FCNTL_NONBLOCK */
    for (uint retry=0; retry < MAX_ACCEPT_RETRY; retry++)
    {
      size_socket length=sizeof(struct sockaddr_in);
      new_sock = accept(sock, (struct sockaddr *)&cAddr, &length);
      if (new_sock != INVALID_SOCKET || (errno != EINTR && errno != EAGAIN))
	break;
#if !defined(NO_FCNTL_NONBLOCK)
      if (!(test_flags & 8))
      {
	if (retry == MAX_ACCEPT_RETRY - 1)
	fcntl(sock, F_SETFL, flags);		// Try without O_NONBLOCK
      }
#endif
    }
#if !defined(NO_FCNTL_NONBLOCK)
    if (!(test_flags & 8))
    {
      fcntl(sock, F_SETFL, flags);
    }
#endif
    if (new_sock < 0)
    {
      if ((error_count++ & 255) == 0)		// This can happen often
	perror("Error in accept ");
      if (errno == ENFILE || errno == EMFILE)
	sleep(1);				// Give other threads some time
      continue;
    }
    {
      size_socket dummyLen;
      struct sockaddr dummy;
      dummyLen = sizeof(struct sockaddr);
      if (getsockname(new_sock,&dummy, &dummyLen) < 0)
      {
	perror("Error on new connection socket");
	VOID(shutdown(new_sock,2));
	VOID(closesocket(new_sock));
	continue;
      }
    }

    /*
    ** Don't allow too many connections
    */

    if (!(thd= new THD))
    {
      VOID(shutdown(new_sock,2)); VOID(closesocket(new_sock));
      continue;
    }
    if (my_net_init(&thd->net,new_sock))
    {
      close_connection(&thd->net,ER_OUT_OF_RESOURCES);
      delete thd;
      continue;
    }
    NET *net=&thd->net;				// For easy ref
    old_timeout=net->timeout;
    if (!(opt_specialflag & SPECIAL_NO_NEW_FUNC))
      net->timeout=CONNECT_TIMEOUT;		// Timeout for read
    if (protocol_version > 9)
      net->return_errno=1;
    if (thread_count >= max_connections+1 || abort_loop)
    {
      close_connection(net,ER_CON_COUNT_ERROR);
      delete thd;
      continue;
    }
    /*
    ** store the connection details
    */

    DBUG_PRINT("general",("New connection received on %d", new_sock));
    if (sock == ip_sock)
    {
      size_socket addrLen;

      addrLen = sizeof(struct sockaddr);
      /* check for win32 */
      if (getpeername(new_sock, (struct sockaddr *) &thd->remote, &addrLen))
      {
	close_connection(net,ER_BAD_HOST_ERROR);
	delete thd;
	continue;
      }
      thd->ip=my_strdup(inet_ntoa(thd->remote.sin_addr),MYF(0));
      if (specialflag & SPECIAL_NO_RESOLVE)
	thd->host=0;
      else
	thd->host=get_hostname(&thd->remote);
      DBUG_PRINT("general",("Host: %s  ip: %s",
			    thd->host ? thd->host : "unknown host",
			    thd->ip));
      if (NO_ACCESS & acl_getconnectright(thd->host, thd->ip))
      {
	close_connection(net,ER_HOST_NOT_PRIVILEGED);
	delete thd;
	continue;
      }
    }
    else
    {
      DBUG_PRINT("general",("Host: localhost"));
      thd->host = my_strdup(LOCAL_HOST,MYF(0));
      thd->ip=0;
      bzero(&thd->local, sizeof(struct sockaddr));
      bzero(&thd->remote,sizeof(struct sockaddr));
    }

    opt=1;
    VOID(setsockopt(new_sock,SOL_SOCKET,SO_KEEPALIVE,
		    (char *) &opt, sizeof(opt)));
    {
      char buff[60],*end;
      end=strmov(buff,server_version)+1;
      int4store((uchar*) end,thread_id);
      end+=4;
      for (uint i=0; i < 8 ; i++)
	scramble[i]= *end++ = (char) (rnd(&rand)*94+33);
      scramble[8]=0;
      *end=0;
      int2store(end+1,CLIENT_LONG_FLAG | CLIENT_CONNECT_WITH_DB);
      end+=3;
      if (net_write_command(net,protocol_version,(byte*) buff,
			    (uint) (end-buff)) ||
	  (pkt_len=my_net_read(net)) == packet_error || pkt_len < 6)
      {
	close_connection(net,ER_HANDSHAKE_ERROR);
	delete thd;
	continue;
      }
    }
    if (thd->packet.alloc(net_buffer_length))
    {
      close_connection(net,ER_OUTOFMEMORY);
      delete thd;
      continue;
    }
    thd->client_capabilities=uint2korr(net->buff);
    thd->max_packet_length=uint3korr(net->buff+2);
    if (!(thd->user = my_strdup((char*) net->buff+5, MYF(MY_FAE))))
    {
      close_connection(net,ER_OUTOFMEMORY);
      delete thd;
      continue;
    }
    passwd= strend((char*) net->buff+5)+1;
    thd->thread_id=thread_id++;
    thd->master_access=acl_getroot(thd->host, thd->ip, thd->user, passwd,
				   scramble, &thd->priv_user,
				   protocol_version == 9 ||
				   !(thd->client_capabilities &
				     CLIENT_LONG_PASSWORD));
    thd->rand=rand;
    thd->password=test(passwd[0]);
    if (thd->client_capabilities & CLIENT_CONNECT_WITH_DB)
    {
      if (!(thd->db=my_strdup(strend(passwd)+1,MYF(MY_FAE))))
      {
	close_connection(net,ER_OUTOFMEMORY);
	delete thd;
	continue;
      }
    }

    DBUG_PRINT("general",
	       ("Capabilities: %d  packet_length: %d  Host: %s  User: %s  Using password: %s  Access: %u  db: %s",
		thd->client_capabilities, thd->max_packet_length,
		thd->host ? thd->host : thd->ip, thd->priv_user,
		passwd[0] ? "yes": "no",
		thd->master_access, thd->db ? thd->db : ""));
    if (thd->master_access & NO_ACCESS)
    {
      net_printf(net, ER_ACCESS_DENIED_ERROR,
		 thd->user,
		 thd->host ? thd->host : thd->ip,
		 passwd[0] ? ER(ER_YES) : ER(ER_NO));
      mysql_log.write(COM_CONNECT,ER(ER_ACCESS_DENIED_ERROR),
		 thd->user,
		 thd->host ? thd->host : thd->ip,
		 passwd[0] ? ER(ER_YES) : ER(ER_NO));
      close_connection(net,0);
      delete thd;
      continue;
    }
    if (thread_count >= max_connections &&
	!(thd->master_access & PROCESS_ACL))
    {						// too many connections
      close_connection(net,ER_CON_COUNT_ERROR);
      delete thd;
      continue;
    }

    /* Start a new thread to handle connection */
    if (pthread_mutex_lock(&LOCK_thread_count))
    {
      DBUG_PRINT("error",("Can't lock LOCK_thread_count"));
      close_connection(net,ER_OUT_OF_RESOURCES);
      delete thd;
      continue ;
    }
    threads.append(thd);
    net->timeout=old_timeout;

    if ((error=pthread_create(&thd->real_id,&connection_attrib,
			      handle_one_connection,
			      (void*) thd)))
    {
      DBUG_PRINT("error",
		 ("Can't create thread to handle request (error %d)",
		  error));
      delete thd;
      VOID(pthread_mutex_unlock(&LOCK_thread_count));
      close_connection(net,ER_OUT_OF_RESOURCES);
      continue;
    }
    thread_count++;
    DBUG_PRINT("info",(("Thread created")));
    VOID(pthread_mutex_unlock(&LOCK_thread_count));
  }
  DBUG_VOID_RETURN;
}


/******************************************************************************
** handle start options
******************************************************************************/

enum options {OPT_ISAM_LOG=256,OPT_SKIP_NEW,OPT_SKIP_GRANT,OPT_SKIP_LOCK,
	      OPT_USE_LOCKING,OPT_SOCKET,OPT_UPDATE_LOG,
	      OPT_SKIP_RESOLVE,OPT_SKIP_NETWORKING,OPT_SECURE,
	      OPT_BIND_ADDRESS,OPT_PID_FILE,OPT_SKIP_PRIOR,OPT_BIG_TABLES,
	      OPT_STANDALONE};

static struct option long_options[] =
{
  {"basedir",	required_argument, 0, 'b'},
  {"big-tables", no_argument,0,(int) OPT_BIG_TABLES},
  {"bind-address", required_argument, 0, OPT_BIND_ADDRESS},
  {"datadir",	required_argument, 0, 'h'},
#ifndef DBUG_OFF
  {"debug",	optional_argument, 0, '#'},
#endif
  {"exit-info", optional_argument, 0, 'T'},
  {"help",	no_argument,	   0, '?'},
  {"log",	optional_argument, 0, 'l'},
  {"language",	required_argument, 0, 'L'},
  {"log-isam",	optional_argument, 0, (int) OPT_ISAM_LOG},
  {"log-update",optional_argument, 0, (int) OPT_UPDATE_LOG},
  {"new",	no_argument,	   0, 'n'},
  {"old-protocol", no_argument,    0, 'o'},
  {"pid-file",	required_argument, 0, (int) OPT_PID_FILE},
  {"port",	required_argument, 0, 'P'},
  {"secure",	no_argument,	   0, (int) OPT_SECURE},
  {"socket",	required_argument, 0, (int) OPT_SOCKET},
  {"set-variable",required_argument, 0, 'O'},
  {"skip-grant-tables", no_argument,0,(int) OPT_SKIP_GRANT},
  {"skip-locking",	no_argument,0,(int) OPT_SKIP_LOCK},
  {"skip-name-resolve", no_argument,0,(int) OPT_SKIP_RESOLVE},
  {"skip-new",	 no_argument,	   0, (int) OPT_SKIP_NEW},
  {"skip-networking",	no_argument,0, (int) OPT_SKIP_NETWORKING},
  {"skip-thread-priority",	no_argument,0,(int) OPT_SKIP_PRIOR},
  {"standalone",	no_argument,0, (int) OPT_STANDALONE},
  {"use-locking",	no_argument,0,(int) OPT_USE_LOCKING},
  {"version",	no_argument,	   0, 'V'},
  {0, 0, 0, 0}
};

CHANGEABLE_VAR changeable_vars[] = {
  { "back_log", (long*) &back_log,5,1,65535,0,1},
  { "join_buffer", (long*) &join_buff_size,128*1024L,
    IO_SIZE*2+MALLOC_OVERHEAD,~0L,MALLOC_OVERHEAD,IO_SIZE },
  { "key_buffer", (long*) &keybuff_size,KEY_CACHE_SIZE,MALLOC_OVERHEAD,
    (long) ~0, MALLOC_OVERHEAD, IO_SIZE },
  { "max_allowed_packet",(long*) &max_allowed_packet,65536,16384,~0L,
    MALLOC_OVERHEAD,1024},
  { "max_connections", (long*) &max_connections,90,1,16384,0,1},
  { "max_join_size",(long*) &max_join_size,~0L,1,~0L,0,1},
  { "max_sort_length",(long*) &max_item_sort_length,1024,4,8192*1024L,0,1},
  { "net_buffer_length",(long*) &net_buffer_length,8192,1024,1024*1024L,
    MALLOC_OVERHEAD,1024},
  { "record_buffer", (long*) &my_default_record_cache_size,128*1024L,
    IO_SIZE*2+MALLOC_OVERHEAD,~0L,MALLOC_OVERHEAD,IO_SIZE },
  { "sort_buffer", (long*) &sortbuff_size,MAX_SORT_MEMORY,
    MIN_SORT_MEMORY+MALLOC_OVERHEAD,~0L,MALLOC_OVERHEAD,1 },
  { "table_cache",  (long*) &table_cache_size,64,1,16384,0,1},
  { "tmp_table_size",  (long*) &tmp_table_size,1024*1024L,1024,~0L,
    MALLOC_OVERHEAD,1},
  { "thread_stack", (long*) &thread_stack,1024*64,1024*32,~0L,0,1024},
  { NullS,(long*) 0,0,0,0,0,0,} };

struct show_var_st variables[]= {
  {"back_log", (char*) &back_log, SHOW_LONG},
  {"basedir",  mysql_home,SHOW_CHAR},
  {"datadir",  mysql_data_home,SHOW_CHAR},
  {"join_buffer", (char*) &join_buff_size, SHOW_LONG},
  {"key_buffer", (char*) &keybuff_size, SHOW_LONG},
  {"language", language, SHOW_CHAR},
  {"max_allowed_packet", (char*) &max_allowed_packet, SHOW_LONG},
  {"max_connections", (char*) &max_connections, SHOW_LONG},
  {"max_join_size", (char*) &max_join_size, SHOW_LONG},
  {"max_sort_length", (char*) &max_item_sort_length,SHOW_LONG},
  {"net_buffer_length", (char*) &net_buffer_length, SHOW_LONG},
  {"port", (char*) &mysql_port, SHOW_INT},
  {"record_buffer", (char*) &my_default_record_cache_size,SHOW_LONG},
  {"skip_locking", (char*) &my_disable_locking, SHOW_INT},
  {"socket", (char*) &mysql_unix_port, SHOW_CHAR_PTR},
  {"sort_buffer", (char*) &sortbuff_size,SHOW_LONG},
  {"table_cache", (char*) &table_cache_size,SHOW_LONG},
  {"thread_stack", (char*) &thread_stack,SHOW_LONG},
  {"tmp_table_size", (char*) &tmp_table_size,SHOW_LONG},
  {NullS,NullS,SHOW_LONG}
};

static void print_version(void)
{
  printf("%s  Ver %s for %s on %s\n",my_progname,
	 server_version,SYSTEM_TYPE,MACHINE_TYPE);
}

static void usage(void)
{
  print_version();
  puts("Copyright (C) 1979-1998 TcX AB & Monty Program KB & Detron HB.");
  puts("All rights reserved. Se the file PUBLIC for licence information.");
  puts("This software comes with ABSOLUTELY NO WARRANTY: see the file PUBLIC for details.\n");
  puts("Starts the mysql server\n");

  printf("Usage: %s [OPTIONS]\n", my_progname);
  puts("\n\
  -b, --basedir=path	Path to installation directory. All paths are\n\
			usually resolved relative to this\n\
  --big-tables		Allow big result sets by saving all temporary sets\n\
			on file (Solves most 'table full' errors)\n\
  --bind-address=IP	Ip address to bind to\n\
  -h, --datadir=path	Path to the database root");
#ifndef DBUG_OFF
  printf("\
  -#, --debug[=...]     Debug log. Default is '%s'\n",default_dbug_option);
#endif
  puts("\
  -T, --exit-info	Print some debug info at exit\n\
  -?, --help		Display this help and exit\n\
  -L, --language=...	Client error messages in given language. May be\n\
			given as a full path\n\
  -l, --log[=file]	Log connections and queries to file\n\
  --log-update[=file]	Log updates to file.# where # is a unique number\n\
			if not given.\n\
  --log-isam[=file]	Log all isam changes to file\n\
  --pid-file=path	Pid file used by safe_mysqld\n\
  -P, --port=...	Port number to use for connection\n\
  -n, --new		Use very new possibly 'unsafe' functions\n\
  -o, --old-protocol	Use the old (3.20) protocol\n\
  --secure		Enable some security checks that takes a long time\n\
			(Reverse host lookup for TCP/IP connections)\n\
  -O, --set-variable var=option\n\
			Give a variable an value. --help lists variables\n\
  -Sg, --skip-grant-tables\n\
			Start without grant tables. This gives anyone FULL\n\
			ACCESS to all tables!\n\
  --skip-locking	Don't use system locking. To use isamchk one has\n\
			to shut down the server.\n\
  --skip-name-resolve	Don't resolve hostnames.\n\
			All hostnames are IP's or 'localhost'\n\
  --skip-networking	Don't allow connection with TCP/IP.\n\
  --skip-new		Don't use new, possible wrong routines.\n\
  --skip-thread-priority\n\
			Don't give threads different priorities.\n\
  --socket=...		Socket file to use for connection\n\
  -V, --version		output version information and exit\n");
#ifdef __WIN32__
  puts("NT specific options:\n\
  --install		Install mysqld as a service\n\
  --remove		Remove mysqld from the service list\n\
  --standalone		Dummy option to start as a standalone program\n");
#endif

  fix_paths();
  set_ports();
  printf("base_dir:    %s\n",mysql_home);
  printf("data_dir:    %s\n",mysql_data_home);
  printf("language:    %s\n",language);
  printf("pid file:    %s\n",pidfile_name);
  if (opt_logname)
    printf("logfile:     %s\n",opt_logname);
  if (opt_update_logname)
    printf("update log:  %s\n",opt_update_logname);
  printf("TCP port:    %d\n",mysql_port);
#if defined(HAVE_SYS_UN_H) && !defined(HAVE_mit_thread)
  printf("Unix socket: %s\n",mysql_unix_port);
#endif
  if (my_disable_locking)
    puts("\nsystem locking is not in use");
  if (opt_noacl)
    puts("\nGrant tables are not used. All users have full access rights");
  printf("\nPossibly variables to option --set-variable (-O) are:\n");
  for (uint i=0 ; changeable_vars[i].name ; i++)
    printf("%-20s  current value: %ul\n",
	   changeable_vars[i].name,
	   (ulong) *changeable_vars[i].varptr);
}

	/* Initiates DEBUG - but no debugging here ! */

static void get_options(int argc,char **argv)
{
  int c,option_index=0;
  char *pos;
  set_all_changeable_vars(changeable_vars);
#if !defined(my_pthread_setprio) && !defined(HAVE_PTHREAD_SETSCHEDPARAM)
  opt_specialflag|= SPECIAL_NO_PRIOR;
#endif

  VOID(strmov(language,LANGUAGE));	/* Default-language */
  VOID(strmov(mysql_data_home,get_relative_path(DATADIR)));
  if (!(pos = getenv("MY_BASEDIR_VERSION")))
    pos=DEFAULT_MYSQL_HOME;			/* purecov: inspected */
  VOID(strmov(mysql_home,pos));
#ifdef HAVE_mit_thread
  my_disable_locking=1;
#endif
  my_bind_addr=htonl(INADDR_ANY);

  while ((c=getopt_long(argc,argv,"b:h:#::T::?l::L:O:P:S::noVvI?",
			long_options, &option_index)) != EOF)
  {
    switch(c) {
#ifndef DBUG_OFF
    case '#':
      DBUG_PUSH(optarg ? optarg : default_dbug_option);
      opt_endinfo=1;				/* unireg: memory allocation */
      break;
#endif
    case 'b':
      strmov(mysql_home,optarg);
      break;
    case 'l':
      opt_log=1;
      opt_logname=optarg;			// Use hostname.log if null
      break;
    case 'h':
      strmov(mysql_data_home,optarg);
      break;
    case 'L':
      strmov(language,optarg);
      break;
    case 'n':
      opt_specialflag|= SPECIAL_NEW_FUNC;
      break;
    case 'o':
      protocol_version=PROTOCOL_VERSION-1;
      break;
    case 'O':
      if (set_changeable_var(optarg, changeable_vars))
      {
	usage();
	exit(1);
      }
      break;
    case 'P':
      mysql_port= (unsigned int) atoi(optarg);
      break;
    case OPT_SOCKET:
      mysql_unix_port= optarg;
      break;
    case 'v':
    case 'V':
      print_version();
      exit(0);
    case 'I':
    case '?':
      usage();
      exit(0);
    case 'T':
      test_flags= optarg ? (uint) atoi(optarg) : (uint) ~0;
      opt_endinfo=1;
      break;
    case 'S':
      if (!optarg)
	opt_specialflag|= SPECIAL_NO_NEW_FUNC;
      else if (!strcmp(optarg,"l"))
	my_disable_locking=1;
      else if (!strcmp(optarg,"g"))
	opt_noacl=1;
      else
      {
	usage();
	exit(1);
      }
      break;
    case (int) OPT_BIG_TABLES:
      thd_startup_options|=OPTION_BIG_TABLES;
      break;
    case (int) OPT_ISAM_LOG:
      if (optarg)
	nisam_log_filename=optarg;
      (void) ni_log(1);
      break;
    case (int) OPT_UPDATE_LOG:
      opt_update_log=1;
      opt_update_logname=optarg;		// Use hostname.# if null
      break;
    case (int) OPT_SKIP_NEW:
      opt_specialflag|= SPECIAL_NO_NEW_FUNC;
      break;
    case (int) OPT_SKIP_PRIOR:
      opt_specialflag|= SPECIAL_NO_PRIOR;
      break;
    case (int) OPT_SKIP_GRANT:
      opt_noacl=1;
      break;
    case (int) OPT_SKIP_LOCK:
      my_disable_locking=1;
      break;
    case (int) OPT_USE_LOCKING:
      my_disable_locking=0;
      break;
    case (int) OPT_SKIP_RESOLVE:
      opt_specialflag|=SPECIAL_NO_RESOLVE;
      break;
    case (int) OPT_SKIP_NETWORKING:
      opt_disable_networking=1;
      break;
    case (int) OPT_SECURE:
      opt_secure=1;
      break;
    case (int) OPT_BIND_ADDRESS:
      if (optarg && isdigit(optarg[0]))
      {
	my_bind_addr = (ulong) inet_addr(optarg);
      }
      else
      {
	struct hostent *ent;
	if (!optarg || !optarg[0])
	  ent=gethostbyname(optarg);
	else
	{
	  char myhostname[255];
	  if (gethostname(myhostname,sizeof(myhostname)) < 0)
	  {
	    perror("Can't start server: cannot get my own hostname!");
	    exit(1);
	  }
	  ent=gethostbyname(myhostname);
	}
	if (!ent)
	{
	  perror("Can't start server: cannot resolve hostname!");
	  exit(1);
	}
	my_bind_addr = (ulong) ((in_addr*)ent->h_addr_list[0])->s_addr;
      }
      break;
    case (int) OPT_PID_FILE:
      strmov(pidfile_name,optarg);
      break;
    case (int) OPT_STANDALONE:		/* Dummy option for NT */
      break;
    default:
      fprintf(stderr,"%s: Unrecognized option: %c\n",my_progname,c);
      usage();
      exit(1);
    }
  }
  if (argc != optind)
  {
    fprintf(stderr,"%s: Too many parameters\n",my_progname);
    usage();
    exit(1);
  }
  fix_paths();
}


static char *get_relative_path(char *path)
{
  if (test_if_hard_path(path) && is_prefix(path,DEFAULT_MYSQL_HOME))
  {
    path+=strlen(DEFAULT_MYSQL_HOME);
    while (*path == FN_LIBCHAR)
      path++;
  }
  return path;
}


static void fix_paths(void)
{
  (void) fn_format(mysql_home,mysql_home,"","",16); // Remove symlinks
  convert_dirname(mysql_home);
  convert_dirname(mysql_data_home);
  convert_dirname(language);
  (void) my_load_path(mysql_home,mysql_home,""); // Resolve current dir
  (void) my_load_path(mysql_data_home,mysql_data_home,mysql_home);
  (void) my_load_path(pidfile_name,pidfile_name,mysql_data_home);

  char buff[FN_REFLEN],*sharedir=get_relative_path(SHAREDIR);
  if (test_if_hard_path(sharedir))
    strmov(buff,sharedir);			/* purecov: tested */
  else
    strxmov(buff,mysql_home,sharedir,NullS);
  convert_dirname(buff);
  (void) my_load_path(language,language,buff);
}

	/* Called by unireg_end before exit */

static void application_end(void)
{
  DBUG_ENTER("application_end");
  acl_free();
  table_cache_free();
  lex_free();				/* Free some memory */
#ifdef HAVE_DLOPEN
  if (!opt_noacl)
    udf_free();
#endif
  DBUG_VOID_RETURN;
}

#ifdef SET_RLIMIT_NOFILE
static uint set_maximum_open_files(uint max_file_limit)
{
  struct rlimit rlimit;
  ulong old_cur;

  if (!getrlimit(RLIMIT_NOFILE,&rlimit))
  {
    old_cur=rlimit.rlim_cur;
    if (rlimit.rlim_cur >= max_file_limit)	// Nothing to do
      return rlimit.rlim_cur;			/* purecov: inspected */
    rlimit.rlim_cur=rlimit.rlim_max=max_file_limit;
    if (setrlimit(RLIMIT_NOFILE,&rlimit))
    {
      fprintf(stderr,
	      "Warning: setrlimit couldn't increase number of open files to more than %ld\n",
	      old_cur);		/* purecov: inspected */
      max_file_limit=old_cur;
    }
    else
    {
      VOID(getrlimit(RLIMIT_NOFILE,&rlimit));
      if ((uint) rlimit.rlim_cur != max_file_limit)
	fprintf(stderr,
		"Warning: setrlimit returned ok, but didn't change limits. Max open files is %ld\n",
		(ulong) rlimit.rlim_cur); /* purecov: inspected */
      max_file_limit=rlimit.rlim_cur;
    }
  }
  return max_file_limit;
}
#endif


static my_string get_hostname(struct sockaddr_in *remote)
{
  struct hostent *hp, *check;
  char *name;

  LINT_INIT(check);
#if defined(HAVE_GETHOSTBYADDR_R) && defined(HAVE_SOLARIS_STYLE_GETHOST)
  char buff[2048],buff2[2048];
  int tmp_errno;
  struct hostent tmp_hostent, tmp_hostent2;
 #ifdef HAVE_purify
  bzero(buff,sizeof(buff));		// Bug in purify
#endif
  if (!(hp=gethostbyaddr_r((char*) &remote->sin_addr,sizeof(remote->sin_addr),
			   AF_INET,
			   &tmp_hostent,buff,sizeof(buff),&tmp_errno)))
  {
    DBUG_PRINT("error",("gethostbyaddr_r returned %d",tmp_errno));
    return 0;
  }
  if (!(check=gethostbyname_r(hp->h_name,&tmp_hostent2,buff2,sizeof(buff2),
			      &tmp_errno)))
  {
    DBUG_PRINT("error",("gethostbyname_r returned %d",tmp_errno));
    return 0;
  }
  name=my_strdup(hp->h_name,MYF(0));
#else
  VOID(pthread_mutex_lock(&LOCK_thread_count));
  if (!(hp=gethostbyaddr((char*) &remote->sin_addr,sizeof(remote->sin_addr),
			 AF_INET)))
  {
    DBUG_PRINT("error",("gethostbyaddr returned %d",errno));
    VOID(pthread_mutex_unlock(&LOCK_thread_count));
    return 0;
  }
  name=my_strdup(hp->h_name,MYF(0));
  if (opt_secure)
    check=gethostbyname(name);
  VOID(pthread_mutex_unlock(&LOCK_thread_count));
  if (opt_secure && !check)
  {
    DBUG_PRINT("error",("gethostbyname_r returned %d",errno));
    my_free(name,MYF(0));
    return 0;
  }
#endif

  /* Don't accept hostnames that starts with digits because they may be
     false ip:s */
  if (isdigit(name[0]))
  {
    char *pos;
    for (pos= name+1 ; isdigit(*pos); pos++) ;
    if (*pos == '.')
    {
      DBUG_PRINT("error",("mysqld doesn't accept hostnames that starts with a number followed by a '.'"));
      my_free(name,MYF(0));
      return 0;
    }
  }
  if (!opt_secure)
    return name;
  /* Check that 'gethostbyname' returned the used ip */
  for (int i = 0; check->h_addr_list[i]; i++)
    if (*(uint32*)(check->h_addr_list)[i] == remote->sin_addr.s_addr)
      return name;
  DBUG_PRINT("error",("Couldn't verify hostname with gethostbyname"));
  my_free(name,MYF(0));
  return 0;
}


/*****************************************************************************
** Instansiate templates
*****************************************************************************/

#ifdef __GNUC__
/* Used templates */
template class I_List<THD>;
#endif
