; server.scm
; server example for sockets in Scheme using bigloo
; Sven Hartrumpf (C) 1997


;; module definition

(module server
  (include "sockets.sch")
  (include "sockets.scm")
  (main server-args))


;; top level

(define server-args (lambda (args)
  (let ((client-message #f)
        (reply-message #f)
        (result #f)
        (server-socket #f)
        (service-socket #f))
  ;; create socket
  (set! server-socket (open-stream-socket))
  (display "open-stream-socket: server-socket: ") (write server-socket) (newline)
  ;; bind socket
  (set! result (bind-socket server-socket 5005))
  (display "bind-socket: result: ") (write result) (newline)
  ;; listen
  (set! result (listen-socket server-socket 5))
  (display "listen-socket: result: ") (write result) (newline)
  (do ((end #f))
      (end)
    ;; accept connections
    (set! service-socket (accept-socket server-socket))
    (display "accept-socket: service-socket: ") (write service-socket) (newline)
    ;; receive message from a client
    (set! client-message (receive-socket service-socket))
    (display "receive-socket: client-message: ") (write client-message) (newline)
    ;; send reply message to client
    (set! reply-message (list->string (reverse (string->list client-message))))
    (set! result (send-socket service-socket reply-message))
    (display "send-socket: result: ") (write result) (newline)
    ;; shutdown service socket
    (set! result (shutdown-socket service-socket))
    (display "shutdown-socket: result: ") (write result) (newline)
    ;; close service socket
    (set! result (close-socket service-socket))
    (display "close-socket: result: ") (write result) (newline)
    (cond ((string=? client-message "quit")
           (set! end #t))))
  ;; close server socket (no shutdown needed as there are no connections)
  (set! result (close-socket server-socket))
  (display "close-socket: result: ") (write result) (newline)
)))
