;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Eval/byte-code.sch        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 25 09:12:35 1994                          */
;*    Last change :  Fri Nov  3 09:46:05 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Les macros utiles pour la compilation et l'interpretation du     */
;*    byte-code                                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    byte-code? ...                                                   */
;*---------------------------------------------------------------------*/
(define-macro (byte-code? exp)
   `(vector? ,exp))

;*---------------------------------------------------------------------*/
;*    make-byte-code ...                                               */
;*---------------------------------------------------------------------*/
(define-macro (make-byte-code code loc value)
   `(vector ,code ,loc ,value))

;*---------------------------------------------------------------------*/
;*    code-of-byte-code ...                                            */
;*---------------------------------------------------------------------*/
(define-macro (code-of-byte-code bcode)
   `(vector-ref ,bcode 0))

;*---------------------------------------------------------------------*/
;*    byte-code-code-set! ...                                          */
;*---------------------------------------------------------------------*/
(define-macro (byte-code-code-set! bcode code)
   `(vector-set! ,bcode 0 ,code))

;*---------------------------------------------------------------------*/
;*    pos-of-byte-code ...                                             */
;*---------------------------------------------------------------------*/
(define-macro (pos-of-byte-code bcode)
   `(vector-ref ,bcode 1))

;*---------------------------------------------------------------------*/
;*    value-of-byte-code ...                                           */
;*---------------------------------------------------------------------*/
(define-macro (value-of-byte-code bcode)
   `(vector-ref ,bcode 2))

;*---------------------------------------------------------------------*/
;*    byte-code-value-set! ...                                         */
;*---------------------------------------------------------------------*/
(define-macro (byte-code-value-set! bcode value)
   `(vector-set! ,bcode 2 ,value))
