;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Trace/walk.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 13 13:53:58 1995                          */
;*    Last change :  Mon Dec 22 14:46:59 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The introduction of trace in debugging mode.                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module trace_walk
   (include "Engine/pass.sch"
	    "Ast/node.sch")
   (import  tools_shape
	    tools_error
	    tools_misc
	    type_env
	    ast_sexp
	    engine_param)
   (export  (trace-walk! tree)))

;*---------------------------------------------------------------------*/
;*    trace-walk! ...                                                  */
;*---------------------------------------------------------------------*/
(define (trace-walk! globals)
   (pass-prelude "Trace")
   (for-each trace-fun! globals)
   (pass-postlude globals))

;*---------------------------------------------------------------------*/
;*    trace-fun! ...                                                   */
;*    -------------------------------------------------------------    */
;*    We don't trace predicates. It is useless and make the code       */
;*    much bigger in safe modes.                                       */
;*---------------------------------------------------------------------*/
(define (trace-fun! var)
   (let* ((fun  (variable-value var))
	  (body (sfun-body fun))
	  (type (variable-type var)))
      (if (and (not (fun-predicate-of fun))
	       (not (memq 'no-trace (sfun-property fun))))
	  (begin
	     (enter-function (variable-id var))
	     (let* ((new-body  (if (>=fx *compiler-debug* 2)
				   (trace-node body)
				   body))
		    (new2-body (make-traced-node new-body
						 type
						 (variable-id var))))
		(sfun-body-set! fun new2-body)
		(leave-function))))))
   
;*---------------------------------------------------------------------*/
;*    make-traced-node ...                                             */
;*---------------------------------------------------------------------*/
(define (make-traced-node::let-var node::node type::type symbol::symbol)
   (let* ((loc  (node-loc node))
	  (aux  (gensym 'aux))
	  (taux (symbol-append aux 4dots (type-id type)))
	  (sym  (gensym 'symbol))
	  (exp `(let ((,sym ',symbol))
		   (let ()
		      (c-push-trace ,sym)
		      ;; this dummy `let' and `set!' and used to normalize
		      ;; the code and disable the reduction optimizations
		      ;; on `push-trace' nodes (at least it wont produce
		      ;; any code and then, has no cost).
		      (set! ,sym ,sym)
		      (let ((,taux ,node))
			 (c-pop-trace)
			 ,aux))))
	  (node (sexp->node exp '() loc 'value)))
      (let-var-removable?-set! node #f)
      node))

;*---------------------------------------------------------------------*/
;*    trace-node ...                                                   */
;*---------------------------------------------------------------------*/
(define-generic (trace-node::node node::node)
   node)

;*---------------------------------------------------------------------*/
;*    trace-node ::sequence ...                                        */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::sequence)
   (trace-node*! (sequence-nodes node))
   node)

;*---------------------------------------------------------------------*/
;*    trace-node ::app ...                                             */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::app)
   (trace-node*! (app-args node))
   node)
 
;*---------------------------------------------------------------------*/
;*    trace-node ::app-ly ...                                          */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::app-ly)
   (with-access::app-ly node (fun arg)
      (set! fun (trace-node fun))
      (set! arg (trace-node arg))
      node))

;*---------------------------------------------------------------------*/
;*    trace-node ::funcall ...                                         */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::funcall)
   (with-access::funcall node (fun args)
      (set! fun (trace-node fun))
      (trace-node*! args)
      node))

;*---------------------------------------------------------------------*/
;*    trace-node ::pragma ...                                          */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::pragma)
   (trace-node*! (pragma-args node))
   node)

;*---------------------------------------------------------------------*/
;*    trace-node ::cast ...                                            */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::cast)
   (trace-node (cast-arg node))
   node)

;*---------------------------------------------------------------------*/
;*    trace-node ::setq ...                                            */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::setq)
   (setq-value-set! node (trace-node (setq-value node)))
   node)

;*---------------------------------------------------------------------*/
;*    trace-node ::conditional ...                                     */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::conditional)
   (with-access::conditional node (test true false)
       (set! test (trace-node test))
       (set! true (trace-node true))
       (set! false (trace-node false))
       node))

;*---------------------------------------------------------------------*/
;*    trace-node ::fail ...                                            */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::fail)
   (with-access::fail node (proc msg obj)
      (set! proc (trace-node proc))
      (set! msg (trace-node msg))
      (set! obj (trace-node obj))
      node))

;*---------------------------------------------------------------------*/
;*    trace-node ::select ...                                          */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::select)
   (with-access::select node (clauses test)
      (set! test (trace-node test))
      (for-each (lambda (clause)
		   (set-cdr! clause (trace-node (cdr clause))))
		clauses)
      node))

;*---------------------------------------------------------------------*/
;*    trace-node ::let-fun ...                                         */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::let-fun)
   (with-access::let-fun node (body locals)
      (for-each trace-fun! locals)
      (set! body (trace-node body))
      node))

;*---------------------------------------------------------------------*/
;*    trace-node ::let-var ...                                         */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::let-var)
   (with-access::let-var node (body bindings)
      (for-each (lambda (binding)
		   (set-cdr! binding (trace-node (cdr binding))))
		bindings)
      (set! body (trace-node body))
      node))

;*---------------------------------------------------------------------*/
;*    trace-node ::set-ex-it ...                                       */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::set-ex-it)
   (set-ex-it-body-set! node (trace-node (set-ex-it-body node)))
   node)

;*---------------------------------------------------------------------*/
;*    trace-node ::jump-ex-it ...                                      */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::jump-ex-it)
   (with-access::jump-ex-it node (exit value)
      (set! exit (trace-node exit)) 
      (set! value (trace-node value))
      node))

;*---------------------------------------------------------------------*/
;*    trace-node ::make-box ...                                        */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::make-box)
   (make-box-value-set! node (trace-node (make-box-value node)))
   node)

;*---------------------------------------------------------------------*/
;*    trace-node ::box-ref ...                                         */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::box-ref)
   (box-ref-var-set! node (trace-node (box-ref-var node)))
   node)

;*---------------------------------------------------------------------*/
;*    trace-node ::box-set! ...                                        */
;*---------------------------------------------------------------------*/
(define-method (trace-node node::box-set!)
   (with-access::box-set! node (var value)
      (set! var (trace-node var))
      (set! value (trace-node value))
      node))

;*---------------------------------------------------------------------*/
;*    trace-node*! ...                                                 */
;*---------------------------------------------------------------------*/
(define (trace-node*! node*)
   (if (null? node*)
       'done
       (begin
	  (set-car! node* (trace-node (car node*)))
	  (trace-node*! (cdr node*)))))
   
   


