;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Expand/eps.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 14:56:58 1994                          */
;*    Last change :  Tue Mar  3 21:19:24 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The macro expanser inspired by:                                  */
;*    << Expansion-Passing Style: Beyond Conventional Macro >>,        */
;*    Dybvig, Friedman & Haynes  -- ACM 1986 (LFP) page 143            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_eps
   (include "Expand/expander.sch"
	    "Tools/trace.sch"
	    "Engine/pass.sch"
	    "Ast/unit.sch")
   (import  tools_speek
	    tools_error
	    tools_progn
	    type_type
	    ast_ident
	    expand_expander)
   (export  (with-lexical          ::obj ::obj ::procedure)
	    (lexical-stack)
	    (add-macro-definition! ::obj)
	    (comptime-expand       ::obj)
	    (comptime-expand-once  ::obj)
	    (expand-units          ::obj)))

;*---------------------------------------------------------------------*/
;*    The user macro list.                                             */
;*---------------------------------------------------------------------*/
(define *macro* '())

;*---------------------------------------------------------------------*/
;*    add-macro! ...                                                   */
;*---------------------------------------------------------------------*/
(define (add-macro-definition! form)
   (set! *macro* (cons form *macro*)))

;*---------------------------------------------------------------------*/
;*    *lexical-stack* ...                                              */
;*    -------------------------------------------------------------    */
;*    This global variable allow us to simulate a stack to know        */
;*    when a variable `over-define' a `O-macro'. It is not as          */
;*    beautiful as a extra parameter to `expand' but it is             */
;*    easier to implement.                                             */
;*---------------------------------------------------------------------*/
(define *lexical-stack* '())

;*---------------------------------------------------------------------*/
;*    lexical-stack ...                                                */
;*---------------------------------------------------------------------*/
(define (lexical-stack)
   *lexical-stack*)

;*---------------------------------------------------------------------*/
;*    with-lexical ...                                                 */
;*---------------------------------------------------------------------*/
(define (with-lexical new mark thunk)
   (let ((new-id (map fast-id-of-id new))
	 (old-lexical-stack *lexical-stack*))
      (set! *lexical-stack*
	    (append (map (lambda (o) (cons o mark)) new-id) *lexical-stack*))
      (let ((res (thunk)))
	 (set! *lexical-stack* old-lexical-stack)
	 res)))
    
;*---------------------------------------------------------------------*/
;*    expand-units ...                                                 */
;*    -------------------------------------------------------------    */
;*    We expand the user code and the produced codes.                  */
;*---------------------------------------------------------------------*/
(define (expand-units units)
   (pass-prelude "Expand")
   ;; We set all macros definitions seen in include files.
   (for-each comptime-expand (reverse! *macro*))
   ;; imported inlined functions which are not coming from library
   ;; have to be expanded. It is not obliged to perform macro-expansion
   ;; on library functions because they have alredy been expanded.
   (define handler (lambda (escape proc mes obj)
		      (user-error proc mes obj ''())))
   ;; we scan all units
   (for-each (lambda (unit)
		(if (procedure? (unit-sexp* unit))
		    ;; a freezed unit (such as the eval unit)
		    ;; cannot be macro expanser.
		    'nothing
		    (let loop ((src (unit-sexp* unit))
			       (res '()))
		       (if (null? src)
			   (unit-sexp*-set! unit (reverse! res))
			   (match-case (car src)
			      ((define-macro . ?-)
			       (try (comptime-expand (car src)) handler)
			       (loop (cdr src) res))
			      ((define-expander . ?-)
			       (try (comptime-expand (car src)) handler)
			       (loop (cdr src) res))
			      (else
			       (let ((new-body (try (comptime-expand (car src))
						    handler)))
				  (loop (cdr src) (cons new-body res)))))))))
	     units)
   (pass-postlude units))
      
;*---------------------------------------------------------------------*/
;*    comptime-expand ...                                              */
;*---------------------------------------------------------------------*/
(define (comptime-expand x)
   (initial-expander x initial-expander))

;*---------------------------------------------------------------------*/
;*    (comptime-expand-once ...                                        */
;*---------------------------------------------------------------------*/
(define (comptime-expand-once x)
   (initial-expander x (lambda (x e) x)))

;*---------------------------------------------------------------------*/
;*    initial-expander ...                                             */
;*---------------------------------------------------------------------*/
(define (initial-expander x e::procedure)
   (trace expand "initial-expander: " x #\Newline)
   (let ((e1::procedure (cond
			   ((symbol? x)
			    *identifier-expander*)
			   ((null? x)
			    (error #f "Illegal form" '()))
			   ((not (pair? x))
			    (lambda (x e) x))
			   ((symbol? (car x))
			    (let ((id (fast-id-of-id (car x))))
			       (let (b)
				  (cond
				     ((begin
					 (set! b (get-compiler-expander id))
					 b)
				      b)
				     ((begin
					 (set! b (get-eval-expander id))
					 b)
				      b)
				     ((pair? (assq id (lexical-stack)))
				      *application-expander*)
				     ((begin
					 (set! b (find-O-expander id))
					 b)
				      (expander-expander b))
				     (else
				      *application-expander*)))))
			   (else
			    *application-expander*))))
      (e1 x e)))

;*---------------------------------------------------------------------*/
;*    *identifier-expander* ...                                        */
;*---------------------------------------------------------------------*/
(define (*identifier-expander* x e)
   x)

;*---------------------------------------------------------------------*/
;*    *application-expander* ...                                       */
;*---------------------------------------------------------------------*/
(define (*application-expander* x e)
   (let loop ((x* x))
      (cond
	 ((pair? x*)
	  (set-car! x* (e (car x*) e))
	  (set-cdr! x* (loop (cdr x*)))
	  x*)
	 ((null? x*)
	  '())
	 (else
	  (error #f "Illegal form" x)))))
