static char qsh_rcsid[]="qsh.c,v 1.2 1994/11/28 16:56:02 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  qsh.c,v
 * Revision 1.2  1994/11/28  16:56:02  kerce
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/21  03:00:05  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           qsh_popup;
static Widget           widget_qshrc;
static Widget           widget_qshlabel;
static Widget           widget_qshframe;
static Widget           widget_qshmenu;
static Widget           widget_qshmain;
static Widget           widget_qshexec;
static Widget           widget_qshclear;
static Widget           widget_qshclose;
static Widget           widget_qshseparator;
static Widget           widget_qshopt;

struct optionstruct qshmenu[]={
  0,"Account List     ","-A",INPUTTYPE,NULL,NULL,
  0,"Cell             ","-cell",INPUTTYPE,NULL,NULL,
  0,"Parallel         ","-par",INPUTTYPE,NULL,NULL,
  0,"Hard             ","-hard",FLAGTYPE,"False",NULL,
  0,"Help             ","-help",FLAGTYPE,"False",NULL,
  0,"Resource List    ","-l",INPUTTYPE,NULL,NULL,
  0,"Master Queue     ","-master",INPUTTYPE,NULL,NULL,
  0,"Job Name         ","-N",INPUTTYPE,NULL,NULL,
  0,"Priority         ","-p",INPUTTYPE,NULL,NULL,
  0,"Destination List ","-q",INPUTTYPE,NULL,NULL,
  0,"Current Directory","-cwd",FLAGTYPE,"True",NULL,
  0,"Display          ","-display",INPUTTYPE,NULL,NULL,
  0,"Soft             ","-soft",FLAGTYPE,"False",NULL,
  0,"Shell Path List  ","-S",INPUTTYPE,NULL,NULL,
  0,"User/Access List ","-u",INPUTTYPE,NULL,NULL,
  0,"Export Variables ","-v",INPUTTYPE,NULL,NULL,
  0,"Verify           ","-verify",FLAGTYPE,"False",NULL,
  0,"Export by Context","-V",FLAGTYPE,"False",NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_qshexec - Activate callback for exec
 */
XtCallbackProc pb_qshexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  buildcommand(QSH_BINARY,qshmenu,0);
  refreshicons();
}


/***********************************************************
 * pb_qshclear - Activate callback for clear
 */
XtCallbackProc pb_qshclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  clearsubmenu(qshmenu);
}


/***********************************************************
 * pb_qshclose - Activate callback for close
 */

XtCallbackProc pb_qshclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_qsh_dialog - Create widgets used for the qsh menu
 */
int create_qsh_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        qsh_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qsh_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qsh_form = XtCreateManagedWidget("form", formWidgetClass, qsh_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qshlabel=
	XtCreateManagedWidget("Qsh",labelWidgetClass,qsh_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qshlabel); ii++;
  widget_qshmain=XtCreateManagedWidget("box",formWidgetClass,qsh_form,
                                        args,ii);

 exec=QmonAddButtonN(widget_qshmain,NULL,"Exec",(XtCallbackProc)pb_qshexec,NULL);
 clear=QmonAddButtonN(widget_qshmain,exec,"Clear",(XtCallbackProc)pb_qshclear,NULL);
 close=QmonAddButtonN(widget_qshmain,clear,"Close",(XtCallbackProc)pb_qshclose,NULL);

  widget_qshopt=createmenuoptions(qsh_form,widget_qshmain,qshmenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_qsh - Open the qsh menu
 */
int openwidget_qsh()
{
  XtPopup(qsh_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qsh - Close the qsh menu
 */
int closewidget_qsh()
{
  XtPopdown(qsh_popup);
}
