static char  misc_rcsid[] = "misc.c,v 1.2 1994/11/28 16:55:16 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  misc.c,v
 * Revision 1.2  1994/11/28  16:55:16  kerce
 * *** empty log message ***
 *
 * Revision 1.4  1994/09/13  18:01:59  raju
 * *** empty log message ***
 *
 * Revision 1.3  1994/08/21  02:58:22  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/07/19  23:24:09  raju
 * indented and removed Qmonalloc and findbitmap_config_file and placed
 * in initdata.c (new file created hence)
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"
#include "qmonerrs.h"

extern queueiconstruct *queueicon;
extern queuepixstruct *queuepix;


static char     curdir[MAX_STRING_SIZE];
extern Widget   toplevel;
extern Cursor          busycorsor;
extern Cursor          defaultcorsor;
extern int      startup;
extern char    *grpfile;

Widget        sorry_popup;

void dump_names(STACK_NODE **head)
{
   STACK_NODE *p=NULL;
   if(head == NULL )
        printf("EMPTY STACK\n");
   else
        for ((p)= (*head); (p) != NULL; (p) = (p)->next )
        {
        printf("p %d \n",p);
        printf("p->next %d\n",p->next);
        printf("name -> %s\n",p->name);
        }
}
/*
 * stack_search - search for the p->name in the headp, if 
 * found return 1, else 0
 */
int stack_search(STACK_NODE **head, STACK_NODE *p)
{
    STACK_NODE *t=NULL;

   for ((t)= (*head); (t) != NULL; (t) = (t)->next )  
	if(!strcmp(t->name,p->name) )
		return 1 ;

   return 0 ;
}
/*
 * stack_push - install STACK_NODE at head of stack
 */
void stack_push(STACK_NODE **headp, STACK_NODE *p)
{
   p->next = *headp;  /* p->next now points to previous head (or is NULL) */
   *headp = p;        /*  *headp now points to p */
}

/***********************************************************
 * execit - Execute command in the user's environment
 */
int execit(char *command)
{
	int             pid;
	char            msg[1024];

	printf("\n\n%% %s\n\n", command);

	/*
	 * fork and exec process NOTE: the command should have an ampersand
	 * '&' in it 
	 */
	pid = (int) fork();

	if (!pid) {
		/*
		 * I am the child 
		 */
		if (execl("/bin/sh", "sh", "-c", command, NULL) == (-1)) {
			sprintf(msg, ERROR_114, command);
			logerr(msg);
			perror(msg);
			exit(0);
		}
		/*
		 * Should never reach here, but just in case 
		 */
		sprintf(msg, ERROR_115, command);
		logerr(msg);
		exit(0);
	}
	/*
	 * I am the parent 
	 */

	if (pid == (-1)) {
		/*
		 * Fork failed 
		 */
		sprintf(msg, "execit: fork failed for '%s'", command);
		logerr(msg);
		perror(msg);
		return 0;
	}
	wait(NULL);

	return 1;

}

/***********************************************************
 * buildcommand - Create a command line from a menu and
 *                execute it
 */
int buildcommand(char *command, struct optionstruct *menu, int flag )
{
	int             ii, len;
	char            cmdline[MAX_STRING_SIZE];
	char            cmd[MAX_STRING_SIZE];
	char            option[MAX_STRING_SIZE];
	char           *ptr;

	sprintf(cmdline, "%s", command);

	/*
	 * Go through the menu structure and see if any of the fields have
	 * values associated with them 
	 */
	for (ii = 0; menu[ii].name; ii++) {
           len=0;
	/*
	 * If there is an input argument 
	 */
	   if((menu[ii].type == INPUTTYPE)||(menu[ii].type == MENUTYPE)) {
	     ptr = QmonTextGetString(menu[ii].widgetid);
	     len =strlen(ptr);
	     ptr[len]=(char)NULL;
/*
	     printf("ptr %s\t strlen %d\n",ptr,strlen(ptr));
*/
	     if (len) {
		if (menu[ii].flag)
		   sprintf(cmdline, "%s %s '%s'", cmdline, menu[ii].flag, ptr);
		else
		    sprintf(cmdline, "%s '%s'", cmdline, ptr);
	     }
	/*
         * Application is responsible for freeing this space
	 * XtFree(ptr); 
	 */
	  }
		/*
		 * Else if there is a flag argument 
		 */
		else if (menu[ii].type == FLAGTYPE) {
			if (QmonToggleGetState(menu[ii].widgetid)) {
				sprintf(cmdline, "%s %s", cmdline, menu[ii].flag);
			}
		}
		/*
		 * Else if there is a Radio flag argument 
		 */
		else if (menu[ii].type == RADIOTYPE) {
			if (QmonToggleGetState(menu[ii].widgetid)) {
				sprintf(cmdline, "%s %s", cmdline, menu[ii].flag);
			}
		}
	}

	sprintf(cmdline, "%s &", cmdline);
	if(flag) { 
	   sprintf(cmd, "xterm -e %s", cmdline);
	   execit(cmd);
        }
	else {
	    execit(cmdline);
	}
}


/***********************************************************
 * clearsubmenu - Initialize the values the submenu's option
 *                windows
 */
int clearsubmenu(struct optionstruct *menu)
{
	int             n, ii;
	Arg             args[32];

	for (ii = 0; menu[ii].name; ii++) {
	    if (menu[ii].type == INPUTTYPE) {
		QmonTextSetString(menu[ii].widgetid, menu[ii].defaultarg);
	    }
	    else if (menu[ii].type == FLAGTYPE) {
	  	    if (strcmp(menu[ii].defaultarg, "True") == 0)
			QmonToggleSetState(menu[ii].widgetid, True);
		    else
			QmonToggleSetState(menu[ii].widgetid, False);
	    } 
	    else if (menu[ii].type == RADIOTYPE) {
	   	    n = 0;
		    XtSetArg(args[n], XtNstate, False); n++;
		    XtSetValues(menu[ii].widgetid, args, n);
	    }
	}
}


/***********************************************************
 * settitlebar - Sets the title bar to the program name 
 *               and current path
 */
int settitlebar()
{
	char            wintitle[MAX_STRING_SIZE];
	int             ii;
	Arg             args[32];

#ifdef GETCWD
	getcwd(curdir, MAX_STRING_SIZE);
#else
	getwd(curdir);
#endif

	sprintf(wintitle, "%s %s : %s", PROGNAME, VERSION, curdir);
	ii = 0;
	XtSetArg(args[ii], XtNtitle, wintitle);
	ii++;
	XtSetValues(toplevel, args, ii);
}


/***********************************************************
 * getcurdir - Returns a pointer to the strings containing
 *             the current working directory
 */
char   *getcurdir()
{
	return curdir;
}
/***********************************************************
 * printdate - 
 *             Prints the current time and date.
 */
void printdate()
{
	char            date[100];
	FILE           *pfp;

	pfp = popen(DATESTRING, "r");
	fgets(date, 100, pfp);
	printf("%s\n", date);
}

void defaultcursor()
{
	XDefineCursor(getdpy(), XtWindowOfObject(toplevel), defaultcorsor);
}

void busycursor()
{
	XDefineCursor(getdpy(), XtWindowOfObject(toplevel), busycorsor);
}



/***********************************************************
 * pb_sorryclose - Activate callback for close
 */

XtCallbackProc pb_sorryclose()
{
  closewidget_sorry();
}


/***********************************************************
 * create_sorry_dialog - Create widgets used for the sorry menu
 */
int create_sorry_dialog(Widget w,XtPointer client_data,XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        sorry_form;
  Widget        widget_sorrylabel;
  Widget        widget_sorrymain;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  sorry_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  sorry_form = XtCreateManagedWidget("form", formWidgetClass, sorry_popup,args,
ii);


  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_sorrylabel=
        XtCreateManagedWidget("Sorry !\nThis module is under construction.",labelWidgetClass,sorry_form,args,ii);


  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_sorrylabel); ii++;
  widget_sorrymain=XtCreateManagedWidget("box",formWidgetClass,sorry_form,
                                        args,ii);

 close=QmonAddButtonN(widget_sorrymain,NULL,"OK",(XtCallbackProc)pb_sorryclose,NULL);

  
}

/***********************************************************
 * closewidget_sorry - Close the sorry menu
 */
int closewidget_sorry()
{
  XtPopdown(sorry_popup);
  XtDestroyWidget(sorry_popup);
}

/***********************************************************
 * openwidget_sorry - Open the shell menu
 */
int openwidget_sorry()
{
   XtPopup(sorry_popup,XtGrabNone);
}
