static char dqs_show_rcsid[]="$Id: dqs_show.c,v 1.1.1.1 1997/04/10 15:10:34 green Exp $";

/*----------------------------------------------------
 * dqs_show.c Tom Green Mon Jan 31 10:43:04 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_show.c,v $
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.2  1996/11/20 23:04:29  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.1  1996/03/17  00:57:54  nrl
 * merge in qsub prevalidation scheme and consumable restoration
 *
 * Revision 3.0  1994/03/07  04:14:38  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:47  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

 
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/************************************************************************/
int dqs_show_qstat_request(job)
dqs_job_type *job;

{

     int i;
     dqs_list_type *sp;

     DENTER((DQS_EVENT,"dqs_show_stat_request"));

     if (job->cell)
     {
          printf("cell                  %s\n",job->cell);
     }

     if (job->ext)
     {
          printf("-ext\n");
     }

     if (job->full_listing)
     printf("-f");

     if (job->force_submission) printf("-F");

     if (job->hard_resource_list)
     {
          printf("hard resource_list          \n");
          dqs_show_resource_list(job->hard_resource_list);
     }
     if (job->user_list)
     {
          printf("user_list             \n");
          dqs_showlist(job->user_list,DQS_STDOUT|DQS_STR0|DQS_STR1,8);
     }

     if (job->verify)
     {
          printf("-verify\n");
     }

     DEXIT;
     return;

}
