/*
 * Copyright 1996, 1997, 1998 Computing Research Labs,
 * New Mexico State University
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COMPUTING RESEARCH LAB OR NEW MEXICO STATE UNIVERSITY BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
 * OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/*
 * $Id: htext.h,v 1.26 1998/02/06 21:17:11 mleisher Exp $
 */
static char *about_text = "\
                 XmBDFEditor 3.0\n\
              mleisher@crl.nmsu.edu\n\
                       06 February 1998\n\
\n\
XmBDFEditor is a BDF font editor that supports\n\
these main features:\n\
\n\
  o  Multiple fonts can be loaded from the command line.\n\
  o  Multiple fonts can be open at the same time.\n\
  o  Cutting and pasting glyphs between fonts.\n\
  o  Multiple glyph bitmap editors can be open at the same time.\n\
  o  Cutting and pasting between glyph bitmap editors.\n\
  o  Automatic correction of certain metrics when a font is loaded.\n\
  o  Generation of XLFD font names for fonts without XLFD names.\n\
  o  Update an XLFD font name from the font properties.\n\
  o  Update the font properties from an XLFD font name.\n\
  o  Font property editor.\n\
  o  Font comment editor.\n\
  o  Supports unencoded glyphs (ENCODING of -1).\n\
  o  Display of glyph encodings in octal, decimal, or hex.\n\
  o  Builtin on-line help.\n\
  o  Imports PK/GF fonts.\n\
  o  Imports HBF (Han Bitmap Font) fonts.\n\
  o  Imports Linux console fonts (PSF, CP, and FNT).\n\
  o  Imports Sun console fonts (vfont format).\n\
  o  Imports fonts from the X server.\n\
  o  Imports Windows FON/FNT fonts.\n\
  o  Imports TrueType fonts and collections.\n\
\n\
XmBDFEditor works on X11R5 or X11R6 with Motif\n\
1.2.*, Motif 2.*, or Lesstif.\n\
";

static char *program_text = "\
By default, xmbdfed automatically collects\n\
comments that are saved with the font, it\n\
preserves the unencoded glyphs, and it will\n\
attempt to make some metrics corrections\n\
automatically.  These options can be set on the\n\
command line.\n\
\n\
More than one font can be specified on the command\n\
line.\n\
\n\
The command line parameters for xmbdfed are:\n\
\n\
 -nc     - no comments\n\
 -nm     - no metrics corrections\n\
 -nu     - no unencoded glyphs\n\
 -np     - do not pad character cell bitmaps\n\
 -bp     - allow blank pages\n\
 -ed     - no \"Really Exit?\" dialog\n\
 -ps n   - set point size\n\
 -hres n - set horizontal resolution\n\
 -vres n - set vertical resolution\n\
 -res n  - set both resolutions\n\
 -sp s   - set the font spacing (\"p\", \"m\", or \"c\")\n\
";

static char *fgrid_text = "\
At the top of each editor window there are some\n\
fields and buttons.  These are:\n\
\n\
  The \"Font\" text field is where the font name\n\
  is set so it can be edited.\n\
\n\
  The \"Glyph\" field is a label that provides\n\
  some information about glyph name, encoding, and\n\
  metrics when a glyph is selected.  When a range\n\
  of glyphs are selected, this field displays the\n\
  start and end codes of the range.\n\
\n\
  The push buttons are used to navigate through the\n\
  glyph pages.  The \"Previous Page\" and \"Next Page\"\n\
  buttons normally skip glyph pages that are empty,\n\
  but that can be changed using the \"Setup\" dialog.\n\
\n\
  The \"Page\" field indicates the current glyph page\n\
  and also allows a specific page number to be entered.\n\
  Once a page number is entered, pressing the Return\n\
  key will cause the Font Grid to shift to that page.\n\
  The page number entered is expected to be a decimal\n\
  number.\n\
\n\
  The \"Code\" field is provided for situations where\n\
  the page number is not known, but the encoding is\n\
  known.  The encoding entered in this field must be\n\
  in the base (8, 10, or 16) that is currently being\n\
  used to display glyph encodings (see the \"View\"\n\
  menu below).  Once the encoding is entered, pressing\n\
  the Return key will cause the Font Grid to shift to\n\
  the page containing the encoding.\n\
\n\
The main window of each font editor is called the\n\
Font Grid.  All of the Font Grid's have a special\n\
clipboard used for passing glyphs around.  This\n\
clipboard is called FONTGRID_CLIPBOARD.\n\
\n\
When a glyph has been modified either by the user or\n\
by automatic metrics corrections when the font is loaded,\n\
the glyph code above the glyph cell will be highlighted.\n\
\n\
Font Grid Menus\n\
---------------\n\
\n\
File\n\
====\n\
  New <Ctrl+N>\n\
    This creates a new font and asks for the point\n\
    size, resolution, and font spacing first.\n\
\n\
  Open <Ctrl+O>\n\
    This opens a new font in the current Font\n\
    Grid.\n\
\n\
  Save <Ctrl+S>\n\
    Save the current font.\n\
\n\
  Save As <Ctrl+W>\n\
    Save the current font with some other name.\n\
\n\
  Import\n\
  ======\n\
\n\
    PK/GF Font <Ctrl+K>\n\
      Import a Metafont PK or GF font.\n\
\n\
    Console Font <Ctrl+L>\n\
      Import a Linux or Sun console (binary) font.\n\
      If the font is a CP (Linux codepage) font, this\n\
      will load all three point sizes of the font,\n\
      display the 16pt font and create editors for the\n\
      14pt and 8pt fonts. If the font is a PSF font\n\
      that has an embedded mapping table, this will\n\
      remap the glyphs based on the mapping table.\n\
\n\
    HBF Font <Ctrl+H>\n\
      Import an HBF font.\n\
\n\
    Windows Font <Ctrl+B>\n\
      Import a Windows FON/FNT font.  This will also\n\
      import fonts from .EXE and .DLL files.\n\
\n\
    TrueType Font <Ctrl+Y>\n\
      Import a TrueType font (.ttf) or collection (.ttc).\n\
\n\
    Server Font <Ctrl+G>\n\
      This will import a font from the X server.\n\
\n\
  Exit/Close <Ctrl+F4>\n\
    Exit the program if this is the primary Font\n\
    Grid or simply hide the current Font Grid\n\
    window.\n\
\n\
Edit\n\
====\n\
  Copy <Ctrl+C>\n\
    This copies the current selection to the Font\n\
    Grid clipboard.\n\
\n\
  Cut <Ctrl+X>\n\
    This copies the current selection to the Font\n\
    Grid clipboard and then deletes the selection.\n\
\n\
  Paste <Ctrl+V>\n\
    This pastes the Font Grid clipboard at the\n\
    currently selected position.  This only works\n\
    if a single glyph is selected.\n\
\n\
  Properties <Ctrl+P>\n\
    This invokes the font property editor.\n\
\n\
  Comments <Ctrl+M>\n\
    This invokes the font comments editor.\n\
\n\
  Font Info <Ctrl+I>\n\
    This invokes a dialog that allows changes\n\
    to some of the font information so these\n\
    values do not have to be changed using the\n\
    property editor.  These values include the\n\
    default character, font device width (for\n\
    monowidth and character cell fonts), font\n\
    ascent and descent, font vertical and\n\
    horizontal resolution, and the font spacing.\n\
\n\
  Font Name\n\
  =========\n\
\n\
    Make XLFD Name\n\
      If the font does not have an XLFD name, this\n\
      will save the current font name in the\n\
      \"_ORIGINAL_FONT_NAME\" font property and then\n\
      generate an XLFD name for the font.\n\
\n\
    Update Name From Properties\n\
      This will update the XLFD font name fields from\n\
      the font property list.\n\
\n\
    Update Properties From Name\n\
      This will update the font properties from the\n\
      XLFD font name.\n\
\n\
    Update Average Width\n\
      This will update the average width field of the\n\
      XLFD font name and will update the\n\
      \"AVERAGE_WIDTH\" font property as a side effect.\n\
\n\
  Test Glyphs <Ctrl+Z>\n\
    This will toggle the glyph test dialog on or off for\n\
    the editor.  When this is active, selecting a glyph\n\
    from any Font Grid will also add it to the glyph test\n\
    dialog.  When changes are made to a glyph or the font\n\
    bounding box, the glyph test dialog will be updated\n\
    accordingly.\n\
\n\
    The glyph test dialog provides a toggle to turn the\n\
    baseline on or off and another toggle to draw from right\n\
    to left instead of left to right.\n\
\n\
  Setup <Ctrl+T>\n\
    This will invoke the dialog to edit various settings\n\
    used by the editor.\n\
\n\
View\n\
====\n\
  Unencoded <Ctrl+E>\n\
    If the font has unencoded glyphs (\"ENCODING\"\n\
    field is -1), this will toggle between\n\
    displaying the unencoded and encoded glyphs.\n\
\n\
  Code Base\n\
  =========\n\
    Octal\n\
      This option will display glyph encodings in\n\
      octal (base 8).\n\
\n\
    Decimal\n\
      This option will display glyph encodings in\n\
      decimal (base 10).\n\
\n\
    Hexadecimal\n\
      This option will display glyph encodings in\n\
      hexadecimal (base 16).\n\
\n\
  Messages <Ctrl+A>\n\
    This will show messages generated when corrections\n\
    to the font metrics are done or when errors are\n\
    encountered.\n\
\n\
Operations\n\
==========\n\
  Translate <Ctrl+D>\n\
    This will bring up the dialog for entering the X\n\
    offset and Y offset used to translate the glyph to\n\
    a new location.\n\
\n\
    The option of translating the selected glyphs or all\n\
    of the glyphs is provided.\n\
\n\
  Rotate <Ctrl+R>\n\
    This will bring up the dialog for entering the\n\
    rotation angle.  The rotation is limited to between\n\
     1 and 359.\n\
\n\
    The option of rotating the selected glyphs or all\n\
    of the glyphs is provided.\n\
\n\
  Shear <Ctrl+J>\n\
    This will bring up the dialog for entering the\n\
    angle of the shear.  The shear is limited to\n\
    45.\n\
\n\
    The option of rotating the selected glyphs or all\n\
    of the glyphs is provided.\n\
\n\
Editors\n\
=======\n\
  New <Ctrl+N>\n\
    This will cause a new editor to be created.\n\
\n\
  [editor list]\n\
    The remaining menu items are all the Font\n\
    Grid's that have been created.  Choosing one\n\
    will force that window to be made visible and\n\
    also put that window on top.\n\
\n\
Font Grid Translations\n\
----------------------\n\
Btn1Down\n\
  This will start selecting glyphs.\n\
\n\
Btn1Motion\n\
  This will extend the selected glyphs.\n\
\n\
Btn1Up\n\
  This will end glyph selection.\n\
\n\
Shift+Btn1Down\n\
  This will adjust the glyphs already selected by\n\
  adding or removing glyphs from the selection.\n\
\n\
Btn2Down\n\
  This will paste the glyphs on the Font Grid\n\
  clipboard at the glyph position under the mouse.\n\
\n\
Shift+Btn2Down\n\
  This will insert the glyphs on the Font Grid\n\
  clipboard in front of the glyphs starting at the\n\
  position under the mouse.  Any glyphs moved past\n\
  the 0xffff encoding will be moved to the unencoded\n\
  area so they are not lost.  This action will always\n\
  insert, no matter what mode the font grid is in.\n\
\n\
Btn3Down\n\
  This will copy the selected glyphs to the Font\n\
  Grid clipboard.\n\
\n\
Copy\n\
  This will copy the selected glyphs to the Font\n\
  Grid clipboard.\n\
\n\
Cut\n\
  This will copy the selected glyphs to the Font\n\
  Grid clipboard and then delete the glyphs.\n\
\n\
Paste\n\
  This will paste the glyphs on the Font Grid\n\
  clipboard at the currently selected glyph\n\
  position.\n\
\n\
Delete\n\
  This will copy the selected glyphs to the Font\n\
  Grid clipboard and then delete the glyphs.\n\
\n\
BackSpace\n\
  This will copy the selected glyphs to the Font\n\
  Grid clipboard and then delete the glyphs.\n\
\n\
PageUp\n\
  This will switch to the next page of glyphs.\n\
\n\
PageDown\n\
  This will switch to the previous page of glyphs.\n\
\n\
Home\n\
  This will switch to the first page of glyphs.\n\
\n\
End\n\
  This will switch to the last page of glyphs.\n\
\n\
Double clicking with Button1 will invoke the Glyph\n\
Editor for the current glyph.\n\
\n\
Other Font Grid Features\n\
------------------------\n\
The font name can be edited in the Font Grid and\n\
page switching can be done with the buttons on the\n\
Font Grid.\n\
";

static char *gedit_text = "\
The Glyph Editor provides a simple bitmap editor\n\
designed to edit glyph bitmaps and other glyph\n\
information.  The Glyph Editors all use a special\n\
clipboard used to pass bitmaps between the Glyph\n\
Editors.  This clipboard is called\n\
GLYPHEDIT_CLIPBOARD.\n\
\n\
The only limit on the number of Glyph Editors that\n\
can be open at one time is the amount of memory.\n\
\n\
Glyph Editor Menus\n\
------------------\n\
\n\
File\n\
====\n\
  Update <Ctrl+S>\n\
    This will update the Font Grid with the\n\
    modified glyph.\n\
\n\
  Import XBM <Ctrl+I>\n\
    This will pop up a file selection dialog\n\
    so an X Bitmap file (.xbm extension) can be\n\
    selected to be imported into the glyph editor.\n\
\n\
    The imported bitmap is handled the same way\n\
    as bitmaps pasted.  They are inserted as a\n\
    selection with the move operation active and\n\
    do not destroy any bitmap that already exists\n\
    in the editor.\n\
\n\
  Export XBM <Ctrl+O>\n\
    This will pop up a file selection dialog\n\
    so that the glyph image can be exported as\n\
    an X Bitmap file (.xbm extension).\n\
\n\
  Close <Ctrl+F4>\n\
    This will close the Glyph Editor.\n\
\n\
Edit\n\
====\n\
  Reload <Ctrl+L>\n\
    This will reload the glyph and discard any\n\
    changes in the glyph.\n\
\n\
  Resize <Ctrl+R>\n\
    This will allow changing the sizes of the\n\
    glyph left/right bearings and the glyph\n\
    ascent/descent.\n\
\n\
  Copy <Ctrl+C>\n\
    This will copy the currently selected portion\n\
    of the bitmap to the Glyph Editor clipboard.\n\
\n\
  Cut <Ctrl+X>\n\
    This will copy the currently selected portion\n\
    of the bitmap to the Glyph Editor clipboard\n\
    and then delete the selection.\n\
\n\
  Paste <Ctrl+V>\n\
    This will paste the Glyph Editor clipboard\n\
    into the current Glyph Editor with the\n\
    top-left coordinate of the bitmap on the\n\
    clipboard pasted at the location of the mouse.\n\
    If the bitmap is too big to fit if it is\n\
    pasted at the mouse location, the bitmap will\n\
    be shifted until it fits completely in the\n\
    Glyph Editor.\n\
\n\
  Select All <Ctrl+A>\n\
    This will select the whole glyph bitmap.\n\
\n\
  Next Glyph <Ctrl+N>\n\
    This will move the Glyph Editor to the next\n\
    glyph position in the Font Grid.  If the\n\
    current glyph has been modified, a save prompt\n\
    will appear before moving to the next glyph.\n\
\n\
  Previous Glyph <Ctrl+P>\n\
    This will move the Glyph Editor to the previous\n\
    glyph position in the Font Grid.  If the\n\
    current glyph has been modified, a save prompt\n\
    will appear before moving to the previous glyph.\n\
\n\
Operation\n\
=========\n\
  Draw <Ctrl+D>\n\
    Change the Glyph Editor into Draw mode.\n\
\n\
  Move <Ctrl+M>\n\
    Change the Glyph Editor into Move mode.  Move\n\
    mode allows selecting a portion of the glyph\n\
    bitmap and moving it to another location.\n\
\n\
  Copy <Ctrl+Y>\n\
    Change the Glyph Editor into Copy mode.  Copy\n\
    mode allows copying a portion of the glyph\n\
    bitmap and moving it to another location.\n\
\n\
  Rotate <Ctrl+T>\n\
    This will invoke the rotation dialog that\n\
    allows the degrees of rotation to be specified.\n\
    Rotation can be between 1 and 359 degrees.\n\
\n\
  Shear <Ctrl+E>\n\
    This will invoke the shear dialog that allows\n\
    the degrees of horizontal shear to be specified.\n\
    Other names for shearing are obliquing or slanting.\n\
    Shearing is allowed between 1 and 45 degrees.\n\
\n\
Glyph Editor Translations\n\
-------------------------\n\
\n\
BtnDown\n\
  Depending on the mode of the Glyph Editor, this\n\
  will start drawing, start selecting for a Move\n\
  or start selecting for a Copy.  When in Draw\n\
  mode, Button1 will set pixels, Button2 will\n\
  invert pixels, and Button3 will clear pixels.\n\
\n\
  When in Move or Copy mode and a selection\n\
  exists, pressing Button1 within the selection\n\
  will \"grab\" the selection so it can be Moved or\n\
  Copied.  Pressing Button3 in this case will\n\
  copy the selection to the Glyph Editor clipboard.\n\
\n\
Shift+Btn2Down\n\
  This will paste the contents of the Glyph Editor\n\
  clipboard into the glyph editor at the location\n\
  of the mouse.\n\
\n\
Motion\n\
  This will continue the operation started with\n\
  \"BtnDown\" as well as report the current mouse\n\
  coordinates in Cartesian form relative to the\n\
  bounding box for the glyph.\n\
\n\
BtnUp\n\
  This will end the operation started with\n\
  \"BtnDown\".\n\
\n\
Copy\n\
  This will copy the selected bitmap to the Glyph\n\
  Editor clipboard.\n\
\n\
Cut\n\
  This will copy the selected bitmap to the Glyph\n\
  Editor clipboard and then delete it.\n\
\n\
Paste\n\
  This will paste the Glyph Editor clipboard at\n\
  the mouse position.\n\
\n\
Right\n\
  This will shift the glyph bitmap toward (but not\n\
  past) the right edge of the bitmap grid.\n\
\n\
Left\n\
  This will shift the glyph bitmap toward (but not\n\
  past) the left edge of the bitmap grid.\n\
\n\
Up\n\
  This will shift the glyph bitmap toward (but not\n\
  past) the top edge of the bitmap grid.\n\
\n\
Down\n\
  This will shift the glyph bitmap toward (but not\n\
  past) the bottom edge of the bitmap grid.\n\
  \n\
9\n\
  This will rotate the glyph bitmap 90\n\
  counter-clockwise.\n\
\n\
0\n\
  This will rotate the glyph bitmap 90\n\
  clockwise.\n\
  \n\
-\n\
  This will flip the glyph bitmap around the\n\
  vertical axis (horizontal flip).\n\
  \n\
=\n\
  This will flip the glyph bitmap around the\n\
  horizontal axis (vertical flip).\n\
\n\
Other Glyph Editor Features\n\
---------------------------\n\
\n\
In addition to editing the glyph bitmap, the Glyph\n\
Editor also allows editing of the glyph name and\n\
setting its device width (BDF \"DWIDTH\" field).  To\n\
get more aesthetic spacing between glyphs, this\n\
value can be set explicitly.  The glyph name\n\
should be a maximum of 14 characters.\n\
\n\
The Glyph Editor also provides a simple toolbox\n\
that has buttons to switch between operations and to\n\
perform various bitmap manipulations.\n\
\n\
Pressing one of the shift buttons in the toolbox\n\
will repeat the shift operation if the mouse button\n\
is held down longer than 100 milliseconds.  This is\n\
not configurable at the moment.
";

static char *conf_text = "\
XmBDFEditor can be configured using an external\n\
file.  This file is always assumed to be\n\
\"~/.xmbdfedrc\".\n\
\n\
This file sets default values which can be changed\n\
and saved from the editor.  The default values\n\
apply to either the editor itself or the font\n\
management system.\n\
\n\
For the following configuration options, the\n\
following types are used:\n\
\n\
  <boolean>\n\
    A <boolean> value can be \"0\", \"false\", \"no\",\n\
    \"1\", \"true\", or \"yes\".  Boolean values are\n\
    case insensitive.\n\
\n\
  <labelstring>\n\
    A <labelstring> value is a string used as a label\n\
    for some of the options.\n\
\n\
  <atom>\n\
    An <atom> is basically a string.\n\
\n\
  <cardinal>\n\
    A <cardinal> value is an unsigned 32-bit\n\
    integer value.\n\
\n\
  <integer>\n\
    An <integer> is a signed 32-bit integer\n\
    value.\n\
\n\
  <property-name>\n\
    A <property-name> is any name that conforms to\n\
    the XLFD definition of a user-defined\n\
    property.  Basically, the property name must\n\
    start with the underscore character (_).\n\
    These names are conventionally in upper case\n\
    with the underscore character used to provide\n\
    \"spaces\" between parts of the name.\n\
\n\
  <property-type>\n\
    A <property-type> can be one of \"atom\",\n\
    \"cardinal\", or \"integer\" (see above).\n\
\n\
  <font-spacing>\n\
    A <font-spacing> value can be one of\n\
    \"proportional\", \"monospace\", or\n\
    \"charactercell\".\n\
\n\
    If an unknown <font-spacing> value is\n\
    encountered, the default value is\n\
    \"proportional\".\n\
\n\
  <translation>\n\
    A <translation> is a valid X Toolkit translation\n\
    string.
\n\
The following configuration options can appear in\n\
the configuration file:\n\
\n\
  XmBDFEditor Configuration Options\n\
  =================================\n\
\n\
   skip_blank_pages <boolean> [default: \"true\"]\n\
\n\
     By default, the editor will skip font pages\n\
     that do not have any glyphs when the \"Next\n\
     Page\" and \"Previous Page\" buttons are used.\n\
\n\
     If this option is set to \"false\", the \"Next\n\
     Page\" and \"Previous Page\" buttons will simply\n\
     move to the next or previous page, even if\n\
     they do not have glyphs on them.\n\
\n\
   really_exit <boolean> [default: \"true\"]\n\
\n\
     By default, the editor will always present the\n\
     \"Really Exit?\" dialog when exiting.  If this\n\
     option is set to \"false\", then the dialog\n\
     not be presented when exiting.\n\
\n\
   grid_overwrite_mode <boolean> [default: \"true\"]\n\
\n\
     By default, pasting glyphs into a Font Grid will\n\
     overwrite glyphs that are in the same range as the\n\
     glyphs being pasted.  If this option is set to\n\
     \"false\", pasting glyphs into a Font Grid will\n\
     move glyphs to make room for the glyphs being pasted.\n\
     Any glyphs moved that have an encoding larger than\n\
     65535 will be moved to the unencoded area.\n\
\n\
   close_accelerator_text <labelstring> [default: \"Ctrl+F4\"]\n\
\n\
     The default close accelerator text shown on the\n\
     Close/Exit menu options of the FontGrid's and\n\
     GlyphEditor's is Ctrl+F4.  This option changes the\n\
     label string on those menu options.  This option should\n\
     be used in conjunction with the next option.\n\
\n\
   close_accelerator <translation> [default: \"Ctrl<Key>F4\"]\n\
\n\
     The default accelerator for the Close/Exit menu options\n\
     in the FontGrid's and GlyphEditor's can sometimes be\n\
     awkward for various reasons.  This option allows that\n\
     accelerator to be changed.  This option should be used\n\
     in conjunction with the previous option.\n\
\n\
   pixel_size <integer> [default: \"10\"]\n\
\n\
     The GlyphEditors will use a square of size 10x10 to\n\
     represent a pixel in the glyph bitmap.  If the glyph\n\
     bitmap causes the GlyphEditor grid to be larger than\n\
     1/2 the display height, then this value will be reduced\n\
     until the bitmap fits within 1/2 the display size or\n\
     until a pixel size of 2 is reached.\n\
\n\
     The GlyphEditor's will always attempt to use this default\n\
     value first before reducing the size, if reducing the size\n\
     is needed.\n\
\n\
  General Font Configuration Options\n\
  ==================================\n\
\n\
    correct_metrics <boolean> [default: \"true\"]\n\
\n\
      By default, the editor will make certain\n\
      corrections to the font metrics when a font\n\
      is loaded.  If this value is \"false\", then\n\
      no metrics corrections will be performed\n\
      when a font is loaded.\n\
\n\
    keep_unencoded <boolean> [default: \"true\"]\n\
\n\
      By default, the editor will keep any\n\
      unencoded glyphs that are found when a font\n\
      is loaded.  An unencoded glyph will have an\n\
      \"ENCODING\" field set to -1.  If this option\n\
      is set to \"false\", then all unencoded glyphs\n\
      will be ignored.\n\
\n\
    keep_comments <boolean> [default: \"true\"]\n\
\n\
      By default, the editor will keep all\n\
      comments found in the font file.  This\n\
      allows them to be edited.\n\
\n\
      If this option is set to \"false\", all\n\
      comments except those that appear in the\n\
      font properties list will be ignored.  The\n\
      comments in the font properties list are\n\
      kept because they sometimes contain useful\n\
      notes about the properties.\n\
\n\
    pad_character_cells <boolean> [default: \"true\"]\n\
\n\
      By default, the editor will pad each glyph\n\
      bitmap from fonts with \"charactercell\"\n\
      spacing.  This means that each glyph has\n\
      blank bits added around it until it matches\n\
      the font bounding box exactly.\n\
\n\
      This option is \"true\" by default because\n\
      that seems to be what most people expect,\n\
      based on numerous \"charactercell\" fonts that\n\
      were checked.\n\
\n\
      However, since the BDF format is sometimes\n\
      used as a transfer format between programs,\n\
      this option can be set to \"false\" to reduce\n\
      the size of the BDF font.\n\
\n\
      In either case, the fonts will display\n\
      correctly, and metrics calculations should\n\
      not be affected.\n\
\n\
    font_spacing <font-spacing> [default: \"proportional\"]\n\
\n\
      By default, the editor will create new fonts\n\
      with proportional spacing.  This option can\n\
      be set to \"monospace\" or \"charactercell\" if\n\
      \"proportional\" is not wanted.\n\
\n\
    point_size <cardinal> [default: \"12\"]\n\
\n\
      By default, the editor will create new fonts\n\
      with point size 12.\n\
\n\
    horizontal_resolution <integer> [default: \"display\"]\n\
\n\
      By default, the editor will determine the\n\
      horizontal resolution based on the X display\n\
      being used by the editor.  For instance,\n\
      this value is often \"90\" for Sun displays.\n\
\n\
    vertical_resolution <integer> [default: \"display\"]\n\
\n\
      By default, the editor will determine the\n\
      vertical resolution based on the X display\n\
      being used by the editor.  For instance,\n\
      this value is often \"90\" for Sun displays.\n\
\n\
    hint_truetype_glyphs <boolean> [default: \"true\"]\n\
\n\
      By default, importing TrueType fonts will have\n\
      the glyphs hinted.  If this option is set to\n\
      \"false\", the glyphs will not be hinted.\n\
\n\
    property <property-name> <property-type>\n\
\n\
      To support user-defined properties, the\n\
      editor provides the facility to define them\n\
      in the configuration file in order to\n\
      interpret them correctly (atom, cardinal, or\n\
      integer) when editing fonts containing\n\
      user-defined properties.\n\
\n\
      If an unknown user-defined property is\n\
      encountered in a font, it always defaults to\n\
      a <property-type> of \"atom\".\n\
\n\
      There is no limit to the number of\n\
      \"property\" options set in the configuration\n\
      file.\n\
";

static char *ttf_text = "\
If this program was compiled with the FreeType\n\
library to support importing TrueType fonts (.ttf\n\
extension) and TrueType collections (.ttc extension),\n\
when importing a TrueType font or collection, a dialog\n\
will be presented to allow you to choose a single font,\n\
the platform, and encoding.  If you are loading a\n\
TrueType collection, there will be more than one font\n\
to choose from.\n\
\n\
TrueType fonts imported will use the point size and\n\
resolution set in your ~/.xmbdfedrc file or the defaults\n\
set at compile time if you do not have a ~/.xmbdfedrc.\n\
\n\
The renderer used to import TrueType fonts is\n\
available from ftp.physiol.med.tu-muenchen.de\n\
in the directory /pub/freetype/devel/.\n\
";

static char *fnt_text = "\
When a Windows .FON, .EXE, or .DLL file resource\n\
table holds more than one font, you are presented with\n\
a list of fonts to choose from.  You can select as many\n\
of them as you wish or simply import them all using\n\
the \"Import All\" button.\n\
";
