/*
 * pager.c - workspace pager
 * 
 *  WindowMaker window manager
 * 
 *  Copyright (c) 1997 Alfredo K. Kojima
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "wconfig.h"

#ifdef PAGER

#error THE PAGER IS NOT WORKING YET!!!!

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdlib.h>
#include <string.h>

#include "generic/wwmlib.h"
#include "WindowMaker.h"
#include "screen.h"
#include "wcore.h"
#include "window.h"
#include "funcs.h"
#include "texture.h"

#include "pager.h"


typedef struct WPagerView {
    Window window;
    int workspace;
} WPagerView;


typedef struct WPager {
    WFrameWindow *fwin;
    WCoreWindow *view;		       /* window with the workspace views */

    int view_x;
    int pos_x, pos_y;
    
    int workspace_no;
    
    WTexSolid *texture;
    Pixmap texture_data;    
} WPager;


#define PAGER_SIZE 32

#define VIEW_WIDTH  (scr->scr_width*PAGER_SIZE/scr->scr_height)

static void resizePager(WPager *pager, int new_width);


WPager*
wPagerCreate(WScreen *scr)
{
    WPager *pager;
    int title_h;
    int y_pos;
    int i;
    XColor color;
    XWindowAttributes attr;

    title_h = MIN_TITLEFONT_HEIGHT(scr->title_font->height) + 2;

    y_pos = scr->scr_height - title_h;


    pager = wmalloc(sizeof(WPager));
    memset(pager, 0, sizeof(WPager));
    
    pager->fwin = scr;

    pager->view_x = 0;


    for (i=0; i<= scr->workspace_count; i++)
	wPagerAddWorkspace(pager);

    
    return pager;
}



WPagerView*
wPagerAddWorkspace(WPager *pager)
{
/*    WScreen *scr = pager->screen_ptr;
    int width;
 */
    return NULL;
    
    pager->workspace_no++;
    /*
    width = pager->workspace_no*VIEW_WIDTH;
    wCoreConfigure(pager->view, pager->view_x, pager->titlebar->height, 
		   width, pager->view->height);
    
    if (width < scr->scr_width) {
	resizePager(pager, width);
    }
     */
}


void
wPagerRemoveWorkspace(WPager *pager, int workspace)
{
    WScreen *scr = pager->screen_ptr;
    int width;
    
    pager->workspace_no--;
    
    width = pager->workspace_no*VIEW_WIDTH;
    wCoreConfigure(pager->view, pager->view_x, pager->titlebar->height,
		   width, pager->view->height);
}


void
wPagerChangeViewWorkspace(WPager *pager, WPagerView *view, int workspace)
{
}


static void
resizePager(WPager *pager, int new_width)
{
    wCoreConfigure(pager->core, 0, pager->pos_y, new_width,
		   pager->core->height);
    wCoreConfigure(pager->titlebar, 0, 0, new_width, pager->titlebar->height);
    if (pager->screen_ptr->focused_texture->any.texture!=WTEX_SOLID)
	FREE_PIXMAP(pager->texture_data);
}


static void
drawFrame(WTexSolid *texture, Window win, int x, int y, int w, int h)
{
    XSegment segs[4];
     
    w--;
    h--;
    
    segs[0].x1 = x;
    segs[0].x2 = x+w;
    segs[0].y1 = segs[0].y2 = y;
    segs[1].x1 = segs[1].x2 = x;
    segs[1].y1 = y;
    segs[1].y2 = y + h;
    XDrawSegments(dpy, win, texture->dark_gc, segs, 2);

    segs[0].x1 = x+1;
    segs[0].x2 = x+w-1;
    segs[0].y1 = segs[0].y2 = y+1;
    segs[1].x1 = segs[1].x2 = x+1;
    segs[1].y1 = y+1;
    segs[1].y2 = y + h-1;
    XDrawSegments(dpy, win, texture->dark_gc, segs, 2);
    
    segs[0].x1 = x + 1;
    segs[0].y1 = y + h;
    segs[0].x2 = x + w;
    segs[0].y2 = y + h;
    segs[1].x1 = x + w;
    segs[1].y1 = y + h;
    segs[1].x2 = x + w;
    segs[1].y2 = y + 1;
    XDrawSegments(dpy, win, texture->light_gc, segs, 2);
}


void 
wPagerPaint(WPager *pager)
{
    WScreen *scr = pager->screen_ptr;
    int i, first, count;
    int x;

        
    if (pager->view_x != 0)
	first = -pager->view_x/VIEW_WIDTH;
    else
	first = 0;
    
    count = pager->view->width/VIEW_WIDTH;
    if (count > pager->workspace_no)
	count = pager->workspace_no;

    x = 0;
    for (i=first; i<count; i++) {
	drawFrame(pager->texture, pager->view->window, x, 0, VIEW_WIDTH,
		  pager->view->height);
	x += VIEW_WIDTH;
    }
}


Window
wPagerAddWindow(WPager *pager, int workspace)
{
    Window win;
    WScreen *scr = pager->screen_ptr;
    
    win = XCreateSimpleWindow(dpy, pager->view->window,
			      workspace*VIEW_WIDTH, 0, 4, 4,
			      1, pager->screen_ptr->white_pixel,
			      pager->screen_ptr->black_pixel);
    return win;
}


void
wPagerUpdateWindow(WPager *pager, WWindow *wwin)
{
    int x, y, w, h;
    WScreen *scr = pager->screen_ptr;
    
    x = wwin->frame_x;
    
    XMoveResizeWindow(dpy, wwin->pager_view, wwin->workspace*VIEW_WIDTH+x, y,
		      w, h);
}

/**********************************************************/


static void 
pagerEventHandler(WObjDescriptor *desc, XEvent *event)
{
    WPager *pager = (WPager*)desc->parent;
    WScreen *scr = pager->screen_ptr;
    XEvent ev;
    int done = 0;
    
    if (event->type == EnterNotify) {
	XMoveWindow(dpy, pager->core->window, pager->pos_x, pager->pos_y);
	XRaiseWindow(dpy, pager->core->window);
	
	pager->pos_y = scr->scr_height - pager->core->height;
	    

	while (!done) {
	    wNextEvent(&ev);
	    
	    if (ev.xany.window == pager->core->window
		|| ev.xany.window == pager->view->window
		|| ev.xany.window == pager->titlebar->window
		|| ev.type == MotionNotify) {
		switch (ev.type) {
		 case MotionNotify:
		    if (ev.xmotion.x_root < pager->pos_x 
			|| ev.xmotion.y_root < pager->pos_y
			|| ev.xmotion.x_root > pager->pos_x+pager->core->width
			|| ev.xmotion.y_root > pager->pos_y+pager->core->height) {
			XMoveWindow(dpy, pager->core->window, pager->pos_x,
				    scr->scr_height - 20);
			done = 1;
		    }
		    break;

		 default:
		    DispatchEvent(&ev);
		}
	    } else {
		DispatchEvent(&ev);
	    }
	}
    }
    pager->pos_y = scr->scr_height - 20;
}




#endif /* PAGER */
