/*--------------------------------*-C-*---------------------------------*
 * File:	scrollbar.c
 *
 * scrollbar routines
 *
 * Copyright 1996,97
 * mj olesen <olesen@me.QueensU.CA> Queen's Univ at Kingston
 *
 * You can do what you like with this source code provided you don't make
 * money from it and you include an unaltered copy of this message
 * (including the copyright).  As usual, the author accepts no
 * responsibility for anything, nor does he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#include "feature.h"
#include "main.h"
#include "scrollbar.h"

/* extern functions referenced */
/* extern variables referenced */
/* extern variables declared here */
scrollBar_t scrollBar;
int sb_shadow;

/*----------------------------------------------------------------------*
 */
static GC       scrollbarGC;

#ifdef XTERM_SCROLLBAR		/* bitmap scrollbar */
static GC	ShadowGC;

static char     sb_bits[] =
{0xaa, 0x0a, 0x55, 0x05};	/* 12x2 bitmap */

#if (SB_WIDTH != 15)
#error check scrollbar width (SB_WIDTH). It must be 15 for XTERM_SCROLLBAR*/
#endif

#else				/* XTERM_SCROLLBAR */
static GC       topShadowGC, botShadowGC;

/* draw triangular up button with a shadow of SHADOW (1 or 2) pixels */
/* PROTO */
void
Draw_up_button(int x, int y, int state)
{
    const unsigned int sz = (SB_WIDTH), sz2 = (SB_WIDTH / 2);
    XPoint          pt[3];
    GC              top, bot;

    switch (state) {
    case +1:
	top = topShadowGC;
	bot = botShadowGC;
	break;
    case -1:
	top = botShadowGC;
	bot = topShadowGC;
	break;
    case 0:
	top = bot = scrollbarGC;
	break;
    }

/* fill triangle */
    pt[0].x = x;
    pt[0].y = y + sz - 1;
    pt[1].x = x + sz - 1;
    pt[1].y = y + sz - 1;
    pt[2].x = x + sz2;
    pt[2].y = y;
    XFillPolygon(Xdisplay, scrollBar.win, scrollbarGC,
		 pt, 3, Convex, CoordModeOrigin);

/* draw base */
    XDrawLine(Xdisplay, scrollBar.win, bot,
	      pt[0].x, pt[0].y, pt[1].x, pt[1].y);

/* draw shadow */
    pt[1].x = x + sz2 - 1;
    pt[1].y = y;
    XDrawLine(Xdisplay, scrollBar.win, top,
	      pt[0].x, pt[0].y, pt[1].x, pt[1].y);
#if (SHADOW > 1)
/* doubled */
    pt[0].x++;
    pt[0].y--;
    pt[1].y++;
    XDrawLine(Xdisplay, scrollBar.win, top,
	      pt[0].x, pt[0].y, pt[1].x, pt[1].y);
#endif
/* draw shadow */
    pt[0].x = x + sz2;
    pt[0].y = y;
    pt[1].x = x + sz - 1;
    pt[1].y = y + sz - 1;
    XDrawLine(Xdisplay, scrollBar.win, bot,
	      pt[0].x, pt[0].y, pt[1].x, pt[1].y);
#if (SHADOW > 1)
/* doubled */
    pt[0].y++;
    pt[1].x--;
    pt[1].y--;
    XDrawLine(Xdisplay, scrollBar.win, bot,
	      pt[0].x, pt[0].y, pt[1].x, pt[1].y);
#endif
}

/* draw triangular down button with a shadow of SHADOW (1 or 2) pixels */
/* PROTO */
void
Draw_dn_button(int x, int y, int state)
{
    const unsigned int sz = (SB_WIDTH), sz2 = (SB_WIDTH / 2);
    XPoint          pt[3];
    GC              top, bot;

    switch (state) {
    case +1:
	top = topShadowGC;
	bot = botShadowGC;
	break;
    case -1:
	top = botShadowGC;
	bot = topShadowGC;
	break;
    case 0:
	top = bot = scrollbarGC;
	break;
    }

/* fill triangle */
    pt[0].x = x;
    pt[0].y = y;
    pt[1].x = x + sz - 1;
    pt[1].y = y;
    pt[2].x = x + sz2;
    pt[2].y = y + sz;
    XFillPolygon(Xdisplay, scrollBar.win, scrollbarGC,
		 pt, 3, Convex, CoordModeOrigin);

/* draw base */
    XDrawLine(Xdisplay, scrollBar.win, top,
	      pt[0].x, pt[0].y, pt[1].x, pt[1].y);

/* draw shadow */
    pt[1].x = x + sz2 - 1;
    pt[1].y = y + sz - 1;
    XDrawLine(Xdisplay, scrollBar.win, top,
	      pt[0].x, pt[0].y, pt[1].x, pt[1].y);
#if (SHADOW > 1)
/* doubled */
    pt[0].x++;
    pt[0].y++;
    pt[1].y--;
    XDrawLine(Xdisplay, scrollBar.win, top,
	      pt[0].x, pt[0].y, pt[1].x, pt[1].y);
#endif
/* draw shadow */
    pt[0].x = x + sz2;
    pt[0].y = y + sz - 1;
    pt[1].x = x + sz - 1;
    pt[1].y = y;
    XDrawLine(Xdisplay, scrollBar.win, bot,
	      pt[0].x, pt[0].y, pt[1].x, pt[1].y);
#if (SHADOW > 1)
/* doubled */
    pt[0].y--;
    pt[1].x--;
    pt[1].y++;
    XDrawLine(Xdisplay, scrollBar.win, bot,
	      pt[0].x, pt[0].y, pt[1].x, pt[1].y);
#endif
}
#endif				/* XTERM_SCROLLBAR */

/* PROTO */
int
scrollbar_mapping(int map)
{
    int             change = 0;

    if (map && !scrollbar_visible()) {
	scrollBar.state = 1;
	XMapWindow(Xdisplay, scrollBar.win);
	change = 1;
    } else if (!map && scrollbar_visible()) {
	scrollBar.state = 0;
	XUnmapWindow(Xdisplay, scrollBar.win);
	change = 1;
    }
    return change;
}

/* PROTO */
int
scrollbar_show(int update)
{
    static short    last_top, last_bot, sb_width;	/* old (drawn) values */
    int		    xsb = 0;

    if (!scrollbar_visible())
	return 0;

    if (scrollbarGC == None) {
	XGCValues       gcvalue;

#ifdef XTERM_SCROLLBAR
	sb_width = SB_WIDTH - 1;
	gcvalue.stipple = XCreateBitmapFromData(Xdisplay, scrollBar.win,
						sb_bits, 12, 2);
	if (!gcvalue.stipple) {
	    print_error("can't create bitmap");
	    exit(EXIT_FAILURE);
	}
	gcvalue.fill_style = FillOpaqueStippled;
	gcvalue.foreground = PixColors[fgColor];
	gcvalue.background = PixColors[bgColor];

	scrollbarGC = XCreateGC(Xdisplay, scrollBar.win,
				GCForeground | GCBackground |
				GCFillStyle | GCStipple,
				&gcvalue);
        gcvalue.foreground = PixColors[borderColor];
	ShadowGC = XCreateGC(Xdisplay, scrollBar.win, GCForeground, &gcvalue);
#else				/* XTERM_SCROLLBAR */
	sb_width = SB_WIDTH;
	gcvalue.foreground = (Xdepth <= 2 ? PixColors[fgColor]
# ifdef KEEP_SCROLLCOLOR
					  : PixColors[scrollColor]);
# else
	                                  : PixColors[fgColor]);
# endif
	scrollbarGC = XCreateGC(Xdisplay, scrollBar.win, GCForeground,
				&gcvalue);

	if (sb_shadow) {
	    XSetWindowBackground(Xdisplay, scrollBar.win, gcvalue.foreground);
	    XClearWindow(Xdisplay, scrollBar.win);
	}

# ifdef KEEP_SCROLLCOLOR
	gcvalue.foreground = PixColors[topShadowColor];
# else
	gcvalue.foreground = PixColors[bgColor];
# endif
	topShadowGC = XCreateGC(Xdisplay, scrollBar.win,
				GCForeground,
				&gcvalue);

# ifdef KEEP_SCROLLCOLOR
	gcvalue.foreground = PixColors[bottomShadowColor];
# else
	gcvalue.foreground = PixColors[bgColor];
# endif
	botShadowGC = XCreateGC(Xdisplay, scrollBar.win,
				GCForeground,
				&gcvalue);
#endif				/* XTERM_SCROLLBAR */
    }

    if (update) {
	int             top = (TermWin.nscrolled - TermWin.view_start);
	int             bot = top + (TermWin.nrow - 1);
	int             len = max((TermWin.nscrolled + (TermWin.nrow - 1)),1);

	scrollBar.top = (scrollBar.beg + (top * scrollbar_size()) / len);
	scrollBar.bot = (scrollBar.beg + (bot * scrollbar_size()) / len);
    /* no change */
	if ((scrollBar.top == last_top) && (scrollBar.bot == last_bot))
	    return 0;
    }
/* instead of XClearWindow (Xdisplay, scrollBar.win); */
#ifdef XTERM_SCROLLBAR
    xsb = (Options & Opt_scrollBar_right) ? 1 : 0;
#endif
    if (last_top < scrollBar.top)
	XClearArea(Xdisplay, scrollBar.win,
		   sb_shadow + xsb, last_top,
		   sb_width, (scrollBar.top - last_top),
		   False);

    if (scrollBar.bot < last_bot)
	XClearArea(Xdisplay, scrollBar.win,
		   sb_shadow + xsb, scrollBar.bot,
		   sb_width, (last_bot - scrollBar.bot),
		   False);

    last_top = scrollBar.top;
    last_bot = scrollBar.bot;

/* scrollbar slider */
#ifdef XTERM_SCROLLBAR
    XFillRectangle(Xdisplay, scrollBar.win, scrollbarGC,
		   xsb + 1, scrollBar.top,
		   sb_width - 2, (scrollBar.bot - scrollBar.top));

    XDrawLine(Xdisplay, scrollBar.win, ShadowGC,
	      xsb ? 0 : 14, scrollBar.beg, xsb ? 0 : 14, scrollBar.end);
#else
    XFillRectangle(Xdisplay, scrollBar.win, scrollbarGC,
		   sb_shadow, scrollBar.top,
		   sb_width, (scrollBar.bot - scrollBar.top));

    if (sb_shadow)
    /* trough shadow */
	Draw_Shadow(scrollBar.win,
		    botShadowGC, topShadowGC,
		    0, 0,
		    (sb_width + 2 * sb_shadow),
		    (scrollBar.end + (sb_width + 1) + sb_shadow));
/* shadow for scrollbar slider */
    Draw_Shadow(scrollBar.win,
		topShadowGC, botShadowGC,
		sb_shadow, scrollBar.top, sb_width,
		(scrollBar.bot - scrollBar.top));

/*
 * Redraw scrollbar arrows
 */
    Draw_up_button(sb_shadow, sb_shadow, (scrollbar_isUp()? -1 : +1));
    Draw_dn_button(sb_shadow, (scrollBar.end + 1), (scrollbar_isDn()? -1 : +1));
#endif				/* XTERM_SCROLLBAR */

    return 1;
}

/*----------------------- end-of-file (C source) -----------------------*/
