/* sr_bug.c
 *
 * This program tests for a gcc bug.
 * To compile this test program:  gcc -O2 sr_bug.c
 *
 * Sometimes gcc for Intel CPUs generates bad code at optimization
 * level 2.  The bad code is 'almost right' and stay hidden inside
 * a program that seems to work - including the Linux kernel.
 * The bug is very old and has been reported.  As of 19-Dec-95,
 * the bug has not been fixed.
 *
 * If you change this code you should test it, because even a
 * tiny change will hide this elusive bug.  If you think you
 * fixed the bug, please run the original test just to make
 * sure. You can find the original test below, after the #if 0.
 * I wrote this version of the test to be user-friendly, and
 * it may not be as solid as the original.
 *
 * Some people who know more than I do:
 * davis@space.mit.edu (John E. Davis)
 * anlauf@crunch.ikp.physik.th-darmstadt.de (Harald Anlauf)
 * craigs@iii2.iii.net (Craig Shrimpton)
 *
 * User-friendly version by Albert Cahalan
 *
 */
 
#include <stdio.h>

int gcc_sr_bug(void){
  static int Array[3]; /* must be static (or global) */
  unsigned int B = 3;  /* must be unsigned 32-bit */
  int i;
  for(i=0; i<B; i++) Array[i] = i - 3;
  for(i=0; i<B; i++) printf(" %d,%d", i, Array[i]);
  return !Array[1];
}

int main(){
  printf("Testing for gcc bug...");
  if(gcc_sr_bug()){
    printf("\n\nBad code! Your compiler generates bad output.\n\n");
    printf("Add -fno-strength-reduce to your gcc command line\n");
    printf("or put it into your gcc config file, such as in\n");
    printf("/usr/lib/gcc-lib/i486-linux/2.7.0/specs.\n");
    exit(1);
  }else{
    printf("\nOK, no problem.\n");
    exit(0);
  }
}

#if 0
/*********  original code + whitespace  ***********/

#include <stdio.h>

int A[3];
unsigned int B = 3;

void printit(void){
  int i;
  for(i = 0; i < B; i++) fprintf(stdout, "A[%d] = %d\n", i, A[i]);
}

int main(){
  int i;
  for(i = 0; i < B; i++) A[i] = i - 3;
  printit();
  return 0;
}

#endif
