/*
     WWW-SQL - parses HTML files and inserts information from MySQL databases
    Copyright (C) 1997  James Henstridge <james@daa.com.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*   if.c - routines to handle if statements
 * I put them here so they wouldn't be cluttered.  No expression parsing is
 * done in these functions.  If you want to find that, look at expr.c (A
 * hacked up version of the GNU sh-util expr)
 */

#include <stdlib.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
void *xmalloc();

#include "cmds.h"

/* Function prototypes */
char *substVars(char *);     /* from www-sql */
int evalExpr(int, char **);  /* from expr.c */

typedef struct if_stack {
  int stat, active;           /* 0 for false, 1 for true */
  struct if_stack *prev;  /* The if statment, one level up */
} IFSTACK;

IFSTACK *curIf;

#define checkIf (curIf->stat && curIf->active)

void initIfStack() {
  curIf = xmalloc(sizeof(IFSTACK));
  curIf->stat = 1;
  curIf->active = 1;
  curIf->prev = NULL;  /* mark bottom of stack */
}

void cmdIf(int argc, char *argv[]) {
  char *tmp;
  int i;
  IFSTACK *is;

  if (checkIf) {
    for (i=0; i < argc; i++) {   /* perform substitutions */
      tmp = substVars(argv[i]);
      free(argv[i]);
      argv[i] = tmp;
    }

    is = xmalloc(sizeof(IFSTACK));
    is->stat = evalExpr(argc, argv);
    is->active = 1;
    is->prev = curIf;
    curIf = is;
  } else {                        /* we must parse if statements in  */
    is = xmalloc(sizeof(IFSTACK)); /* sections of a document excluded */
    is->stat = 0;                 /* by other if statements to match */
    is->active = 0;               /* up the elses and endifs         */
    is->prev = curIf;
    curIf = is;
  }
}

/* This command was contributed by David J. N. Begley <d.begley@ieee.org>. */
void cmdElsIf(int argc, char *argv[]) {
  char *tmp;
  int i;

  if (curIf->prev != NULL) {
    if (curIf->active && !curIf->stat) {
      for (i=0; i < argc; i++) {   /* perform substitutions */
        tmp = substVars(argv[i]);
        free(argv[i]);
        argv[i] = tmp;
      }
      curIf->stat = evalExpr(argc, argv);
      curIf->active = 1;
    } else {                        /* we must parse elsif statements to  */
      curIf->stat = 0;              /* match up the elses and endifs      */
      curIf->active = 0;
    }
  }
}

void cmdElse(int argc, char *argv[]) {
  curIf->stat = ! curIf->stat;
}

void cmdEndIf(int argc, char *argv[]) {
  IFSTACK *is;

  is = curIf;
  if (curIf->prev != NULL) {   /* make sure the user doesn't remove the  */
    curIf = is->prev;          /* last if from the stack.  (I don't like */
    free(is);                  /* core dumps.)                           */
  }
}

commands if_funcs = {
  {"else",  cmdElse},
  {"elsif", cmdElsIf},
  {"endif", cmdEndIf},
  {"if",    cmdIf},
  {NULL, NULL}
};



