// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1993,94,95
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        material.h
//
// Purpose:     interface to materials
//
// Created:      8 Feb 93   Michael Pichler
//
// Changed:     13 Nov 95   Michael Pichler
//
// $Id: material.h,v 1.4 1997/02/25 17:03:58 mpichler Exp $
//
//</file>


#ifndef harmony_scene_material_h
#define harmony_scene_material_h


#include <hyperg/utils/str.h>
#include <ge3d/color.h>


class Material
{
  public:
    Material (const char* name, float r, float g, float b, const char* texture);
    ~Material ();

    const char* name () const  { return name_; }

    void setge3d (                      // sets color_ [colindex] to ge3d library
      int hilitindex,                   //   highlighting method (or 0 for no highlight)
      int texturing,                    //   texturing flag
      int pickable,                     //   pickable flag (emphasize or grey out)
      const colorRGB* col_anchorface,   //   fill colour of anchor faces
      const colorRGB* col_anchoredge    //   edge colour of anchor faces
    ) const;

    void print () const;
    const colorRGB* natural () const  { return &natural_; }

    const char* texture () const  { return texture_; }
    int texhandle () const  { return texhandle_; }
    void texhandle (int h)  { texhandle_ = h; }

  private:                              // many current Hardware types only support diffuse color
    RString name_;
    colorRGB natural_, bright_, dark_;  // natural, highlighted, and dark color
    float L_;                           // brightness
    RString texture_;                   // texture name
    int texhandle_;                     // texture handle (for ge3d)
};



#endif
