#ifndef	lint
static char rcs_id[] = "$Id: killxwnmo.c,v 1.3 1994/10/03 23:17:35 kuwa Exp $";
#endif	/* lint */
/*
 * Copyright 1992 by OMRON Corporation
 * Copyright 1992 by Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of OMRON and MIT not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  OMRON and MIT make no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * Wnn consortium is one of distributors of the official Wnn source code
 * release.  Wnn consortium also makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * OMRON, MIT AND WNN CONSORTIUM DISCLAIM ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL OMRON, MIT OR WNN CONSORTIUM BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *	Author:	Seiji Kuwari	OMRON Corporation
 *				kuwa@omron.co.jp
 *				kuwa%omron.co.jp@uunet.uu.net
 */				
#include <signal.h>
#include <pwd.h>
#include "wnn_os.h"
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include "commonhd.h"
#include "sdefine.h"

void
signal_catch()
{
    printf("Could not get any replay from the input manager \"%s\".\n",
	   XIM_INPUTMETHOD);
    exit(1);
}

void
main(argc, argv)
int argc;
char **argv;
{
    Display *dpy;
    Window window, im_id;
    XEvent event;
    Atom atom_im, prop_id = (Atom)0;
    char uname[128], *p;
    int force = 0;
    extern int getuid();

    if (argc > 1) {
	if (argv[1][0] == '-' && argv[1][1] == '9') force = 1;
    }
    if (!(dpy = XOpenDisplay(""))) {
	printf("Could not open Display\n");
	exit(1);
    }
    if ((atom_im = XInternAtom(dpy, XIM_INPUTMETHOD, True)) == None ||
	(im_id = XGetSelectionOwner(dpy, atom_im)) == (Window)0) {
	printf("Could not find the input manager \"%s\".\n", XIM_INPUTMETHOD);
	exit(1);
    }
    window = XCreateSimpleWindow(dpy, RootWindow(dpy, DefaultScreen(dpy)),
				 10, 10, 10, 10, 1, 0, 0);
    prop_id = XInternAtom(dpy, "XWNMO_KILL_PROP", False);
    if (!(p = getpwuid(getuid())->pw_name)) {
	printf("Could not get the user name.\n");
	exit(1);
    }
    strcpy(uname, p);
    XChangeProperty(dpy, RootWindow(dpy, DefaultScreen(dpy)), prop_id,
		    XA_STRING, 8, PropModeReplace, (unsigned char *)uname,
		    strlen(uname));
    event.type = ClientMessage;
    event.xclient.format = 32;
    event.xclient.window = window;
    event.xclient.data.l[0] = XWNMO_KILL;
    event.xclient.data.l[1] = window;
    event.xclient.data.l[2] = prop_id;
    event.xclient.data.l[3] = force;
    XSendEvent(dpy, im_id, False, NoEventMask, &event);
    signal(SIGALRM, signal_catch);
    alarm(10);	/* If return doesn't occur while 10 minutes, go to exit. */
    while(1) {
	XNextEvent(dpy, &event);
	if (event.type != ClientMessage ||
	    event.xclient.data.l[0] != XWNMO_KILL) continue;
	if (event.xclient.data.l[1] == XWNMO_KILL_OK) {
	    printf("Completed termination of the input manager \"%s\".\n",
		   XIM_INPUTMETHOD);
	} else {
	    printf("Failed termination of the input manager \"%s\".\n",
		   XIM_INPUTMETHOD);
	    if (event.xclient.data.l[2] == -1) {
		printf("Because permission denied.\n");
	    } else {
		printf("Because %d client(s) connect(s) to it.\n",
		       event.xclient.data.l[2]);
	    }
	}
	exit(0);
    }
}
