#! /bin/bash
cat 1>&2 << _HERE_
This script contains some very primitive test cases for ftape's bsf handling.
It erases the currently inserted cartridge. Please read it carefully before
using it and delete these lines if you really want to use it. Read also the
"Testing ftape" chapter of the manual!
_HERE_
#' <-- my emacs sh mode is a bit broken
exit 1
set -x
tp=${1-qft0}
cd /var/src/ftape-3.03a
rmmod zft-compressor || true
rmmod ftape-format || true
rmmod zftape || true
rmmod sftape || true
rmmod ftape || true
swapout 10
insmod ftape.o
insmod zftape.o
#
# erase the tape, just to be sure
#
mt -f /dev/$tp erase
#
# make the first backup, the "--verify" already tests the bsf ioctl
#
tar -cvf /dev/$tp -V "First Volume" --verify  /bin
#
# skip to end of tape, note the "n" in front of $tp
#
mt -f /dev/n$tp eom
#
# make the second backup
#
tar -cvf /dev/$tp -V "Second Volume" --verify /etc
#
# rewind, then skip to the second volume
#
mt -f /dev/$tp rewind
mt -f /dev/n$tp fsf 1
#
# read it back
#
tar -tvf /dev/n$tp
#
# go back to the beginning of THIS volume
#
mt -f /dev/n$tp bsf 1
#
# again, read it back. Should still be the second volume
#
tar -tvf /dev/n$tp
#
# now skip to the previous volume:
#
mt -f /dev/n$tp bsf 2
#
# read it back, should be first volume on tape
#
tar -tvf /dev/n$tp
#
# try the same with the "mt status" command:
#
mt -f /dev/$tp rewind
mt -f /dev/n$tp status
#
# skip to second volume
#
mt -f /dev/n$tp fsf 1
mt -f /dev/n$tp status
#
# stay within the same volume
#
mt -f /dev/n$tp bsf 1
mt -f /dev/n$tp status
#
# skip to the previous volume
# 
mt -f /dev/n$tp bsf 2
mt -f /dev/n$tp status
#
# cleanup
#
mt -f /dev/n$tp rewoffl
rmmod zftape
rmmod ftape
exit 0
