#ifndef _FTFMT_OPTIONS_H
#define _FTFMT_OPTIONS_H

/*
 *      Copyright (C) 1997 Claus-Justus Heine

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 * $Source: /homes/cvs/ftape-stacked/contrib/ftformat/ftfmt-options.h,v $
 * $Revision: 1.3 $
 * $Date: 1997/10/05 19:17:36 $
 *
 *      This program contains the options parsing function
 *      declarations for theuser level floppy tape formatting stuff
 *      for the QIC-40/80/3010/3020 floppy-tape driver "ftape" for
 *      Linux.
 */

#define FTAPE_DEF_LABEL "Ftape - The Linux Floppy Tape Project!"
#define FTAPE_DEF_TAPE "/dev/rawft0"

#define UNSET(opt) ((opt) == (typeof(opt))-1)

/*  settings that affect the tape format itself
 */
struct format_parms {
	struct ftfmtparms fmtparms;
	u_int8_t          gap3;
};

/*  parameters that affect the behavior of the program
 */
struct opt_parms {
	u_int8_t *label;
	char *tape_dev;
	unsigned long dma_size;
	enum op_mode { AUTO = 0, FORCE,	PROBING	} mode;
	int erase;        /* erase using phys. forward/reverse */
	int read_hseg;    /* read old header segment */
	int write_bursts; /* write reference bursts  */
	int do_format;    /* really format the cartridge */
	int verbose;      /* unused yet */
	int debug;        /* unused yet */
};

extern void parse_options(int argc, char *argv[],
						  struct opt_parms *optp,
						  struct format_parms *fmt_parms);
extern int  autodetect(const int tape_fd,
					   const u_int8_t drive_status,
					   const u_int8_t drive_config,
					   const u_int8_t tape_status,
					   struct opt_parms *opts,
					   struct format_parms *fmt_opts);
extern void report_format_parms(FILE *channel,
								const struct format_parms *fmt_opts);

#endif

/*
 * Local variables:
 *  version-control: t
 *  kept-new-versions: 5
 *  c-basic-offset: 4
 *  tab-width: 4
 * End:
 */
