;; $Id: dbsynop.dsl 1.0 1997/12/30 17:30:52 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ========================= SYNTAX DEFINITIONS =========================

(element SYNOPSIS ($verbatim-display$ %number-synopsis-lines%))

(element CMDSYNOPSIS
  ;; Can't be an $informal-object$ because it needs the paragraph
  ;; wrapper around process-children
  (make display-group
    start-indent: (+ %block-start-indent% (inherited-start-indent))
    space-before: %block-sep%
    space-after: %block-sep%
    (make paragraph
      (process-children))))

;; Support for ARG provided by James Bostock, augmented by norm
;;

(element GROUP
  (let ((choice (attribute-string "Choice"))
	(rep (attribute-string "Rep")))
    (make sequence
      (if (first-sibling? (current-node))
	  (literal (inherited-attribute-string "sepchar"))
	  (empty-sosofo))
      (case choice
	(("PLAIN") (literal %arg-choice-plain-open-str%))
	(("REQ") (literal %arg-choice-req-open-str%))
	(("OPT") (literal %arg-choice-opt-open-str%))
	(else (literal %arg-choice-def-open-str%)))
      (process-children)
      (case rep
	(("REPEAT") (literal %arg-rep-repeat-str%))
	(("NOREPEAT") (literal %arg-rep-norepeat-str%))
	(else (literal %arg-rep-def-str%)))
      (case choice
	(("PLAIN") (literal %arg-choice-plain-close-str%))
	(("REQ") (literal %arg-choice-req-close-str%))
	(("OPT") (literal %arg-choice-opt-close-str%))
	(else (literal %arg-choice-def-close-str%)))
      (literal " "))))

(element ARG
  (let ((choice (attribute-string "Choice"))
	(rep (attribute-string "Rep")))
    (make sequence
      (if (first-sibling? (current-node))
	  (literal (inherited-attribute-string "sepchar"))
	  (empty-sosofo))
      (case choice
	(("PLAIN") (literal %arg-choice-plain-open-str%))
	(("REQ") (literal %arg-choice-req-open-str%))
	(("OPT") (literal %arg-choice-opt-open-str%))
	(else (literal %arg-choice-def-open-str%)))
      (process-children)
      (case rep
	(("REPEAT") (literal %arg-rep-repeat-str%))
	(("NOREPEAT") (literal %arg-rep-norepeat-str%))
	(else (literal %arg-rep-def-str%)))
      (case choice
	(("PLAIN") (literal %arg-choice-plain-close-str%))
	(("REQ") (literal %arg-choice-req-close-str%))
	(("OPT") (literal %arg-choice-opt-close-str%))
	(else (literal %arg-choice-def-close-str%)))
      (literal " "))))

(element (GROUP ARG)
  (let ((choice (attribute-string "Choice"))
	(rep (attribute-string "Rep")))
    (make sequence
      (if (not (first-sibling? (current-node)))
	  (literal %arg-or-sep%)
	  (empty-sosofo))
      (process-children))))

(element SBR 
  (make sequence
    (make paragraph-break)))

(element SYNOPFRAGMENTREF ($paragraph$))
(element SYNOPFRAGMENT (process-children))

(element FUNCSYNOPSIS ($informal-object$))

(element FUNCSYNOPSISINFO ($verbatim-display$ %number-funcsynopsisinfo-lines%))

(element FUNCPROTOTYPE 
  (let ((paramdefs (select-elements (children (current-node)) "PARAMDEF")))
    (make sequence
      (make paragraph
	font-family-name: %mono-font-family%
	(process-children))
      (if (equal? %funcsynopsis-style% 'kr)
	  (with-mode ansi-funcsynopsis-mode
	    (process-node-list paramdefs))
	  (empty-sosofo)))))

(element FUNCDEF (process-children))
(element (FUNCDEF FUNCTION) (process-children))

(element VOID 
  (if (equal? %funcsynopsis-style% 'ansi)
      (literal "(void);")
      (literal "();")))

(element VARARGS (literal "(...);"))

(element PARAMDEF
  (let ((param (select-elements (children (current-node)) "PARAMETER")))
    (make sequence
      (if (equal? (child-number (current-node)) 1)
	  (literal "(")
	  (empty-sosofo))
      (if (equal? %funcsynopsis-style% 'ansi)
	  (process-children)
	  (process-node-list param))
      (if (equal? (gi (ifollow (current-node))) "PARAMDEF")
	  (literal ", ")
	  (literal ");")))))
  
(element (PARAMDEF PARAMETER)
  (process-children))

(element FUNCPARAMS 
  (make sequence 
    (literal "(")
    (process-children)
    (literal ")")))

(mode ansi-funcsynopsis-mode
  (element PARAMDEF
    (make sequence
      (make paragraph
	font-family-name: %mono-font-family%
	start-indent: (+ (inherited-start-indent) 0.5in)
	(make sequence
	  (process-children) 
	  (literal ";"))))))
