;; $Id: dbsect.dsl 1.2 1998/02/08 21:41:31 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ============================== SECTIONS ==============================

;; BRIDGEHEAD isn't a proper section, but appears to be a section title
(element BRIDGEHEAD
  (let* ((renderas (attribute-string "renderas"))
	 (hlevel                          ;; the apparent section level;
	  (if renderas                    ;; if not real section level,
	      (string->number             ;;   then get the apparent level
	       (substring renderas 4 5))  ;;   from "renderas",
	      (SECTLEVEL)))               ;; else use the real level
	 (hs (HSIZE (- 4 hlevel))))
    (make paragraph
      font-family-name: %title-font-family%
      font-weight:  (if (< hlevel 5) 'bold 'medium)
      font-posture: (if (< hlevel 5) 'upright 'italic)
      font-size: hs
      line-spacing: (* hs %line-spacing-factor%)
      space-before: (* hs %head-before-factor%)
      space-after: (* hs %head-after-factor%)
      start-indent: (if (< hlevel 3)
			0pt
			%body-start-indent%)
      first-line-start-indent: 0pt
      quadding: %section-title-quadding%
      keep-with-next?: #t
;;    heading-level: (+ hlevel 1)
      (process-children))))

(define ($section$)
  (make display-group
    space-before: %block-sep%
    space-after: %block-sep%
    start-indent: %body-start-indent%
    (make sequence
      ($section-title$)
      (process-children))))

(define ($section-info$) 
  (let ((sect (current-node)))
    (cond
     ((equal? (gi) "SECT1") (select-elements (children sect) "SECT1INFO"))
     ((equal? (gi) "SECT2") (select-elements (children sect) "SECT2INFO"))
     ((equal? (gi) "SECT3") (select-elements (children sect) "SECT3INFO"))
     ((equal? (gi) "SECT4") (select-elements (children sect) "SECT4INFO"))
     ((equal? (gi) "SECT5") (select-elements (children sect) "SECT5INFO"))
     ((equal? (gi) "REFSECT1") 
      (select-elements (children sect) "REFSECT1INFO"))
     ((equal? (gi) "REFSECT2") 
      (select-elements (children sect) "REFSECT2INFO"))
     ((equal? (gi) "REFSECT3") 
      (select-elements (children sect) "REFSECT3INFO"))
     (else ;; BIBLIODIV, GLOSSDIV, INDEXDIV, PARTINTRO, SIMPLESECT
      (select-elements (children sect) "DOCINFO")))))

(define ($section-hlevel$ #!optional (sectname (gi))) 
  (cond
   ((equal? sectname "SECT1") 1)
   ((equal? sectname "SECT2") 2)
   ((equal? sectname "SECT3") 3)
   ((equal? sectname "SECT4") 4)
   ((equal? sectname "SECT5") 5)
   ((equal? sectname "REFSECT1") 2)
   ((equal? sectname "REFSECT2") 3)
   ((equal? sectname "REFSECT3") 4)
   (else ;; BIBLIODIV, GLOSSDIV, INDEXDIV, PARTINTRO, SIMPLESECT
    1)))

(define ($section-title$)
  (let* ((sect (current-node))
	 (info ($section-info$))
	 (exp-children (if (node-list-empty? info)
			   (empty-node-list)
			   (expand-children (children info) '("BOOKBIBLIO" 
							      "BIBLIOMISC"
							      "BIBLIOSET"))))
	 (parent-titles (select-elements (children sect) "TITLE"))
	 (info-titles   (select-elements exp-children "TITLE"))
	 (titles        (if (node-list-empty? parent-titles)
			    info-titles
			    parent-titles))
	 (subtitles     (select-elements exp-children "SUBTITLE"))
	 (renderas (inherited-attribute-string "renderas" sect))
	 (hlevel                          ;; the apparent section level;
	  (if renderas                    ;; if a rendering is selected
	      ($section-hlevel$ renderas) ;;   use it
	      (SECTLEVEL)))               ;; else use the real level
	 (hs (HSIZE (- 4 hlevel))))
    (make sequence
      (make paragraph
	font-family-name: %title-font-family%
	font-weight:  (if (< hlevel 5) 'bold 'medium)
	font-posture: (if (< hlevel 5) 'upright 'italic)
	font-size: hs
	line-spacing: (* hs %line-spacing-factor%)
	space-before: (* hs %head-before-factor%)
	space-after: (if (node-list-empty? subtitles)
			 (* hs %head-after-factor%)
			 0pt)
	start-indent: (if (or (>= hlevel 3)
			      (member (gi) '("REFSECT1" 
					     "REFSECT2" 
					     "REFSECT3")))
			  %body-start-indent%
			  0pt)
	first-line-start-indent: 0pt
	quadding: %section-title-quadding%
	keep-with-next?: #t
;;	heading-level: (+ hlevel 1)
	;; SimpleSects are never AUTO numbered...they aren't hierarchical
	(if (string=? (element-label (current-node)) "")
	    (empty-sosofo)
	    (literal (element-label (current-node)) 
		     (gentext-label-title-sep (gi sect))))
	(element-title-sosofo (current-node)))
      (with-mode section-title-mode
	(process-node-list subtitles)))))

(mode section-title-mode
  (element SUBTITLE
    (let* ((sect (parent (parent (current-node)))) ;; parent=>sect*info
	   (renderas (inherited-attribute-string "renderas" sect))
	   (hlevel                          ;; the apparent section level;
	    (if renderas                    ;; if not real section level,
		(string->number             ;;   then get the apparent level
		 (substring renderas 4 5))  ;;   from "renderas",
		(SECTLEVEL sect)))          ;; else use the real level
	   (hs (HSIZE (- 3 hlevel))))       ;; one smaller than the title...
      (make paragraph
	font-family-name: %title-font-family%
	font-weight:  (if (< hlevel 5) 'bold 'medium)
	font-posture: (if (< hlevel 5) 'upright 'italic)
	font-size: hs
	line-spacing: (* hs %line-spacing-factor%)
	space-before: 0pt
	space-after: (* hs %head-after-factor%)
	start-indent:
	(if (< hlevel 3)
	    0pt
	    %body-start-indent%)
	first-line-start-indent: 0pt
	quadding: %section-subtitle-quadding%
	keep-with-next?: #t
	(process-children))))
)

(element SECT1 ($section$))
(element (SECT1 TITLE) (empty-sosofo))

(element SECT2 ($section$))
(element (SECT2 TITLE) (empty-sosofo))

(element SECT3 ($section$))
(element (SECT3 TITLE) (empty-sosofo))

(element SECT4 ($section$))
(element (SECT4 TITLE) (empty-sosofo))

(element SECT5 ($section$))
(element (SECT5 TITLE) (empty-sosofo))

(element SIMPLESECT ($section$))
(element (SIMPLESECT TITLE) (empty-sosofo))

