/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 */

#ifdef __DRIVER_STRU__

#define PCM_MAX_BLOCKS		(32*4)		/* look to VoxWare */
#define PCM_ZERO_RESERVED	(2 * sizeof( unsigned int ) + 3 * sizeof( unsigned short ))
#define PCM_HW_FUNCTIONS	8

typedef struct GUS_STRU_PCM_CHANNEL gus_pcm_channel_t;
typedef struct GUS_STRU_PCM gus_pcm_t;

struct GUS_STRU_PCM_CHANNEL {
  /* -- format -- */
  unsigned short voices;	/* or channels 1-32 */
  unsigned int mode;
  unsigned int format;
  unsigned int rate;
  unsigned int requested_block_size;
  unsigned int requested_blocks;
  unsigned int requested_subdivision;
  unsigned int processed_bytes;
  unsigned int interrupts;
  /* -- physical/flags -- */
  unsigned short flags;
  unsigned int used_size;	/* used size of DMA buffer */
  unsigned char *hidden_buffer;	/* pointer to hidden DMA buffer - GF1 PCM only */
  unsigned char neutral_byte;
  struct GUS_STRU_DMA *_dma;	/* pointer to dma structure */
  unsigned short dma;
  unsigned int size;		/* size of DMA buffer */
  unsigned char *buffer;	/* pointer to DMA buffer */
  /* -- logical blocks -- */
  unsigned short blocks;	/* number of blocks (2-16) */
  unsigned int block_size;	/* size of one block */
  unsigned short used;		/* number of used blocks */
  unsigned short head;		/* fill it... */
  unsigned short tail;		/* remove it... */
  unsigned short locks;		/* block is locked? (bitmap) */
  unsigned int sizes[ PCM_MAX_BLOCKS ]; /* actual size of block */
  /* -- thess values aren't erased -- */
  unsigned int discarded;	/* discarded blocks... */
  unsigned int formats;		/* supported formats... */
  unsigned short min_fragment;	/* minimal fragment... */
  unsigned short max_rate;	/* maximal rate... */
  unsigned short max_voices;	/* maximal voices... */
  /* -- physical HW functions -- */
  int (*hw_open)( gus_pcm_t *pcm );
  void (*hw_close)( gus_pcm_t *pcm );
  void (*hw_init)( gus_pcm_t *pcm );
  void (*hw_done)( gus_pcm_t *pcm );
  void (*hw_dma)( gus_pcm_t *pcm, gus_pcm_channel_t *pchn, char *buf, unsigned int size );
  void (*hw_dma_neutral)( gus_pcm_t *pcm, gus_pcm_channel_t *pchn );
  void (*hw_sync)( gus_pcm_t *pcm );
  unsigned int (*hw_pointer)( gus_pcm_t *pcm );
#if 0
  unsigned int (*hw_max_dma_block)( gus_card_t *card );
#endif
};

struct GUS_STRU_PCM {
  gus_card_t *card;		/* ok, must be */
  unsigned short flags;
  unsigned short mask;
  unsigned int info_flags;
  char *info_name;
  struct GUS_STRU_PCM_CHANNEL chn[ 2 ];
  SLEEP_DEFINE( playback )
  SLEEP_DEFINE( record )
};

#endif /* __DRIVER_STRU__ */

#ifdef __DRIVER_MAIN__

#define PCM_PLAYBACK	0x00
#define PCM_RECORD	0x01

#define PCM_LFLG_NONE   0x0000
#define PCM_LFLG_PLAY   0x0001
#define PCM_LFLG_RECORD 0x0002
#define PCM_LFLG_BOTH   (PCM_LFLG_PLAY|PCM_LFLG_RECORD) 
#define PCM_LFLG_REALTIME 0x0100
#define PCM_LFLG_USED	0x8000

#define PCM_DEFAULT_RATE 8000

#define PCM_MODE_MULTI	0x0010		/* set - multitrack (1-32) operation enabled */
#define PCM_MODE_VALID	0x0080		/* unset = not valid, set = valid */
#define PCM_MODE_U	0x0100		/* unset = signed, set = unsigned */
#define PCM_MODE_16	0x0200		/* unset = 8 bit , set = 16 bit   */
#define PCM_MODE_BIG	0x0400		/* big endian (16-bit mode) */
#define PCM_MODE_ULAW	0x0800
#define PCM_MODE_ALAW	0x1000
#define PCM_MODE_ADPCM	0x2000
#define PCM_MODE_TYPE	0xff00

#define PCM_FLG_NONE	0x0000
#define PCM_FLG_SLEEP	0x0001		/* channel is in sleep state - need wakeup */
#define PCM_FLG_ABORT	0x0002		/* user abort */
#define PCM_FLG_NONBLK	0x0004		/* non block I/O */
#define PCM_FLG_MMAP	0x0008		/* mmaped access */
#define PCM_FLG_DMAOK	0x0010		/* DMA is now allocated */
#define PCM_FLG_NEUTRAL	0x0100		/* erase DMA buffer (fill with neutral byte) */
#define PCM_FLG_BUFFERS	0x0200		/* compute new buffer sizes */
#define PCM_FLG_TRIGGER	0x0400		/* trigger on/off */
#define PCM_FLG_ENABLE	0x0800		/* enable/disable channel */
#define PCM_FLG_SYNC	0x1000		/* synchronize playback */
#define PCM_FLG_REALTM	0x2000		/* need realtime... */

#endif /* __DRIVER_MAIN__ */
