// repclone.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "application.h"
#include "range.h"
#include "repclone.h"

void
Clone::changeNChans(int newchans) {
	int oldchans = cloneChans;
	double ratio = oldchans / double(newchans);
	cloneChans = newchans;
	cloneLen = int(cloneLen * ratio);
}

////////

template <class Rep>
Cloned<Rep>::Cloned(Rep *r, const Range &selection, const Range &chanrange)
		: Rep(r),
		  Clone(r,
		        selection.intMin() < realLength() ? selection.size() : 0,
		        chanrange.size()) {
	offsetPointer(
		getHandle(selection.intMin(), chanrange.intMin()) - arrayOffset()
	);
}

template <class Rep>
void
Cloned<Rep>::valueRange(Range &r, int start, int end, int chfirst, int chlast, boolean real) const {
	if(real)
		master->valueRange(r, start, end, chfirst, chlast, real);
	else
		Rep::valueRange(r, start, end, chfirst, chlast, real);
}

template <class Rep>
int
Cloned<Rep>::changeLength(int newlen) {
	int oldlen = master->length();
	if(master->changeLength(newlen)) {
		int diff = master->length() - oldlen;
		len += diff;
		cloneLen += diff;
		return 1;
	}
	return 0;
}

template <class Rep>
void
Cloned<Rep>::changeNChans(int newchans) {
	Rep::changeNChans(newchans);
	Clone::changeNChans(newchans);
}

#ifdef __GNUG__
template class Cloned<SignedCharDataRep>;
template class Cloned<UnsignedCharDataRep>;
template class Cloned<MuLawDataRep>;
template class Cloned<ShortDataRep>;
template class Cloned<IntDataRep>;
template class Cloned<FloatDataRep>;
template class Cloned<DoubleDataRep>;
#endif
