// range.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#include "range.h"
#include <values.h>

Range &
Range::limit(double newmin, double newmax) {
	minval = ::max(::min(minval, newmax), newmin);
	maxval = ::min(::max(maxval, newmin), newmax);
	integer = integer && (isInt(minval) && isInt(maxval));
	return *this;
}

Range &
Range::check() {
	if(spread() == 0.0) expandBy(1);
		return *this;
}

Range &
Range::scaleBy(double factor) {
	if(min() == 0.0 || max() == 0.0)
		*this *= factor;
	else
		expandBy(spread() * (factor - 1.0) / 2.0);
	integer = integer && (isInt(minval) && isInt(maxval));
	return *this;
}

const Range AllShorts(-32768, MAXSHORT);
const Range AllIntegers(-(MAXINT), MAXINT);
const Range AllNumbers(double(-(MAXDOUBLE)), double(MAXDOUBLE));
const Range PositiveShorts(1, MAXSHORT);        
const Range PositiveIntegers(1, MAXINT);        
const Range PositiveNumbers(double(MINDOUBLE), double(MAXDOUBLE));
const Range NonNegativeShorts(0, 65535);
const Range NonNegativeIntegers(0, MAXINT);
const Range NonNegativeNumbers(0.0, double(MAXDOUBLE));
const Range NullRange(0, 0);
