// queryvalue.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// This file declares a set of classes used to store and transport parameters
// that are set by the user in the dialog process.  These QueryItem subclasses
// carry string, int, double, or state flags, from the user
// interface objects to the Requester sublass that has "queried" for them.
// QueryValue instances are stored in Request objects, which are created by the
// Requester subclasses.  They are passed to the dialog objects via the 
// DialogConstructor class (see dialog_ctor.h).

#ifndef QUERYVALUE_H
#ifdef __GNUG__
#pragma interface
#endif
#define QUERYVALUE_H

#include "query.h"

// abstract class for all returned value types
// subclasses query string, int, or double values

class QueryValue : public QueryItem {
	typedef QueryItem Super;
public:
	QueryValue(const char *s, CharCheckFun ccf);
	virtual const char* get() const = 0;
	virtual const char* set(const char *);
	operator const char* () const { return get(); }
	redefined QueryType type() { return Value; }
	virtual const Range& range() { return NullRange; }
	boolean checkCharacter(char c) { return (*checkFun)(c); }
protected:
	boolean validString(const char *s) { return (s && strlen(s)); }
	virtual boolean checkAndSet(const char *) = 0;
	virtual const char* errorMessage() { return nil; }
protected:
	CharCheckFun checkFun;
};

class String;

class QueryString : public QueryValue {
	typedef QueryValue Super;
public:
	QueryString(const char *, String *);
	redefined const char* get() const;
protected:
	redefined boolean checkAndSet(const char *);
private:
	String* stringPtr;
};

inline QueryValue* createStringQuery(const char* lbl, String* string) {
	return new QueryString(lbl, string);
}

class QueryNumber : public QueryValue {
	typedef QueryValue Super;
public:
	QueryNumber(const char *lbl, CharCheckFun ccf) : QueryValue(lbl, ccf) {}
protected:
	char tmpbuf[128];
};

#endif
