/*----------------------------------------------------------------
 * glinfo.c -- default settings of midi info record
 *----------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include "config.h"

/* default settings */
MidiInfo gl_default = {
	/* midi info: format, tracks, divisions */
	0, 0, 0,
	/* variable: startcs, endcs, prevcs, curcs */
	0, 0, 0, 0,
	/* variable: updatecs, echocs, prevev, curev, tempo */
	0, 0, 0, 0, 0,
	/* midi data: nlists, list */
	0, NULL,

	/* configuration data */
	/* controls: chorus, reverb, chorusdepth, reverbdepth */
	DEF_CHORUS_MODE, DEF_REVERB_MODE, DEF_CHORUS_DEPTH, DEF_REVERB_DEPTH,
	/* controls: volume, master, bass, treble */
	DEF_VOLUME, 100, DEF_BASS, DEF_TREBLE,
	/* controls: alloff, realpan, multi, checkcs */
	DEF_ALLOFF, DEF_REALTIME_PAN, DEF_MULTIPART, DEF_CHECKCS,
	/* controls: midi_mode, gsmacro, xgmacro, chhprior, do_tuning */
	MODE_GM, DEF_GSMACRO, DEF_XGMACRO, DEF_XGMAP, DEF_CHN_PRIOR, TRUE,
	/* controls: drumflag, tracks */
	DEF_DRUMFLAG, DEF_TRACKS,
	/* controls: volscale, skipblank */
	DEF_VOLSCALE, DEF_SKIPBLANK,
	/* controls: chn_volflag, base_offset, parse_title */
	0, 0, DEF_PARSETITLE,
	/* controls: seq_buffered, use_echoback */
	DEF_SEQ_BUFFERED, DEF_USE_ECHOBACK,
	/* controls: use_effects */
	DEF_USEFX,
	/* effect sense: */
	{
		DEF_FX_CUTOFF, DEF_FX_RESONANCE, DEF_FX_ATTACK, DEF_FX_RELEASE,
		DEF_FX_VIBRATE, DEF_FX_VIBDEPTH, DEF_FX_VIBDELAY
	},
	/* name, dynamicload, xgload, sample_cleared, loaded */
	NULL, NULL, NULL, FALSE, FALSE,
};

void copy_midi_info(MidiInfo *dst, MidiInfo *src, char *fname)
{
	memcpy(dst, src, sizeof(MidiInfo));
	dst->filename = fname;
}

