#!/bin/sh
# 7.11.97 Thomas Niederreiter
#
# This script is called by "make install" to provide a more
# compatible way to install cdrecord.
# Some systems failed to run a makefile that uses wildcards to 
# find out the system-dependent path of the cdrecord-binary.
# This script is a workaround for that.

# get the system-dependent directory name of the built cdrecord
PLATDIR=`ls cdrecord-1.6/cdrecord/OBJ 2>/dev/null`

# how many files/directories are in the OBJ-dir?
MATCHES=`echo $PLATDIR | wc -w`

if [ $MATCHES != 1 ]; then
	echo "The cdrecord-package is not yet compiled or compiled"
	echo "incorrectly. Please don't run this script manually, "
	echo "just follow the installation-instructions."
	exit 1
fi

# move the binary to the libary-directory
mv cdrecord-1.6/cdrecord/OBJ/$PLATDIR/cdrecord ../../lib/bin/cdrecord-1.6

