/*
 *  qftp
 *  Copyright (C) 1997,1998 Peter Strand
 *  Distributed under the GNU Pulic Licence
 */

#include "flist.h"
#include "net.h"

#ifndef _FTPCONN_H_
#define _FTPCONN_H_


class FtpConn {
	Socket *ctrl, *data;
	char cwd[256];
	int cwdch, conn;
	
	int Port();
	int GetReply();
	
	char retmsg[16000];
	int retval;
public:
	
	FtpConn();
	~FtpConn();
	
	char *GetHost();
	char *GetCwd();
	char *GetMsg();
	const char *GetError();
	
	int Connect(char *host);
	void Close();
	int Login(char *user, char *pass);
	int Cmd(char *cmd, char *arg = NULL);
	int Quote(char *s);
	int List(FileList &fl, char *s = NULL);
	int LongList(FileList &fl, char *s = NULL);
	int Cd(char *s = NULL);
	int Size(char *s = NULL);
	int Get(char *s, int fd, void (*cbf)(int) = NULL);
	int Put(char *s, int fd, void (*cbf)(int) = NULL);

};





#endif



