/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  boot.c
 * Purpose: Perform the actual booting process
 * Entries: do_boot
 *
 **************************************************************************
 *
 * Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <general.h>
#include <net.h>
#include <arpa.h>
#include <boot.h>
#include <romlib.h>
#include "./bootpriv.h"
#include "./menu.h"
#include "./load.h"


/*
 **************************************************************************
 * 
 * Print an IP number. Note that the IP address should be in network
 * order.
 */
static void printip(ip)
t_ipaddr ip;
{
  register unsigned char *cp = (unsigned char *)&ip;

  printf("%u.%u.%u.%u", cp[3], cp[2], cp[1], cp[0]);
}



/*
 **************************************************************************
 * 
 * Print some information from the BOOTP answer.
 */
static void printbootp()
{
  printf("\n\nLocal IP:  "); printip(ntohl(boot_rec->bp_yiaddr));
  printf("\nServer IP: "); printip(ntohl(boot_rec->bp_siaddr));
  if (boot_rec->bp_sname[0])
	printf(" (%ls)", boot_rec->bp_sname, sizeof(boot_rec->bp_sname));
  printf("\nFile name: %ls\n\n\n", boot_rec->bp_file,
						sizeof(boot_rec->bp_file));
}



/*
 **************************************************************************
 * 
 * Actually perform the booting process by first calling the BOOTP client,
 * and then loading the operating system using TFTP.
 *
 */
void do_boot()
{
  /*
   * Get BOOTP record from server, also loading an optional extension file.
   */
  if (bootp(FALSE)) {
#ifndef NOMENU
	int status;

	/* Only loop if the menu can be redisplayed */
	while (TRUE) {
		if ((status = domenu()) != MENU_ABORT) {
			printbootp();
			while (load()) {
				bootp(TRUE);
				printbootp();
			}
		}
		if (status != MENU_OK)
			break;
	}
#else
	printbootp();
	while (load()) {
		bootp(TRUE);
		printbootp();
	}
#endif
  }

  /*
   * If the image loader returned, there was an error, so continue with the
   * normal boot process.
   */
  printf("Insert boot disk and press a key\n");
  (void)getkey(0);
}
