/*
    jail 1.04 (jail.h)
    Copyright 1998 Abhijit Menon-Sen <crab@wiw.org>
*/

#include <arpa/inet.h>
#include <fcntl.h>
#include <getopt.h>
#include <linux/icmp.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <netdb.h>
#include <netinet/in.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#ifndef NOFILE
#define NOFILE 1024
#endif

#define MAXLINE 80

/* log levels */
#define IGNORE 0
#define INFORM 6
#define NOTIFY 5
#define WARN 4

#define MAX_ICMP_TYPE 18

#define VERSION 1.04

extern int errno;
int resolve_names=1;

struct icmppkt {
    struct iphdr ip;
    struct icmphdr icmp;
    char buffer[10000];
} p;

/* possible command line options */
static struct option opts[]={ {"file", 1, 0, 0},
                              {"no-resolve", 0, 0, 0},
                              {"version", 0, 0, 0},
                              {0, 0, 0, 0} };

/* description of ICMP packets and corresponding actions */
typedef struct {
    int act;
    char *name;
} i_act;

/* lookup table of actions */
i_act tbl[] = { { NOTIFY, "echo reply"},
                {   WARN, "1?"},
                {   WARN, "2?"},
                { NOTIFY, "destination unreachable"},
                { NOTIFY, "source quench"},
                { NOTIFY, "redirect"},
                {   WARN, "6?"},
                {   WARN, "7?"},
                { NOTIFY, "ping"},
                {   WARN, "9?"},
                {   WARN, "10?"},
                { NOTIFY, "time exceeded"},
                { NOTIFY, "parameter problem"},
                { NOTIFY, "timestamp request"},
                { IGNORE, "timestamp reply"},
                { NOTIFY, "info request"},
                { IGNORE, "info reply"},
                { NOTIFY, "address mask request"},
                { IGNORE, "address mask reply"},
                {   WARN, "undefined" } };

/* keywords in the configuration file */
char *cfg[] = { "echoreply",
                "undef", "undef",
                "dest_unreach",
                "source_quench",
                "redirect",
                "undef", "undef",
                "ping",
                "undef", "undef",
                "time_exceeded",
                "parameterprob",
                "time_request", "time_reply",
                "info_request", "info_reply",
                "addr_request", "addr_reply" };
