/***

othptab.h - header file for the non-TCP routines
Written by Gerard Paul Java
Copyright (c) Gerard Paul Java 1997

***/

#include <malloc.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/ip_icmp.h>
#include <netinet/udp.h>
#include <curses.h>
#include <panel.h>
#include <netdb.h>
#include "if_ether.h"
#include "addproto.h"

#define NONIP -1
#define IS_IP 1
#define NOT_IP 0

#define NOHTIND 0        /* Bottom or Top (head or tail) indicator printed */
#define TIND 1           /* Tail indicator printed */
#define HIND 2		 /* Head indicator printed */

struct othptabent {
    unsigned long int saddr;
    unsigned long int daddr;
    char smacaddr[13];
    char dmacaddr[13];
    unsigned short linkproto;
    char s_fqdn[16];
    char d_fqdn[16];
    int s_fstat;
    int d_fstat;
    unsigned int protocol;
    char iface[12];
  
    union {
	struct {
	    unsigned int sport;
	    unsigned int dport;
	} udp;
	struct {
	    unsigned int type;
	    unsigned int code;
	} icmp;
	struct {
	    unsigned char type;
	    unsigned long area;
	    char routerid[16];
	} ospf;
    } un;
    unsigned int type;
    unsigned int code;
    unsigned int index;
    int is_ip;
    struct othptabent *prev_entry;
    struct othptabent *next_entry;
};

struct othptable {
    struct othptabent *head;
    struct othptabent *tail;
    struct othptabent *firstvisible;
    struct othptabent *lastvisible;
    unsigned int count;
    unsigned int lastpos;
    int htstat;
    WINDOW *othpwin;
    PANEL *othppanel;
    WINDOW *borderwin;
    PANEL *borderpanel;
};

/* partially stolen from ospf.h from tcpdump */

#define	OSPF_TYPE_UMD	0
#define	OSPF_TYPE_HELLO	1
#define	OSPF_TYPE_DB	2
#define	OSPF_TYPE_LSR	3
#define	OSPF_TYPE_LSU	4
#define	OSPF_TYPE_LSA	5
#define	OSPF_TYPE_MAX	6

struct ospfhdr {
    u_char ospf_version;
    u_char ospf_type;
    u_short ospf_len;
    struct in_addr ospf_routerid;
    struct in_addr ospf_areaid;
    u_short ospf_chksum;
    u_short ospf_authtype;
};

void init_othp_table(struct othptable *table);

void process_dest_unreach(struct tcptable *table, char *packet, int *nomem);

struct othptabent *add_othp_entry(struct othptable *table,
				  struct tcptable *tcptab,
				  unsigned long saddr,
				  unsigned long daddr, int is_ip,
				  int protocol, unsigned short linkproto,
				  char *packet, char *ifname,
				  int rev_lookup, unsigned int tm,
				int logging, FILE * logfile, int *nomem);

void printothpentry(struct othptable *table, struct othptabent *entry,
		    unsigned int screen_idx, int logging, FILE * logfile);

void destroyothptable(struct othptable *table);
