/*
 * hostmon.h - definitions used by the Ethernet station monitor
 */
 
struct ethtabent {
    int type;
    union {
	struct {
	    unsigned long inpcount;
	    unsigned long inbcount;
	    unsigned long inippcount;
	    unsigned long inspanbr;
	    unsigned int inpktact;
	    unsigned long outpcount;
	    unsigned long outbcount;
	    unsigned long outippcount;
	    unsigned long outspanbr;
	    unsigned int outpktact;
	    float inrate;
	    float outrate;
	} figs;

	struct {
	    char eth_addr[ETH_ALEN];
	    char ascaddr[13];
	    int printed;
	} desc;
    } un;

    unsigned int index;
    struct ethtabent *prev_entry;
    struct ethtabent *next_entry;
};

struct ethtab {
    struct ethtabent *head;
    struct ethtabent *tail;
    struct ethtabent *firstvisible;
    struct ethtabent *lastvisible;
    unsigned long count;
    unsigned long entcount;
    WINDOW *borderwin;
    PANEL *borderpanel;
    WINDOW *tabwin;
    PANEL *tabpanel;
};
