/*
   Copyright (C) 1996, 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef s_AnimatorP_h
#define s_AnimatorP_h

#include "Animator.h"
/* include superclass private header file */
#include <X11/CoreP.h>

/* define unique representation types not found in <X11/StringDefs.h> */

#define XtRAnimatorResource "AnimatorResource"

typedef struct {
    int empty;
} AnimatorClassPart;

typedef struct s_AnimatorClassRec {
    CoreClassPart	core_class;
    AnimatorClassPart	animator_class;
} AnimatorClassRec;

extern AnimatorClassRec animatorClassRec;

typedef struct {
    /* resources */
	ani_object *cast;
	unsigned long now, delta, duration;
	int newmode;
	char *bg_pixmap;
	char *docdir;
    /* private state */
	int mode;
	XtIntervalId timeout;
	Boolean waiting;
} AnimatorPart;

typedef struct s_AnimatorRec {
    CorePart		core;
    AnimatorPart	animator;
} AnimatorRec;

#endif /* s_AnimatorP_h */
