#include "defs.h"
#include "elmlib.h"

char * strmcpy (dest, src)
     char *dest;
     const char *src;
{
	int len = strlen (src) + 1;

	if (dest)
		dest = (char *) safe_realloc (dest, len);
	else
		dest = (char *) safe_malloc (len);
	strfcpy (dest, src, len);
	return dest;
}


char * strmcat (dest, src)
     char *dest;
     const char *src;
{
	int len;

	if (!dest)
	  return strmcpy(dest,src);

	len = strlen (src) + 1 + strlen(dest);

	dest = (char *) safe_realloc (dest, len);
	strfcat (dest, src, len);
	return dest;
}
