
/*
 
The following code shows a bug in the Radio Button code.
The bug is that toggle buttons in a radio box get incorrect 
callbacks.
 
The following program demonstrates the problem.
 
---------------------+-------------------+-----------------
Action               | Correct Behavior  | lesstif 971005
---------------------+-------------------+-----------------
Start Program.       |                   |
---------------------+-------------------+-----------------
User Presses Button2 | "Button 1 clear"  | "Button 2 set"
                     | "Button 2 set"    |
---------------------+-------------------+-----------------
User presses Button2 | "Button 2 set"    | "Button 2 clear"
   again.            | "Button 2 set"    |
---------------------+-------------------+-----------------
 
Note that the radio button is painted correctly (it looks
pressed in or pressed out when it is supposed to be.)  It
is only the callbacks that get called incorrectly.
 
 
Keep up the great work with lesstif!
 
-Paul
 
paul.wilkins@analog.com
 
*/
 
 
 
#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleBG.h>
 
/* The tuggle buttons callback */
void toggle_cb(Widget, XtPointer, XtPointer);
 
 
main(int argc, char *argv[]){
 
   XtAppContext app;
   Widget toplevel;
   Widget radio_box, w;
 
   toplevel = XtVaAppInitialize(&app, "bug", NULL, 0,
       &argc, argv, NULL,
       NULL);
 
 
   radio_box = XmCreateRadioBox(toplevel, "rbox", NULL, 0);
 
   /* create button 1 */
   w = XtVaCreateManagedWidget("button1",
      xmToggleButtonGadgetClass, radio_box,
      XmNset, True,
      NULL);
   XtAddCallback(w,
      XmNvalueChangedCallback, toggle_cb,
      (XtPointer)1);
 
 
   /* create button 2 */
   w = XtVaCreateManagedWidget("button2",
      xmToggleButtonGadgetClass, radio_box,
      XmNset, False,
      NULL);
   XtAddCallback(w,
      XmNvalueChangedCallback, toggle_cb,
      (XtPointer)2);
 
   XtManageChild(radio_box);
   XtRealizeWidget(toplevel);
   XtAppMainLoop(app);
 
}
 
void toggle_cb(Widget w, XtPointer client_data, XtPointer call_data){
   XmToggleButtonCallbackStruct *state =
      (XmToggleButtonCallbackStruct *) call_data;
 
   fprintf(stderr, "Button %d ", (int)client_data);
 
   if(state->set){
      fprintf(stderr, "set\n");
   } else {
      fprintf(stderr, "clear\n");
   }
}



