'\" Copyright 1991-1997 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
'\" Hypertext widget created by George Howlett.
'\"
.so man.macros
.HS htext BLT
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
htext \- Create and manipulate hypertext widgets
.SH SYNOPSIS
\fBhtext\fP \fIpathName \fR?\fIoption value\fR?...
.BE
.SH DESCRIPTION
.PP
The \fBhtext\fR command creates a new window (given by the 
\fIpathName\fR argument) and makes it into a \fBhtext\fP widget.
Additional options, described above, may be specified on the command line
or in the option database to configure aspects of the widget such as its 
color and font.  At the time this command is invoked, there must not 
exist a window named \fIpathName\fR, but \fIpathName\fR's parent must exist.
The \fBhtext\fR command returns its \fIpathName\fR.   
.PP
The \fBhtext\fP widget is hybrid of a non-editable text widget and
a geometry manager (e.g. the packer).  It displays text (optionally read
from file) in a window.  Text can be scrolled either horizontally or
vertically using the \fBhtext\fR window as a viewport.
In addition, Tcl commands can be embedded into 
the text which are evaluated as the text is parsed.  Text between special
double characters (percent signs "%%") is immediately passed to the Tcl 
interpreter for evaluation.  
.PP
Furthermore, any widget or widget hierarchy can be packed in-line and made 
to appear on the current line of the text.  Widgets are packed using the 
\fBhtext append\fP command.  All widgets must be children of the 
\fBhtext\fP window and must already exist before packing. 
Once a widget has been packed it cannot be moved to a different
position within the text.  Widgets can be resized but they will remain 
at the same position within the text.
.PP
Before a file or text string is parsed by the \fBhtext\fR widget,
all the widget's current children are destroyed.  You can reload files or text 
without worrying about unmapping or destroying each child window beforehand.
.PP
Setting the either the \fB\-filename\fR or \fB\-text\fR configuration option 
will adjust the value of the other.  If both options are set, the file 
takes precedence.  When a new file is read using the \fB\-filename\fR option,
the value of the \fB\-text\fR option is reset to the empty string.  Likewise, 
when the \fB\-text\fR option is set, the string representing the 
\fB\-filename\fR option is cleared.
.SH FILE FORMAT
The format of \fBhtext\fP text file is typically ASCII text.  
Text enclosed by special double characters (by default, percent signs '%%') 
is interpreted and executed as Tcl commands.  
The special character  may be specified by the \fB\-specialchar\fP option. 
In the following example of a \fBhtext\fP file,  a button widget 
is appended to the text between  the words "\fCa\fP" and "\fCwhich\fP".  
The \fIpathName\fR of the \fBhtext\fP widget is "\fC.ht\fP".
.DS L
\fCThis will be displayed as normal text. 
But this will become a %% 
  button .ht.button -text "button" -fg red
  .ht append .ht.button 
%% which can invoke a Tcl command.\fR
.DE
.LP
.SH INDICES
.PP
Some of the widget operations (\fBselection\fR, \fRgotoline\fR, 
\fBsearch\fR, etc.) take one or more indices as arguments.
An index is a string used to indicate a particular place within
the text, such as the first and last characters in a range to be
selected. 
.LP
An index must have one of the following forms:
.TP 12
\fIline\fB.\fIchar\fR
Indicates \fIchar\fR'th character on line \fIline\fR.
Both lines and characters are number from 0, so "0.0" is the
first beginning of the text.  \fIChar\fR may be undesignated.  In
this case a character position of 0 is assumed.
.TP 12
\fB@\fIx\fB,\fIy\fR
Indicates the character that covers the pixel whose x and y coordinates
within the text's window are \fIx\fR and \fIy\fR.
.TP 12
\fBend\fR
Indicates the end of the text.
.TP 12
\fBanchor\fR
Indicates the anchor point for the selection, which is set with the
\fBselection\fR operation.
.TP 12
\fBsel.first\fR
Indicates the first character in the selection.  It is an error to
use this form if the selection isn't in the entry window.
.TP 12
\fBsel.last\fR
.VS
Indicates the character just after the last one in the selection.
.VE
It is an error to use this form if the selection isn't in the
entry window.
.SH "VARIABLES"
.PP
The following global Tcl variables are maintained when an 
\fBhtext\fR file is parsed.  
.TP
\fBhtext(widget)\fR 
is the pathname of the \fBhtext\fP widget.
.TP
\fBhtext(file)\fR 
is the name of the file the \fBhtext\fP widget is currently parsing.  
It is the empty string when the \fB\-text\fP option is used.
.TP
\fBhtext(line)\fR 
is the current line number in the text.  
.PP
This information might be used to construct hyper links 
between different files and/or lines.
.LP
.SH "SYNTAX"
The \fBhtext\fP command creates a new Tcl command whose
name is \fIpathName\fR.  This command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName oper \fR?\fIargs\fR?
.DE
\fIOper\fR and \fIargs\fR determine the exact behavior of the command.
.PP
.SH "OPERATIONS"
The following operations are available for \fBhtext\fP widgets:
.TP
\fIpathName \fBappend \fIwindow \fR?\fIoption value\fR?...  
Embeds the widget \fIwindow\fP into the htext widget.  \fIWindow\fP is
the pathname of the widget to be embedded which must be a child of
\fIpathName\fR.  \fIWindow\fR will be positioned in the htext widget
at the current location of the text. If \fIoption\fR and \fIvalue\fR
pairs are present, they configure various aspects how \fIwindow\fR
appears in \fIpathName\fR.  The following options are available.
.RS
.TP
\fB\-anchor \fIanchorPos\fR
Specifies how \fIwindow\fR will be arranged if there is any extra
space in the cavity surrounding the window.  For example, if
\fIanchorPos\fR is \fBcenter\fR then the window is centered in the
cavity; if \fIanchorPos\fR is \fBw\fR then the window will be drawn
such it touches the leftmost edge of the cavity. The default
is \fCcenter\fR.
.TP
\fB\-fill \fIstyle\fR
Specifies how the \fIwindow\fR should be stretched to occupy the extra
space in the cavity surrounding it (if any exists).  \fIStyle\fR is
\fCnone\fR, \fCx\fR, \fCy\fR, \fCboth\fR.  If \fIstyle\fR is \fCx\fR,
the width of \fIwindow\fR is expanded to fill the cavity.  If
\fIstyle\fR is \fBy\fR, the height is expanded.  The default is
\fCnone\fR.
.TP
\fB\-height \fIpixels\fR
Sets the height of the cavity surrounding \fIwindow\fR.  If
\fIpixels\fP is zero, the height of the cavity will be the same as the
requested height of \fIwindow\fR.  If \fIpixels\fR is less than the 
requested height of \fIwindow\fR, \fIwindow\fR will be reduced to fit
the cavity.  The default is \fC0\fR.
.TP
\fB\-ipadx \fIpad\fR
Sets the amount of internal padding to be added to the width
\fIwindow\fR.  \fIPad\fR can be a list of one or two numbers.  If
\fIpad\fR has two elements, the left side of \fIwindow\fR is extended
by the first value and the right side by the second value.  If
\fIpad\fR is just one value, both the left and right sides are padded
by evenly by the value.  The default is \fC0\fR.
.TP
\fB\-ipady \fIpad\fR
Sets an amount of internal padding to be added to the height of
\fIwindow\fR.  \fIPad\fR can be a list of one or two numbers.  If
\fIpad\fR has two elements, the top of \fIwindow\fR is padded by the
first value and the bottom by the second value.  If \fIpad\fR is just
one number, both the top and bottom are padded evenly by the value.
The default is \fC0\fR.
.TP
\fB\-justify \fIjustify\fR
Justifies \fIwindow\fR vertically within the cavity containing it
in relation to the line of text. \fIJustify\fR is \fBtop\fP, 
\fBbottom\fR, or  \fBcenter\fR.  If \fIjustify\fR is \fCcenter\fR the
widget is centered along the baseline of the line of text.  The 
default is \fCcenter\fR.
.TP
\fB\-padx \fIpad\fR
Sets the padding on the left and right sides of \fIwindow\fR.
\fIPad\fR can be a list of one or two numbers.  If \fIpad\fR has two
elements, the left side of \fIwindow\fR is padded by the first value
and the right side by the second value.  If \fIpad\fR has just one
value, both the left and right sides are padded evenly by the value.
The default is \fC0\fR.
.TP
\fB\-pady \fIpad\fR
Sets the padding above and below \fIwindow\fR.  \fIPad\fR can be a
list of one or two numbers.  If \fIpad\fR has two elements, the area
above \fIwindow\fR is padded by the first value and the area below by
the second value.  If \fIpad\fR is just one number, both the top and
bottom are padded by the value.  The default is \fC0\fR.
.TP
\fB\-relheight \fIvalue\fR
Specifies the height of the cavity containing \fIwindow\fR relative to 
the height of \fIpathName\fR.  \fIValue\fP is real number indicating
the ratio of the height of the cavity to the height of \fIpathName\fR.  
As the height of \fIpathName\fR changes, so will the height of \fIwindow\fR.
If \fIvalue\fR is 0.0 or less, the height of the cavity is the requested 
height \fIwindow\fR.  The default is \fC0.0\fR.
.TP
\fB\-relwidth \fIvalue\fR
Specifies the width of the cavity containing \fIwindow\fR relative to
the width of \fIpathName\fR.  \fIValue\fP is real number indicating
the ratio of the width of the cavity to the width of \IpathName\fR.
As the height of \fIpathName\fR changes, so will the height of \fIwindow\fR.
If \fIvalue\fR is 0.0 or less, the width of the cavity is the
requested width of \fIwindow\fR.   The default is \fC0.0\fR.
.TP
\fB\-width \fIvalue\fR
Species the width of the cavity containing the child window.  
\fIValue\fP must be in a form accepted by \fBTk_GetPixels\fR.
If \fIvalue\fP is greater than zero, the cavity is resized to that width.  
If the requested window width is greater than the cavity's width, the
window will be reduced to fit the cavity.
By default, the cavity is requested width of the child window. 
.RE
.TP
\fIpathName \fBconfigure\fR ?\fIwindow\fR? ?\fIoption\fR? ?\fIvalue option value ...\fR?
Queries or modifies the configuration options of the text widget or one 
of its embedded widgets.  If no \fIwindow\fR argument is present, 
the htext widget itself is configured.  Otherwise \fIwindow\fR
is the pathname of a widget already embedded into the htext widget.
Then this command configure the options for the embedded widget.
.PP
If \fIoption\fR isn't specified, a list describing all of the current
options for \fIpathName\fR or \fIwindow\fR is returned.  If
\fIoption\fR is specified, but not \fIvalue\fR, then a list describing
the option \fIoption\fR is returned.  If one or more \fIoption\fR and
\fIvalue\fR pairs are specified, then for each pair, the htext or embedded 
window option \fIoption\fR is set to \fIvalue\fR.
.PP
The following options are valid for the htext widget.
.RS
.TP
\fB\-background\fR \fIcolor\fI
Sets the background of the htext widget to \fIcolor\fR.  This default is
\fCwhite\fR.
.TP
\fB\-cursor\fR \fIcursor\fR
Specifies the cursor for the htext widget.  The default cursor is 
\fCpencil\fR.
.TP
\fB\-filename\fR \fIfileName\fR
Specifies a \fBhtext\fP file to be displayed in the window. 
If the value is the empty string, the \fB\-text\fR option is used instead.
See the section 
.SB FILE FORMAT
for a description of the \fBhtext\fP 
file format.
.TP
\fB\-font\fR \fIfontName\fR 
Sets the font of the text in the htext widget to \fIfontName\fR. The
default is \fC*-Helvetica-Bold-R-Normal-*-12-120-*\fR.
.TP
\fB\-foreground\fR \fIcolor\fR
Sets the foreground of the htext widget to \fIcolor\fR.  This is
the color of the text.  This default is \fCblack\fR.
.TP
\fB\-height\fR \fIpixels\fR
Specifies the height of the htext widget window. 
.TP
\fB\-linespacing\fR \fIpixels\fR
Specifies the spacing between each line of text.  The value must be in
a form accepted by \fBTk_GetPixels\fR. The default value is 1 pixel.
.TP
\fB\-specialchar\fR \fInumber\fR
Specifies the ASCII value of the special double character delimiters.
In \fBhtext\fP files, the text between these special characters is 
evaluated as a block of Tcl commands. The default special character 
is the \fC0x25\fR  (percent sign).
.TP
\fB\-text\fR \fItext\fR
Specifies the text to be displayed in the htext widget.  \fIText\fR
can be any valid string of characters. See
.SB "FILE FORMAT"
for a description.
.TP
\fB\-xscrollcommand\fR \fIstring\fR 
Specifies the prefix for a command used to communicate with horizontal
scrollbars.  When the view in the htext widget's window changes (or
whenever anything else occurs that could change the display in a
scrollbar, such as a change in the total size of the widget's
contents), the widget invoke \fIstring\fR concatenated by two numbers.
Each of the numbers is a fraction between 0 and 1, which indicates a
position in the document.  If this option is not specified, then no
command will be executed.
.TP
\fB\-yscrollcommand\fR \fIstring\fR
Specifies the prefix for a command used to communicate with vertical
scrollbars.  When the view in the htext widget's window changes (or
whenever anything else occurs that could change the display in a
scrollbar, such as a change in the total size of the widget's
contents), the widget invoke \fIstring\fR concatenated by two numbers.
Each of the numbers is a fraction between 0 and 1, which indicates a
position in the document.  If this option is not specified, then no
command will be executed.
.TP
\fB\-width\fR \fIpixels\fR
Specifies the desired width of the viewport window.  If the
\fIpixels\fR is less than one, the window will grow to accommodate the
widest line of text.  
.TP
\fB\-xscrollunits\fR \fIpixels\fR
Specifies the horizontal scrolling distance. The default is 10 pixels.
.TP
\fB\-yscrollunits\fR \fIpixels\fR
Specifies the vertical scrolling distance. The default is 10 pixels.
.RE
.TP
\fIpathName \fBgotoline \fR?\fIindex\fR?
Sets the top line of the text to \fIindex\fP. \fIIndex\fP must be
a valid text index (the character offset is ignored).  
If an \fIindex\fP isn't provided, the current line number is 
returned.
.TP
\fIpathName \fBscan mark \fIposition\fR
Records \fIposition\fR and the current view in the text window;  used in
conjunction with later \fBscan dragto\fR commands.  \fIPosition\fR must 
be in the form "\fI@x,y\fR, where \fIx\fR and \fIy\fR are window coordinates.
Typically this
command is associated with a mouse button press in the widget.  It
returns an empty string.
.TP
\fIpathName \fBscan dragto \fIposition\fR
Computes the difference between \fIposition\fR and the position registered
in the last \fBscan mark\fR command for the widget.  
The view is then adjusted
up or down by 10 times the difference in coordinates.  This command is 
can be associated with mouse motion events to produce the effect of
dragging the text at high speed through the window.  
\fIPosition\fR must be in the form "\fI@x,y\fR, where \fIx\fR and 
\fIy\fR are window coordinates. The command returns an empty string.
.TP
\fIpathName \fBsearch \fIpattern\fR ?\fIfrom\fR? ?\fIto\fR?
Returns the number of the next line matching \fIpattern\fR.  \fIPattern\fR is
a string which obeys the matching rules of \fBTcl_StringMatch\fR. 
\fIFrom\fR and \fIto\fR are text line numbers (inclusive) which 
bound the search.  
If no match for \fIpattern\fR can be found, \fB-1\fR is returned.
.TP
\fIpathName \fBxview \fR?\fIposition\fR?
Moves the viewport horizontally to the new text x-coordinate position.  
\fIPosition\fR is the offset from the left side of the text to the current 
position and must be in a form accepted by \fBTk_GetPixels\fR. If \fIposition\fR
is not present, the current text position is returned.
.TP
\fIpathName \fByview \fR?\fIposition\fR?
Moves the viewport vertically to the new text y-coordinate position.  
\fIPosition\fR is the offset from the top of the text to the current 
position and must be in a form accepted by \fBTk_GetPixels\fR. If \fIposition\fR
is not present, the current text position is returned.
.SH BUGS
Text with embedded tabs can be obscured by child windows when scrolled 
horizontally.
.SH KEYWORDS
hypertext, widget
