GdkFont *gdk_font_load(char *font_name);
GdkFont *gdk_fontset_load(char *fontset);
%{
static PyObject *gdk__pixmap_new(PyObject *self, PyObject *args) {
  GdkPixmap *pix;
  PyObject *win, *ret;
  int w, h, d;
  if (!PyArg_ParseTuple(args, "O!iii:gdk_pixmap_new", &PyGdkWindow_Type, &win,
		       &w, &h, &d))
    return NULL;
  pix = gdk_pixmap_new(PyGdkWindow_Get(win), w, h, d);
  ret = PyGdkWindow_New(pix, "GdkPixmap");
  gdk_pixmap_unref(pix);
  return ret;
}
static PyObject *gdk__pixmap_create_from_xpm(PyObject *self, PyObject *args) {
  GdkPixmap *pix;
  GdkBitmap *mask;
  PyObject *parent_win, *colour, *ret;
  GdkColor *col;
  gchar *fname;

  if (!PyArg_ParseTuple(args, "O!Os:gdk_pixmap_create_from_xpm",
			&PyGdkWindow_Type, &parent_win, &colour, &fname))
    return NULL;
  if (colour == Py_None)             col = NULL;
  else if (PyGdkColor_Check(colour)) col = PyGdkColor_Get(colour);
  else {
    PyErr_SetString(PyExc_TypeError,
		    "second argument must be a colour or None");
    return NULL;
  }
  pix = gdk_pixmap_create_from_xpm(PyGdkWindow_Get(parent_win), &mask, col,
				   fname);
  if (pix == NULL) {
    PyErr_SetString(PyExc_IOError, "can't load pixmap");
    return NULL;
  }
  ret =  Py_BuildValue("(OO)", PyGdkWindow_New(pix, "GdkPixmap"),
		       PyGdkWindow_New(mask, "GdkBitmap"));
  gdk_pixmap_unref(pix);
  gdk_bitmap_unref(mask);
  return ret;
}
%}
%native(gdk_pixmap_new) PyObject *gdk__pixmap_new(PyObject *s, PyObject *args);
%native(gdk_pixmap_create_from_xpm) PyObject *gdk__pixmap_create_from_xpm(
					PyObject *self, PyObject *args);
void gdk_draw_point(GdkWindow *win, GdkGC *gc, int x, int y);
void gdk_draw_line(GdkWindow *win, GdkGC *gc, int x1, int y1, int x2, int y2);
void gdk_draw_rectangle(GdkWindow *win, GdkGC *gc, int filled, int x1, int y1,
		   int x2, int y2);
void gdk_draw_arc(GdkWindow *win, GdkGC *gc, int filled, int x, int y,
		  int width, int height, int angle1, int angle2);
//void gdk_draw_bitmap(GdkWindow *win, GdkGC *gc, GdkWindow *src, int xsrc,
//		     int ysrc, int xdest, int ydest, int width, int height);
void gdk_draw_pixmap(GdkWindow *win, GdkGC *gc, GdkWindow *src, int xsrc,
		     int ysrc, int xdest, int ydest, int width, int height);

%{
static PyObject *gdk__draw_polygon(PyObject *self, PyObject *args) {
  PyObject *win, *gc, *seq, *item;
  gint filled, npoints, i;
  GdkPoint *points;

  if (!PyArg_ParseTuple(args, "O!O!iO:gdk_draw_polygon", &PyGdkWindow_Type,
			&win, &PyGdkGC_Type, &gc, &filled, &seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "forth argument not a sequence");
    return NULL;
  }
  npoints = PySequence_Length(seq);
  points = g_new(GdkPoint, npoints);
  for (i = 0; i < npoints; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyArg_ParseTuple(item, "hh", &(points[i].x), &(points[i].y))) {
      PyErr_Clear();
      PyErr_SetString(PyExc_TypeError, "sequence member not a 2-tuple");
      g_free(points);
      return NULL;
    }
  }
  gdk_draw_polygon(PyGdkWindow_Get(win),PyGdkGC_Get(gc),filled,points,npoints);
  g_free(points);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gdk__draw_text(PyObject *self, PyObject *args) {
  PyObject *win, *font, *gc;
  int x, y, len;
  char *str;
  if (!PyArg_ParseTuple(args, "O!O!O!iis#:gdk_draw_text", &PyGdkWindow_Type,
			&win, &PyGdkFont_Type, &font, &PyGdkGC_Type, &gc,
			&x, &y, &str, &len))
    return NULL;
  gdk_draw_text(PyGdkWindow_Get(win), PyGdkFont_Get(font), PyGdkGC_Get(gc),
		x, y, str, len);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gdk__draw_points(PyObject *self, PyObject *args) {
  PyObject *win, *gc, *seq, *item;
  gint npoints, i;
  GdkPoint *points;

  if (!PyArg_ParseTuple(args, "O!O!O:gdk_draw_points", &PyGdkWindow_Type,
			&win, &PyGdkGC_Type, &gc, &seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "third argument not a sequence");
    return NULL;
  }
  npoints = PySequence_Length(seq);
  points = g_new(GdkPoint, npoints);
  for (i = 0; i < npoints; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyArg_ParseTuple(item, "hh", &(points[i].x), &(points[i].y))) {
      PyErr_Clear();
      PyErr_SetString(PyExc_TypeError, "sequence member not a 2-tuple");
      g_free(points);
      return NULL;
    }
  }
  gdk_draw_points(PyGdkWindow_Get(win), PyGdkGC_Get(gc), points, npoints);
  g_free(points);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gdk__draw_segments(PyObject *self, PyObject *args) {
  PyObject *win, *gc, *seq, *item;
  gint nsegs, i;
  GdkSegment *segs;

  if (!PyArg_ParseTuple(args, "O!O!O:gdk_draw_segments", &PyGdkWindow_Type,
			&win, &PyGdkGC_Type, &gc, &seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "third argument not a sequence");
    return NULL;
  }
  nsegs = PySequence_Length(seq);
  segs = g_new(GdkSegment, nsegs);
  for (i = 0; i < nsegs; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyArg_ParseTuple(item, "hhhh", &(segs[i].x1), &(segs[i].y1),
			  &(segs[i].x2), &(segs[i].y2))) {
      PyErr_Clear();
      PyErr_SetString(PyExc_TypeError, "sequence member not a 4-tuple");
      g_free(segs);
      return NULL;
    }
  }
  gdk_draw_segments(PyGdkWindow_Get(win), PyGdkGC_Get(gc), segs, nsegs);
  g_free(segs);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gdk__draw_lines(PyObject *self, PyObject *args) {
  PyObject *win, *gc, *seq, *item;
  gint npoints, i;
  GdkPoint *points;

  if (!PyArg_ParseTuple(args, "O!O!O:gdk_draw_lines", &PyGdkWindow_Type,
			&win, &PyGdkGC_Type, &gc, &seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "third argument not a sequence");
    return NULL;
  }
  npoints = PySequence_Length(seq);
  points = g_new(GdkPoint, npoints);
  for (i = 0; i < npoints; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyArg_ParseTuple(item, "hh", &(points[i].x), &(points[i].y))) {
      PyErr_Clear();
      PyErr_SetString(PyExc_TypeError, "sequence member not a 2-tuple");
      g_free(points);
      return NULL;
    }
  }
  gdk_draw_lines(PyGdkWindow_Get(win), PyGdkGC_Get(gc), points, npoints);
  g_free(points);
  Py_INCREF(Py_None);
  return Py_None;
}
%}
%native(gdk_draw_polygon) PyObject *gdk__draw_polygon(PyObject *self,
						      PyObject *args);
%native(gdk_draw_string) PyObject *gdk__draw_text(PyObject *self,
						  PyObject *args);
%native(gdk_draw_text) PyObject *gdk__draw_text(PyObject *self,
						PyObject *args);
%native(gdk_draw_points) PyObject *gdk__draw_points(PyObject *self,
						    PyObject *args);
%native(gdk_draw_segments) PyObject *gdk__draw_segments(PyObject *self,
							PyObject *args);
%native(gdk_draw_lines) PyObject *gdk__draw_lines(PyObject *self,
						  PyObject *args);

%{
/* gdk_color_alloc analog */
static PyObject *
gdk__color_alloc(PyObject *self, PyObject *args) {
    GdkColor gdk_color;
    GdkColormap *colormap;
    PyGtkStyle_Object *style;
    PyGtk_Object *obj;
    if (PyArg_ParseTuple(args, "O!iii:gdk_color_alloc", &PyGtkStyle_Type,
			 &style, &(gdk_color.red), &(gdk_color.green),
			 &(gdk_color.blue)))
        colormap = PyGtkStyle_Get(style)->colormap;
    else {
        PyErr_Clear();
	if (!PyArg_ParseTuple(args, "O!iii:gdk_color_alloc", &PyGtk_Type,
			      &obj, &(gdk_color.red), &(gdk_color.green),
			      &(gdk_color.blue)))
	    return NULL;
	if (GTK_WIDGET_NO_WINDOW(PyGtk_Get(obj))) {
	    PyErr_SetString(PyExc_TypeError, "widget has no window");
	    return NULL;
	}
	colormap = gdk_window_get_colormap(GTK_WIDGET(PyGtk_Get(obj))->window);
    }
    gdk_color_alloc(colormap, &gdk_color);
    return PyGdkColor_New(&gdk_color);
}
%}
%native(gdk_color_alloc) PyObject *gdk__color_alloc(PyObject *s, PyObject *a);

