/*****************************************************************************/

/*
 *	xfhdlcst.c  -- kernel hdlc radio modem driver status display utility.
 *
 *	Copyright (C) 1996  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Please note that the GPL allows you to use the driver, NOT the radio.
 *  In order to use the radio, you need a license from the communications
 *  authority of your country.
 *
 *
 * History:
 *   0.1  14.12.96  Started
 *   0.2  11.05.97  introduced hdrvcomm.h
 */

/*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <linux/if.h>
#include <forms.h>
#include "hdrvcomm.h"
#include "xfhdlcst.h"

/* ---------------------------------------------------------------------- */

static char *progname;

/* ---------------------------------------------------------------------- */

void cb_quit(FL_OBJECT *ob, long data)
{
	exit(0);
}

/* ---------------------------------------------------------------------- */

static const char *usage_str = 
"[-i smif]\n"
"  -i: specify the name of the baycom kernel driver interface\n\n";

/* ---------------------------------------------------------------------- */

int main(int argc, char *argv[])
{
	FD_hdlcst *fd_hdlcst;
	FL_OBJECT *obj;
	int ret;
	struct hdrvc_channel_state cs;
#ifdef HDRVC_KERNEL
	struct sm_ioctl smi;
#endif /* HDRVC_KERNEL */
	char buf[32];
	char name[64];

	progname = *argv;
	printf("%s: Version 0.2; (C) 1996-1997 by Thomas Sailer HB9JNX/AE4WA\n", *argv);
	fl_initialize(&argc, argv, 0, 0, 0);
	hdrvc_args(&argc, argv, "bc0");
	while ((ret = getopt(argc, argv, "")) != -1) {
		switch (ret) {
		default:
			printf("usage: %s %s", *argv, usage_str);
			exit(-1);
		}
	}
	hdrvc_init();

	fd_hdlcst = create_form_hdlcst();
	fl_set_timer(fd_hdlcst->timer, 0.1);
	/*
	 * set driver and modem name
	 */
	ret = hdrvc_get_mode_name(name, sizeof(name));
	if (ret < 0) {
		perror("hdrvc_get_mode_name");
		fl_hide_object(fd_hdlcst->modename);
	} else 
		fl_set_object_label(fd_hdlcst->modename, name);
	ret = hdrvc_get_driver_name(name, sizeof(name));
	if (ret < 0) {
		perror("hdrvc_get_driver_name");
		fl_hide_object(fd_hdlcst->drivername);
	} else 
		fl_set_object_label(fd_hdlcst->drivername, name);
	/*
	 * check for soundmodem driver
	 */
#ifdef HDRVC_KERNEL
	ret = hdrvc_sm_ioctl(SMCTL_GETDEBUG, &smi);
	if (ret < 0) {
#endif /* HDRVC_KERNEL */
		fl_hide_object(fd_hdlcst->tdemodcyc);
		fl_hide_object(fd_hdlcst->tmodcyc);
		fl_hide_object(fd_hdlcst->tintfreq);
		fl_hide_object(fd_hdlcst->tdmares);
		fl_hide_object(fd_hdlcst->demodcyc);
		fl_hide_object(fd_hdlcst->modcyc);
		fl_hide_object(fd_hdlcst->intfreq);
		fl_hide_object(fd_hdlcst->dmares);
#ifdef HDRVC_KERNEL
	}
#endif /* HDRVC_KERNEL */
	fl_show_form(fd_hdlcst->hdlcst, FL_PLACE_CENTER, FL_FULLBORDER, "HDLC driver state");
	while ((obj = fl_do_forms())) {
		fl_freeze_form(fd_hdlcst->hdlcst);
		if (obj == fd_hdlcst->timer)
			fl_set_timer(fd_hdlcst->timer, 0.5);
		/*
		 * display state
		 */
		ret = hdrvc_get_channel_state(&cs);
		if (ret >= 0) {
			fl_set_button(fd_hdlcst->ptt, cs.ptt);
			fl_set_button(fd_hdlcst->dcd, cs.dcd);
			sprintf(buf, "%ld", cs.tx_packets);
			fl_set_object_label(fd_hdlcst->txpacket, buf);
			sprintf(buf, "%ld", cs.tx_errors);
			fl_set_object_label(fd_hdlcst->txerror, buf);
			sprintf(buf, "%ld", cs.rx_packets);
			fl_set_object_label(fd_hdlcst->rxpacket, buf);
			sprintf(buf, "%ld", cs.rx_errors);
			fl_set_object_label(fd_hdlcst->rxerror, buf);
		}
		ret = hdrvc_sm_ioctl(SMCTL_GETDEBUG, &smi);
		if (ret >= 0) {
			sprintf(buf, "%d", smi.data.dbg.int_rate);
			fl_set_object_label(fd_hdlcst->intfreq, buf);
			sprintf(buf, "%d", smi.data.dbg.mod_cycles);
			fl_set_object_label(fd_hdlcst->modcyc, buf);
			sprintf(buf, "%d", smi.data.dbg.demod_cycles);
			fl_set_object_label(fd_hdlcst->demodcyc, buf);
			sprintf(buf, "%d", smi.data.dbg.dma_residue);
			fl_set_object_label(fd_hdlcst->dmares, buf);
		} 
		fl_unfreeze_form(fd_hdlcst->hdlcst);
	}
	exit (0);
}
