/* XQF - Quake server browser and launcher
 * Copyright (C) 1998 Roman Pozlevich <roma@botik.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdio.h>	/* fprintf, sprintf */
#include <string.h>	/* strcmp, strchr, strncpy */
#include <gtk/gtk.h>

#include "xqf.h"
#include "server.h"


/*
 *  Stupid flat implementation...
 */


static GList *global_server_list = NULL;


static void server_add (struct server *s) {
  global_server_list = g_list_prepend (global_server_list, (gpointer) s);
}


static void server_remove (struct server *s) {
  global_server_list = g_list_remove (global_server_list, (gpointer) s);
}


struct server *server_lookup (char *address, int port) {
  GList *ptr = global_server_list;
  struct server *s;

  while (ptr) {
    s = (struct server *) (ptr->data);
    if (s->port == port && strcmp (s->address, address) == 0)
      return s;
    ptr = ptr->next;
  }

  return NULL;
}


struct server *server_new (char *address, int port, enum server_type type) {
  struct server *s;

  s = g_malloc (sizeof (struct server));
  s->address = g_strdup (address);

  if (port == -1)
    s->port = (type == Q2_SERVER)? Q2_DEFAULT_PORT : QW_DEFAULT_PORT;
  else
    s->port = port;

  s->type = type;
  s->name = NULL;
  s->players = NULL;
  s->info = NULL;
  s->game = NULL;
  s->map  = NULL;
  s->maxplayers = 0;
  s->curplayers = 0;
  s->ping = -1;
  s->retries = -1;
  s->flags = 0;

  s->ref_count = 0;

  server_add (s);
  return s;
}


void server_unref (struct server *s) {
  if (s->ref_count <= 0) {
    fprintf (stderr, "server_unref(): object reference counter is %d\n", 
                                                                 s->ref_count);
    return;
  }

  s->ref_count--;

  if (s->ref_count == 0) {
    server_remove (s);

    if (s->address) g_free (s->address);
    if (s->name) g_free (s->name);
    if (s->map) g_free (s->map);

    if (s->players) g_free (s->players);
    if (s->info) g_free (s->info);

    g_free (s);
  }
}


int check_global_list (void) {
  fprintf (stderr, "total servers: %d\n", g_list_length (global_server_list));
}


GSList *all_servers (void) {
  GSList *list = NULL;
  GList *tmp;

  for (tmp = global_server_list; tmp; tmp = tmp->next) {
    list = g_slist_prepend (list, tmp->data);
    ((struct server *) tmp->data) -> ref_count++;
  }

  return list;
}


#if 0
char *server_port (char *s, unsigned port) {
  char *ptr;
  int slen;

  if (!s)
    return;

  if (port > 64*1024)
    return s;

  if (strchr (s, ':') == NULL) {
    slen = strlen (s);
    s = g_realloc (s, slen + 1 + 6);
    sprintf (s + slen, ":%d", port);
  }

  return s;
}
#endif


int parse_address (char *str, char **addr, int *port) {
  char *ptr;
  int size;

  if(!str)
    return -1;

  ptr = strchr (str, ':');
  if (!ptr) {
    *port = -1;
    *addr = g_strdup (str);
    return TRUE;
  }

  *port = strtol (ptr + 1, NULL, 10);
  if ((ptr == str) || (*port <= 0 || *port >= 64*1024)) {
    *port = -1;
    *addr = NULL;
    return FALSE;
  }

  *addr = g_malloc (ptr - str + 1);
  strncpy (*addr, str, ptr - str);
  (*addr) [ptr - str] = '\0';
  return TRUE;
}


