
/*
 *  The main module:
 *  - Parsing command line parameters
 */

#include "phalanx.h"



void badoptions(void)
{
printf("\
Phalanx is a chess playing program.
Usage:    phalanx [options] [<moves> <minutes> [<increment in seconds>]]
          phalanx [options] [<seconds per move>]
Options:  -T <transposition table size in cells>, one cell is %i bytes
                                              default: %u cells
          -t <transposition table size in kilobytes>
          -f <fixed search time in seconds>
          -x <+/->  xboard mode on/off        default: on
          -p <+/->  permanent brain on/off    default: off
          -s <+/->  show thinking on/off      default: off
          -c <+/->  cpu time                  default: off
          -o <+/->  polling input             default: on
          -b <+/->  opening book              default: on
          -r <resign value in centipawns>     default: 0 (no resigning)
          -e <easy level 0...100>             default: 0 (best play)
             easy level implies no hashtable
             and permanent brain and learning off
          -l <+/->  learning on/off           default: off
          -v  version
          -P <primary book dir>
          -S <secondary book dir>
          -L <learning file dir>
Examples: phalanx -c+ -s+ -o - -x- -f 60 -t4000
          xboard -fcp \"phalanx -r800\"
", sizeof(thashentry), SizeHT );
exit(0);
}


char *get_book_file(char *bookdir,char *env_variable,
		    char *path,char *name,int mode)
{
  char file[256];
  char *aux;
  
  if(bookdir)			/* Specified in options? */
    path = bookdir;
  else if((aux=getenv(env_variable))) /* In an environment variable? */
    path = aux;
  else if(!access(name,mode))	/* In the current directory? */
    path = ".";
  else				/* Desperacy now, use compile time file. */
    ;
  
  snprintf(file,255,"%s/%s",path,name);
  return strdup(file);
}


int main( int argc, char **argv )
{

int c;
long t = clock();
int indexptr;
char *PbookDir,*SbookDir,*LbookDir;
struct option longopts[] = {
  { "help",                no_argument,       NULL, 	      '?' },
  { "version",             no_argument,       NULL, 	      'v' },
  { "trans-table-cells",   required_argument, NULL, 	      'T' },
  { "trans-table-bytes",   required_argument, NULL, 	      't' },
  { "fixed-search-time",   required_argument, NULL, 	      'f' },
  { "xboard-mode",         no_argument, 	&Flag.xboard,  1  },
  { "no-xboard-mode",      no_argument, 	&Flag.xboard,  0  },
  { "permanent-brain",     no_argument, 	&Flag.ponder,  1  },
  { "no-permanent-brain",  no_argument, 	&Flag.ponder,  0  },
  { "show-thinking",       no_argument, 	&Flag.post,    0  },
  { "no-show-thinking",    no_argument, 	&Flag.post,    1  },
  { "cpu-time",            no_argument, 	&Flag.cpu,     1  },
  { "no-cpu-time",         no_argument, 	&Flag.cpu,     0  },
  { "poll-input",          no_argument, 	&Flag.polling, 1  },
  { "no-poll-input",       no_argument, 	&Flag.polling, 0  },
  { "use-opening-book",    no_argument, 	&Flag.book,    1  },
  { "no-use-opening-book", no_argument, 	&Flag.book,    0  },
  { "easy-level",          required_argument, NULL,         'e' },
  { "resign-value",        required_argument, NULL,         'r' },
  { "learning",            no_argument, 	&Flag.learn,   1  },
  { "no-learning",         no_argument, 	&Flag.learn,   0  },
  { "primary-book-dir",    required_argument, NULL, 	      'P' },
  { "secondary-book-dir",  required_argument, NULL, 	      'S' },
  { "learning-file-dir",   required_argument, NULL, 	      'L' },
  { 0,0,0,0 }
};
 
/* Do NOT buffer I/O - needed for communication with xboard */
setvbuf(stdout, (char*)NULL, _IONBF, 0);

/* Initialize the random number generator. */
srand( ((unsigned)time(NULL)) + ((unsigned)getpid()) );

/* SIG_INT */
signal(SIGINT,SIG_IGN);

setfen("rnbqkbnr/pppppppp/////PPPPPPPP/RNBQKBNR/w");

#undef debugsee
#ifdef debugsee
{	extern short see(short,short);
	short x; int j;
	setfen("q2r2k1/1b3ppp/2prpn2/3P4/2PRP3/4NB2/5PPP/3R2K1 w");
	printboard();
	for(j=0;j!=1000000;j++) x=see(C6,D5);
	printf(" [%i]\n",see(C6,D5));
	return 0;
}
#endif

Flag.machine_color = BLACK;
Flag.post = 0;
Flag.xboard = 1;
Flag.book = 1;
Flag.centiseconds = 1000;
Flag.level = averagetime;
Flag.ponder = 0;
Flag.cpu = 0;
Flag.increment = 0;
Flag.polling = 1;
Flag.resign = 0;
Flag.easy = 0;
Flag.noise = 50;         /* 0.5 s */
Flag.learn = 0;
Scoring = 0;

SbookDir = NULL;
PbookDir = NULL;
LbookDir = NULL; 
 
opterr = 0;
while( ( c = getopt_long( argc, argv, "vf:T:t:p:s:x:c:o:r:b:e:l:S:B:L:",
			  longopts, &indexptr) ) != -1 )
switch(c)
{
	case 'T':
		if( sscanf( optarg, "%i", &SizeHT ) == 0 ) badoptions();
	break;
	case 't':
		if( sscanf( optarg, "%i", &SizeHT ) == 0 ) badoptions();
		SizeHT = 1024 * SizeHT / sizeof(thashentry);
	break;
	case 'r': { short i;
		if( sscanf( optarg, "%hi", &i ) == 0 ) badoptions();
		Flag.resign = abs(i); }
	break;
	case 'f':
		{
		static int t;
		if( sscanf( optarg, "%i", &t ) == 0 ) badoptions();
		Flag.centiseconds = t*100;
		Flag.level = fixedtime;
		} break;
	case 'e':
		{
		static int e;
		if( sscanf( optarg, "%i", &e ) == 0 ) badoptions();
		if( e > 100 ) badoptions();
		Flag.easy = e;
		} break;
	case 'p': switch(*optarg)
	{	case '+': Flag.ponder = 1; break;
		case '-': Flag.ponder = 0; break;
		default: badoptions();
	} break;
	case 's': switch(*optarg)
	{	case '+': Flag.post = 1; break;
		case '-': Flag.post = 0; break;
		default: badoptions();
	} break;
	case 'x': switch(*optarg)
	{	case '+': Flag.xboard = 1; break;
		case '-': Flag.xboard = 0; break;
		default: badoptions();
	} break;
	case 'c': switch(*optarg)
	{	case '+': Flag.cpu = 1; break;
		case '-': Flag.cpu = 0; break;
		default: badoptions();
	} break;
	case 'o': switch(*optarg)
	{	case '+': Flag.polling = 1; break;
		case '-': Flag.polling = 0; break;
		default: badoptions();
	} break;
	case 'b': switch(*optarg)
	{	case '+': Flag.book = 1; break;
		case '-': Flag.book = 0; break;
		default: badoptions();
	} break;
	case 'l': switch(*optarg)
	{	case '+': Flag.learn = 1; break;
		case '-': Flag.learn = 0; break;
		default: badoptions();
	} break;
        case 'v': fprintf(stderr,"%s\n",VERSION); exit(0);
	case 'P': PbookDir = strdup(optarg); break;
	case 'S': SbookDir = strdup(optarg); break;
	case 'L': LbookDir = strdup(optarg); break;
	case '?':
		badoptions();
	break;
}

{
int m;
switch( argc - optind )
{
case 0: break;
case 1:
	if( sscanf(argv[optind],"%i",&m) == 0 ) badoptions();
	Flag.centiseconds = 100*m;
	Flag.level = averagetime;
break;
case 2:
	if( sscanf(argv[optind],"%i",&m) == 0 ) badoptions();
	Flag.moves = m;
	if( sscanf(argv[optind+1],"%i",&m) == 0 ) badoptions();
	Flag.centiseconds = m*6000;
	Flag.level = timecontrol;
break;
case 3:
	if( sscanf(argv[optind],"%i",&m) == 0 ) badoptions();
	Flag.moves = m;
	if( sscanf(argv[optind+1],"%i",&m) == 0 ) badoptions();
	Flag.centiseconds = m*6000;
	if( sscanf(argv[optind+2],"%i",&m) == 0 ) badoptions();
	Flag.increment = m;
	Flag.level = timecontrol;
break;
default: badoptions();
}
}

if( Flag.easy )
{ SizeHT = 0; Flag.ponder = 0; Flag.learn = 0; }
else
if( SizeHT != 0 )
{
	HT = calloc( SizeHT, sizeof(thashentry) );
	if( HT == NULL )
	{
		puts("cannot alloc hashtable"); SizeHT = 0;
	}
}

printf("Phalanx ");
puts(VERSION);

/* alloc static eval cache */
{ extern void initcache(void); initcache(); }

/* init distance tables */
{ extern void initdist(void); initdist(); }

/*** Opening book init ***/
/* Try to open book files.  Give a message if not successful. */
SbookDir = get_book_file(SbookDir,ENV_SBOOK,SBOOK_DIR,SBOOK_FILE,R_OK);
Sbook.f = fopen(SbookDir,"rb");
PbookDir = get_book_file(PbookDir,ENV_PBOOK,PBOOK_DIR,PBOOK_FILE,R_OK);
Pbook.f = fopen(PbookDir,"rb");
LbookDir = get_book_file(LbookDir,ENV_LEARN,LEARN_DIR,LEARN_FILE,R_OK|W_OK);
Learn.f = fopen(LbookDir,"r+");

if( Sbook.f==NULL || Pbook.f==NULL )
{ if( Flag.xboard ) printf("telluser Phalanx: ");
  printf("Cannot open ");
}

if( Pbook.f != NULL )
{
	struct stat fs;
	stat(PbookDir,&fs); Pbook.filesize = fs.st_size;
}

if( Learn.f != NULL )
{
	struct stat fs;
	stat(LbookDir,&fs); Learn.filesize = fs.st_size;
}

if( Sbook.f != NULL )
{
	struct stat fs;
	unsigned pos;
	stat(SbookDir,&fs); Sbook.filesize = fs.st_size;
	fread( &pos, sizeof(unsigned), 1, Sbook.f ); Sbook.firstkey=pos;
	fseek( Sbook.f, Sbook.filesize-6, SEEK_SET );
	fread( &pos, sizeof(unsigned), 1, Sbook.f ); Sbook.lastkey=pos;
}

if( Sbook.f == NULL )
  if( Pbook.f == NULL )
    printf("both [%s] and [%s]\n", SBOOK_FILE, PBOOK_FILE );
  else
    printf("[%s]\n", SBOOK_FILE );
else
  if( Pbook.f == NULL )
    printf("[%s]\n", PBOOK_FILE );

if( Learn.f == NULL && Flag.learn )
{ Flag.learn=0; puts("telluser Phalanx: cannot open learn file"); }

/*
printf("FK=%08X LK=%08X MID=%08X\n",
      Sbook.firstkey,Sbook.lastkey,Sbook.firstkey/2+Sbook.lastkey/2);
*/

/************************************/
/************************************/
              shell();
/************************************/
/************************************/

t = clock()-t;
printf("Processor time ......... %i:%02i:%02i.%02i\n",
	(int) t/CLOCKS_PER_SEC/3600,
	(int) t/CLOCKS_PER_SEC%3600/60,
	(int) t/CLOCKS_PER_SEC%60,
	(int) t*100/CLOCKS_PER_SEC%100 );

if( Age != 0 )
{
printf("Average search depth ... %g\n",
	((float)AllDepth) / ((float)(Age*100)) );
printf("Average NPS report ..... %g\n",
	((float)AllNPS) / ((float)Age) );
}

printf("Hash table age ......... %i\n", Age);

puts("Good bye!");

return 0;

}

