/*------------------------------------------------------------------------------*/
/*   menudep.c									*/
/* Copyright (c) 1998  Tim Edwards, Johns Hopkins University       		*/
/*------------------------------------------------------------------------------*/
/* Parse file menudefs.h and create file of definitions for use by		*/
/* "XtNameToWidget" to find the menu.						*/
/*------------------------------------------------------------------------------*/
/*										*/
/* example:  For  menustruct Fonts[], 						*/
/*   #define FontsPath "Form.Text.mgr_shell.menu_mgr.popupFont.Font"		*/
/*										*/
/* Name is the menustruct name appended with the word "Path".  Path itself is	*/
/*										*/
/*  Form.(top button name).mgr_shell.menu_mgr.popup(cascade name).(cascade name)*/
/*										*/
/* for the menu cascade widgets.  Append .(entry name) for each button,		*/
/* where the name is modified by removing all non-alphanumerics and any		*/
/* trailing macro in parentheses.						*/
/*										*/
/* NAMING CONVENTIONS:								*/
/*    Cascade Widget:  name of menustruct + "Path"				*/
/*    Button Widgets:  name of menustruct + modified name of button + "Path"	*/
/*										*/
/*       "modified name" means that only alphanumeric characters are used and   */
/*	 the macro (if any) in parentheses is removed.				*/
/*------------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define MAXMENUS 200

main() {
   FILE *md, *mp;
   char linein[500], sname[100];
   char snames[MAXMENUS][100];		/* structure names */
   char labellist[MAXMENUS][100];	/* button names for pulldown menus */
   short deplist[MAXMENUS];		/* dependency list */
   char *cptr, *pptr, *pptr2, *stptr;
   short menus = 0, i, j, pass;

   if ((md = fopen("menudefs.h", "r")) == NULL) {
      printf("Unable to open menudefs.h for input\n");
      exit(1);
   }
   if ((mp = fopen("menudep.h", "w")) == NULL) {
      printf("Unable to open menudep.h for output\n");
      exit(1);
   }

   /* first pass through menudefs.h is to find the top button for each */
   /* submenu.							       */

   while (fgets(linein, 499, md) != NULL) {
      if (strstr(linein, "menustruct") == linein) {
	 deplist[menus] = -1;
	 sscanf(linein, "%*s %s", snames[menus]);
	 if ((cptr = strchr(snames[menus], '[')) != NULL) *cptr = '\0'; 

	 while (strstr(linein, "};") != linein) {
	    if (fgets(linein, 499, md) == NULL) break;
	    if ((cptr = strstr(linein, "submenu")) != NULL) {
	       cptr += 8;
	       if ((pptr = strchr(cptr, ')')) != NULL) *pptr = '\0';
	       for (i = 0; i < menus; i++) {
		  if (!strcmp(snames[i], cptr)) {
		     deplist[i] = menus;
		     if ((pptr = strchr(linein, '\"')) != NULL) {
			if ((pptr2 = strchr(pptr + 1, '\"')) != NULL) {
			   *pptr2 = '\0';
		           strcpy(labellist[i], pptr + 1);
			}
		     }
		  }
	       }
	    }
	 }
	 menus++;
      }
   }

   fprintf(mp, "/*-------------------------------------------------------*/\n");
   fprintf(mp, "/* menudep.h  generated automatically by program menudep */\n");
   fprintf(mp, "/*            from file menudefs.h.  Do not edit.        */\n");
   fprintf(mp, "/*-------------------------------------------------------*/\n\n");

   /* second pass through menudefs.h generates an entry for each button */

   /* for clarity, I divide this into two parts and separate cascade widgets */
   /* from button widgets by doing two separate passes.			     */

   for (pass = 0; pass < 2; pass++) {

   rewind(md);
   while (fgets(linein, 499, md) != NULL) {
      if (strstr(linein, "menustruct") == linein) {
         deplist[menus] = -1;
         sscanf(linein, "%*s %s", sname);
         if ((cptr = strchr(sname, '[')) != NULL) *cptr = '\0';

	 /* find entry of current menu */

	 for (j = 0; j < menus; j++)
	    if (!strcmp(snames[j], sname)) break;

	 /* find top-level button associated with this menu */

	 i = j;
	 if (deplist[i] != -1) {
	    while (deplist[deplist[i]] != -1) i = deplist[i];
	 }
	   
	 /* for each button, make an entry */

         while (strstr(linein, "};") != linein) {
            if (fgets(linein, 499, md) == NULL) break;
            if ((pass == 1) && (cptr = strstr(linein, "action")) != NULL &&
		 (strstr(linein, "noaction") == NULL)) {
	       if ((pptr = strchr(linein, '\"')) != NULL) {
		  pptr2 = pptr + 1;
		  stptr = sname;
	          while (*pptr2 != '\"' && *pptr2 != '\0') {

		     /* ignore part of name which is the key macro in parens */

		     if (*pptr2 == '(')
			while (*pptr2 != ')' && *pptr2 != '\0') pptr2++;

		     /* only use alphanumeric characters for the name */

		     if (isalnum(*pptr2)) *(stptr++) = *pptr2;
		     pptr2++;
		  }
		  *pptr2 = *stptr = '\0';
		  fprintf(mp, 
		       "#define %s%sPath \"Form.%s.mgr_shell.menu_mgr.popup%s.%s.%s\"\n",
		       snames[j], sname, labellist[i], labellist[j], labellist[j],
		       pptr + 1);
	       }
            }
	    else if ((pass == 0) && (cptr = strstr(linein, "submenu")) != NULL) {
	       if ((pptr = strchr(linein, '\"')) != NULL) {
		  cptr += 8;
		  pptr2 = cptr;
		  while (*pptr2 != ')' && *pptr2 != '\0') pptr2++;
		  *pptr2 = '\0';
		  pptr2 = pptr + 1;
	          while (*pptr2 != '\"' && *pptr2 != '\0') pptr2++;
		  *pptr2 = '\0';
	          fprintf(mp,
		       "#define %sPath \"Form.%s.mgr_shell.menu_mgr.popup%s.%s\"\n",
		       cptr, (deplist[i] == -1) ? pptr + 1 : labellist[i],
		       pptr + 1, pptr + 1);
	       }
	    }
	 }
      }
   }

   if (pass == 0)
      fprintf(mp, "\n/*-------------------------------------------------------*/\n\n");
   }
	       
   fclose(mp);
   fclose(md);
}
