
/*
 * XMKPROTO.C
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int
main(int ac, char **av)
{
    int i;
    int first = 1;
    int forceOpt = 0;
    char *outFile1 = NULL;
    char *outFile2 = NULL;
    FILE *fo = stdout;

    for (i = 1; i < ac; ++i) {
	FILE *fi;
	char *ptr = av[i];

	if (*ptr == '-')  {
	    ptr += 2;
	    switch(ptr[-1]) {
	    case 'o':
		{
		    outFile2 = (*ptr) ? ptr : av[++i];

		    if (outFile2 == NULL || 
			strstr(outFile2, "protos.h") == NULL
		    ) {
			printf("output file name must end ...protos.h\n");
			exit(1);
		    }
		    outFile1 = malloc(strlen(outFile2) + 32);
		    sprintf(outFile1, "%s.new", outFile2);
		    fo = fopen(outFile1, "w");
		}
		break;
	    case 'f':
		forceOpt = 1;
		break;
	    default:
		printf("Bad option: %s\n", ptr - 2);
		exit(1);
	    }
	    continue;
	}

	if ((fi = fopen(ptr, "r")) != NULL) {
	    char buf[8192];

	    if (first) {
		fprintf(fo,
		    "\n"
		    "/*\n"
		    " * PROTOTYPES - MACHINE GENERATED, DO NOT EDIT\n *\n"
		    " */\n"
		    "\n"
		);
		first = 0;
	    }

	    fprintf(fo, "\n/*\n * %s\n *\n */\n\n", ptr);

	    while (fgets(buf, sizeof(buf), fi) != NULL) {
		if (strncmp(buf, "Prototype", 9) == 0)
		    fputs(buf, fo);
	    }
	    fclose(fi);
	}
    }
    if (ac == 1)
	printf("%s -o -/outputfile srcFile1 ... srcFileN\n", av[0]);

    /*
     * Flush file, check for write errors
     */

    {
	fflush(fo);
	if (ferror(fo)) {
	    fprintf(stderr, "Write error on %s\n", outFile1);
	    remove(outFile1);
	    exit(1);
	}
    }

    /*
     * Compare outFile1 against outFile2 and rename over if they
     * are different or if the Force flag was set.
     */

    if (fo != stdout) {
	int isSame = 0;
	fclose(fo);

	if (forceOpt == 0) {
	    FILE *fa = NULL;
	    FILE *fb = NULL;

	    if ((fa = fopen(outFile2, "r")) != NULL &&
		(fb = fopen(outFile1, "r")) != NULL
	    ) {
		int c;

		isSame = 1;

		while ((c = getc(fa)) != EOF) {
		    if (getc(fb) != c) {
			isSame = 0;
			break;
		    }
		}
		if (c == EOF && getc(fb) != EOF)
		    isSame = 0;
	    }
	    if (fa)
		fclose(fa);
	    if (fb)
		fclose(fb);
	}

	/*
	 * overwrite the original.  If the files were the same,
	 * remove our temporary file.
	 */

	if (isSame == 0) {
	    printf("    GENERATED: %s\n", outFile2);
	    rename(outFile1, outFile2);
	} else {
	    printf("    NOCHANGE: %s\n", outFile2);
	    remove(outFile1);
	}
    }

    return(0);
}

