-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
class CHARACTER_REF

inherit
   HASHABLE;
   COMPARABLE 
      redefine compare, out_in_tagged_out_memory, 
	 fill_tagged_out_memory
      end;
   
creation make

feature 
   
   item: CHARACTER;

   make(value: CHARACTER) is
      do
	 item := value;
      end;
	
feature
   
   set_item(value: like item) is
      do
	 item := value;
      end;

   infix "<" (other: like Current): BOOLEAN is
	 -- Is Current less than `other'?
      do
	 Result := item < other.item
      end;

   compare (other: like Current) : INTEGER is
	 -- Compare Current with `other'.
	 -- '<' <==> Result < 0
	 -- '>' <==> Result > 0
	 -- Otherwise Result = 0
      do
	 Result := code - other.code
      end;

   code: INTEGER is
	 -- ASCII code of Current
      do
	 Result := item.code
      end;
   
   to_upper: like Current is
	 -- Conversion of Current to upper case
      do
	 !!Result.make (item.to_upper)
      end;

   to_lower: like Current is
	 -- Conversion of Current to lower case
      do
	 !!Result.make (item.to_lower)
      end;

feature -- Object Printing :

   out_in_tagged_out_memory, fill_tagged_out_memory is
      do
	 item.fill_tagged_out_memory;
      end;

feature -- Hashing :
   
   hash_code: INTEGER is
      do
	 Result := item.hash_code;
      end;

end -- CHARACTER_REF

