#include <rscheme/smemory.h>
#include <rscheme/scheme.h>
#include <stdlib.h>

static void tally_inc( obj tally_vec, int symbol )
{
  if (SLOT(symbol) >= SIZEOF_PTR(tally_vec))
    scheme_error( "tally vector too short for symbol ~d: ~s",
		  2, int2fx(symbol), tally_vec );
  gvec_write_non_ptr( tally_vec,
		      SLOT(symbol),
		      ADD1( gvec_ref( tally_vec, SLOT(symbol) ) ) );
}


void compress_tally( UINT_32 *src, UINT_32 src_cnt,
		     int queue_len, int near_bits, int lookahead,
		     obj tally_vec, int debug_q )
{
  UINT_32 w, i, j, k, sym;
  UINT_32 *queue;

  queue = malloc( sizeof(UINT_32) * queue_len );

  /* initialize the queue */

  for (i=0; i<queue_len; i++)
    {
      queue[i] = (i & 3) + ((i << near_bits) & ((1 << (near_bits + 2)) - 1));
    }

  k = 0;
  while (src_cnt > 0)
    {
      /* get the word */

      w = *src++;
      src_cnt--;

      if (debug_q)
	{
	  printf( "[%4d] {", k );
	  
	  for (i=0; i<queue_len; i++)
	    {
	      printf( " %08x", queue[i] );
	    }
	  printf( " } %08x", w );
	}
      k++;
	  
      /* check for a hit */

      for (i=0; i<queue_len; i++)
	{
	  if (queue[i] == w)
	    {
	      sym = i + 8;
	      /* move to front */
	      for (j=i; j>0; j--)
		queue[j] = queue[j-1];
	      queue[0] = w;
	      goto ok;
	    }
	  else if (((queue[i] & 3) == (w & 3))
		   && (abs((queue[i] >> 2) - (w >> 2)) <= (1 << near_bits)))
	    {
	      /* near miss */
	      sym = i + queue_len + 8;
	      /* move to front */
	      for (j=i; j>0; j--)
		queue[j] = queue[j-1];
	      queue[0] = w;
	      goto ok;
	    }
	}
      /* it's a miss */

      if (((w & 0xFFFFFF80) == 0xFFFFFF80)
	  || ((w & 0xFFFFFF80) == 0))
	sym = 0 /* 1-byte */;
      else if (((w & 0xFFFF8000) == 0xFFFF8000)
	  || ((w & 0xFFFF8000) == 0))
	sym = 2 /* 2-byte */;
      else if (((w & 0xFF800000) == 0xFF800000)
	  || ((w & 0xFF800000) == 0))
	sym = 4 /* 3-byte */;
      else 
	sym = 6 /* 4-byte */;

      /* check lookahead */

      for (i=0; i<lookahead && src_cnt-i > 0; i++)
	{
	  if (((src[i] & 3) == (w & 3))
	      && (abs(abs((src[i] >> 2) - (w >> 2)) <= (1 << near_bits))))
	    {
	      /* will hit later (probably, if lookahead > queue_len */
	      sym |= 1;
	      for (i=queue_len-1; i>0; i--)
		queue[i] = queue[i-1];
	      queue[0] = w;
	      break;
	    }
	}
	
    ok:
      tally_inc( tally_vec, sym );
      if (debug_q)
	{
	  if (sym >= 8)
	    {
	      if (sym - 8 >= queue_len)
		printf( " => near %d", sym - 8 - queue_len );
	      else
		printf( " => exact %d", sym - 8 );
	    }
	  else if (sym & 1)
	    printf( " => cache %d-byte", 1+(sym/2) );
	  else
	    printf( " => oneshot %d-byte", 1+(sym/2) );
	  printf( "\n" );
	}
    }
}
