#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/mathlib/numstr.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.3
 | File mod date:    1997.11.29 23:10:36
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  mathlib
 |
 `------------------------------------------------------------------------|#

;; this isn't the most efficient thing in the world...
;; could have multiple lists depending on static lexical
;; structure, like whether it contains a '.' or a '/'

(%early-once-only
 (define *number-parsers* (list string->fixnum
				;;string->long-int
				string->float)))

(define (get-radix (rest <list>) default)
  (if (null? rest)
      default
      (if (null? (cdr rest))
	  (if (fixnum? (car rest))
	      (let (((r <fixnum>) (car rest)))
		(if (and (fixnum>=? r 2)
			 (fixnum<=? r 36))
		    r
		    (error "radix specification `~d' is not in range 2..36" 
			   r)))
	      (error "radix specification `~s' is not a fixnum"
		     (car rest)))
	  (error "radix specification `~s' followed by: ~s" 
		 (car rest)
		 (cdr rest)))))


(define (string->number (str <string>) . rest)
  (if (and (> (string-length str) 2)
	   (eq? (string-ref str 0) #\#))
      (case (string-ref str 1)
	((#\x) (string->number (substring str 2) 16))
	((#\o) (string->number (substring str 2)  8))
	((#\b) (string->number (substring str 2)  2))
	((#\d) (string->number (substring str 2) 10))
	(else #f))
      (let ((r (get-radix rest 10)))
	(let loop ((p *number-parsers*))
	  (if (pair? p)
	      (or ((car p) str r)
		  (loop (cdr p)))
	      #f)))))

(define-method number-as-string ((self <fixnum>) (radix <fixnum>))
  (fixnum->string self radix))

(define-method number-as-string ((self <double-float>) (radix <fixnum>))
  (if (not (eq? radix 10))
      (error "number->string: radix ~d != 10" radix))
  (double-float->string self))

(define-method number-as-string ((self <long-int>) (radix <fixnum>))
  (long-int->string self radix))

(define (number->string (num <number>) . rest)
  (number-as-string num (get-radix rest 10)))
