#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/iolib/uniqobj.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.6
 | File mod date:    1997.11.29 23:10:40
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  iolib
 |
 `------------------------------------------------------------------------|#

(define *unique-object-names*
  '#("#none" "#undef" "#uninit" "#unbound" "#rest" "#key" "#all-keys"
	     "#next" "#missing"))

(define-method write-object ((thing <unique-obj>) port)
  (let (((i <fixnum>) (get-immob-value thing))
	(v *unique-object-names*))
    (if (fixnum<? i (vector-length v))
	(write-string port (vector-ref v i))
	(begin
	  (write-string port "#unique?")
	  (write-int port i)))))

(define (string->unique-object str)
  (let loop (((i <fixnum>) 0)
	     ((n <fixnum>) (vector-length *unique-object-names*)))
    (if (eq? n 0)
	#f
	(if (string-ci=? (vector-ref *unique-object-names* i) str)
	    (make-immob 4 i)
	    (loop (add1 i) (sub1 n))))))

;; returns the new unique object

(define (add-unique-object! (name <string>) ix)
  (if ix
      (begin
	(if (< ix (vector-length *unique-object-names*))
	    (vector-set! *unique-object-names* ix name)
	    (set! *unique-object-names*
		  (vector-append
		   *unique-object-names*
		   (make-vector (- ix (vector-length *unique-object-names*)) 
				"")
		   (vector name))))
	(make-immob 4 ix))
      (let ((i (vector-length *unique-object-names*)))
	(set! *unique-object-names*
	      (vector-append *unique-object-names* (vector name)))
	(make-immob 4 i))))

	      