#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/highscm/profiler.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.6
 | File mod date:    1997.11.29 23:10:32
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  high-scheme
 |
 | Purpose:          high-level profiling functions
 `------------------------------------------------------------------------|#

(define (call-with-profiling (path <string>) thunk)
  (%profile-start path #f)
  (bind ((#rest r (thunk)))
    (done-with-profiling path)
    (list->values r)))

(define (done-with-profiling path)
  (%profile-stop)
  ;;
  (let ((tbl (make-object-table)))
    (%profile-objects path tbl)
    (%profile-start path #t)
    (table-for-each
     tbl
     (lambda (h k v)
       (%profile-append-defn 
	k
	(let ((nm (name k)))
	 (if (symbol? nm)
	     (symbol->string nm)
	     nm)))
       (values)))
    (%profile-stop)))

