#
# sun4_sosV_5.5.mk - make variables and rules specific to Solaris 2.5.
#

PLATFORM = sun4_sosV_5.5
LIBDIR   = $(TOP)/lib
BINDIR   = $(TOP)/bin

#
# C preprocessor macro definitions for this architecture
#

PLATFORM_CPPFLAGS = -D__sunos__ -D__sparc__ -D__OSVERSION__=5 -DSVR4


#
# Standard programs
#

AR              = ar cq
RANLIB		= ranlib
MKDIRHIER	= /usr/openwin/bin/mkdirhier
CP		= cp
MV		= mv -f
RM              = rm -f

CXX             = CC
CXXFLAGS        = $(CXXDEBUGFLAGS) $(CXXOPTIONS) $(CPPFLAGS)
CXXDEBUGFLAGS   = -O2 -fsimple
CXXLINK		= $(CXX)
CXXLINKOPTIONS  = $(CXXDEBUGFLAGS) $(CXXOPTIONS)

CPPFLAGS        = $(DIR_CPPFLAGS) $(PLATFORM_CPPFLAGS)

.SUFFIXES: .o .cc .C .cpp .cxx

.cc.o:
	$(CXX) -c $(CXXFLAGS) -o $@ $<

.C.o:
	$(CXX) -c $(CXXFLAGS) -o $@ $<

.cpp.o:
	$(CXX) -c $(CXXFLAGS) -o $@ $<

.cxx.o:
	$(CXX) -c $(CXXFLAGS) -o $@ $<


# To build omnithread on top of solaris threads, uncomment the following two
# lines and comment out the corresponding ones in posix section below.
# You also have to update $(TOP)/src/lib/omnithread/Makefile and
#                         $(TOP)/src/lib/omnithread/sharedlib/sun4_sosV_5.5.mk
#
#OMNITHREAD_LIB = -lomnithread -lthread
#OMNITHREAD_CPPFLAGS = -I$(TOP)/include -D_REENTRANT

# To build omnithread on top of posix threads, uncomment the following three
# lines and comment out the corresponding ones in the solaris section above
# You also have to update $(TOP)/src/lib/omnithread/Makefile and
#                         $(TOP)/src/lib/omnithread/sharedlib/sun4_sosV_5.5.mk
#
OMNITHREAD_POSIX_CPPFLAGS = -DPthreadDraftVersion=10 \
                            -DPthreadSupportThreadPriority
OMNITHREAD_CPPFLAGS = -I$(TOP)/include -DUsePthread -D_REENTRANT
OMNITHREAD_LIB = -lomnithread -lpthread -lposix4
OMNITHREAD_STATIC_LIB = -Bstatic -lomnithread -Bdynamic -lpthread -lposix4

# Default location of the omniORB2 configuration file [falls back to this if
# the environment variable OMNIORB_CONFIG is not set] :
OMNIORB_CONFIG_DEFAULT_LOCATION = \"/etc/omniORB.cfg\"

OMNIORB_CPPFLAGS = -D__OMNIORB2__ $(OMNITHREAD_CPPFLAGS)
OMNIORB_LIB = -lomniORB2 $(OMNITHREAD_LIB) -lsocket -lnsl
OMNIORB_STATIC_LIB = -Bstatic -lomniORB2 -Bdynamic $(OMNITHREAD_STATIC_LIB) \
                     -lsocket -lnsl

# Default directory for the omniNames log files.
OMNINAMES_LOG_DEFAULT_LOCATION = \"/var/omninames\"
