/* context.h */
/* Chris Jacobi, November 12, 1997 2:53 pm PST */

/*
 * Copyright (c) 1991-1996 Xerox Corporation.  All Rights Reserved.
 * Unlimited use, reproduction, and distribution of this software is permitted.
 * Any copy of this software must include both the above copyright notice of
 * Xerox Corporation and this paragraph.  Any distribution of this software
 * must comply with all applicable United States export control laws.  This
 * software is made available AS IS, and XEROX CORPORATION DISCLAIMS ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND
 * NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY LIABILITY FOR
 * DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED,
 * WHETHER ARISING IN CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT
 * LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGES.
 */
 
/* $Id: context.h,v 1.19 1997/11/12 23:09:17 jacobi Exp $ */
/* see also context.c */

#ifndef _ILUJAVA_context_
#define _ILUJAVA_context_

typedef struct contextInternals_s {
    char* step0;		/* raw; original; search string */  
    char* step;			/* java cleaned */  
    char* chain;		/* java cleaned */  
    char* packagePrefix; 	/* java cleaned */
    list children;
    list stuffToLoad;
    list customMappings;
    boolean isIdlInterface;	/* idl guarantees name either ifc or module */ 
    list specialIdlConstants;	
    struct context_s* up;
} ContextInternals;

typedef struct contextSpecifics_s {
    char* stubSuffix;	/* suffix to designate stub class */
    char* refSuffix;	/* suffix to designate reference interfaces */
    char* holderSuffix;	/* suffix to designate sun style holder classes */
    char* helperSuffix;	/* suffix to designate visigenix style helper classes */
    char* delClassSuffix;	/* suffix to designate delegation class */
    char* implSuffix;	/* suffix for an (optional) impl class */
    char* implPrefix;	/* prefix for an (optional) impl class */
    char* exceptSuffix;	/* suffix to designate exceptions */
    char* loaderClass_Name; /* classname for extra class loading stuff */	      
    char* dirName;	/* name of directory for root of generated stubs */
    char* prefix; 	/* raw name of java prefix-package */
    char* prerem; 	/* opposite of prefix */
    char* extraSuffix; 	/* suffix to generate extra handler files */
    boolean genOmgAttr;	/* overload attributes methods the omg way */
    boolean flatDir;
    boolean genHlp;	/* use visigenix style helper class. */
    boolean genHldCls;	/* use named holder classes */
    boolean noServer;	/* prevent generation of server side */
    boolean genDel;	/* generate delegation class */
    boolean genImpl;	/* generate delegation class */
    boolean genVisiVar;	/* generate old visigenic style var class */
    boolean genFactory;	/* generate an object factory */
    boolean forbidden;	/* don't generate stubs */
    boolean extraFiles;	/* generate extra files to make ilu types stand alone */
} ContextSpecifics;

typedef struct context_s {
    ContextSpecifics p;	/* specied to customize */
    ContextInternals i;	/* computed */
} * IHandle;

extern IHandle getChildContext(IHandle parent, char* step, boolean create);

extern IHandle getContextC(char* name);
    /* get or create context; name dot separated chain of "module" names */ 
extern IHandle getContext(Interface ifc, list scoping);
    /* get or create context */ 
extern IHandle getContextT(Type t);
    /* get or create context for "module" where t is declared */
extern IHandle getContextTraw(Type t);
    /* get or create context for "module" where t is declared; not urtyped */
extern IHandle getContextRoot();
    /* get or create context for global default */

/* The current context describes the "module" of the open file */ 
extern IHandle currentIH;
extern void setCurrentIH(IHandle ih);

/* The current Interface from the context of the open file */
extern Interface currentIfc;
extern void setCurrentIfc(Interface ifc);

/* Final package prefix from concatenation of prefix and context chain */
extern char* packagePrefix(IHandle ih);

#endif /* _ILUJAVA_context_ */
/* end */
