/* xerox.ilu.IluServerRelocationInfo */
/* Chris Jacobi, October 29, 1997 1:31 pm PST */

/*
 * Copyright (c) 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluServerRelocationInfo.java,v 1.2 1997/10/29 21:52:31 jacobi Exp $ */
 
package xerox.ilu;

/**
 * ILU private class used for implementing
 * server side relocation. <p>
 *
 * @see IluServer
 */
 
/*friendly*/ final 
class IluServerRelocationInfo {
    
    /*friendly*/ IluServerRelocationInfo (IluServerRelocation checker) {
        this.pInfoContainer = new java.lang.String[1];
        this.tInfoContainer = new xerox.ilu.IluTransportInfo[1];
        this.jjRelocatonChecking = checker;
    } //constructor
    
       /**
        * Passed back to native caller of mustCheckRelocate.  
        * Java side must prevent garbage collection for as long as 
        * native side uses values.   Done by preventing overwriting
        * the jjSaveProtocolInfo and jjSaveTransportInfo fields
        * again (by holding the server lock when calling
        * mustCheckRelocate)  
        * Native side must extract values of its interest before
        * java garbage collector does any compactions.
        */
    /*friendly*/ java.lang.String jjSaveProtocolInfo = null;
    /*friendly*/ xerox.ilu.IluTransportInfo jjSaveTransportInfo = null;
    
    
       /**
        * Callback description.
        */
    /*friendly*/ xerox.ilu.IluServerRelocation jjRelocatonChecking = null;

       /**
        * Out arguments container passed into call-back method.
        */
    /*friendly*/ java.lang.String[] pInfoContainer = null;
    /*friendly*/ xerox.ilu.IluTransportInfo[] tInfoContainer = null;
        
} //IluServerRelocationInfo



