/*
 * Copyright (c) 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: */


#ifndef _ILUJAVA_JMON_H_
#define _ILUJAVA_JMON_H_


#include "IluJava_Includes.h"
#include "IluJava_JMem.h"


#define ILUJAVA_MON_ALLOC() \
    ilujava_mon_allocate()


#define ILUJAVA_MON_FREE(monitorHandle) \
    if ( monitorHandle ) ilujava_mon_destroyDeallocate( monitorHandle ); \
    monitorHandle = 0; 



#ifndef WIN32
/* **************** Using ONI with system monitors on Solaris ************* */

typedef struct sys_thread java_sys_thread_t;
typedef java_sys_thread_t* ILUJAVA_SYSTHREAD_stPtr;


#include <sys_api.h>
/*
 *  WARNING
 *  *******
 * 
 *  sys_api.h as we got it here at xerox, in
 *  /project/java/jdk-1.0.2/include/sys_api.h
 *  has a bug:  It imports sysmacros_md.h
 *  which is not available.  We have made a
 *  a private copy of sysmacros_md to fix this
 *  java bug.  Here at Xerox we do not use 
 *  Sun's version which might be available in a 
 *  source release.
 *
 *  See sysmacros_md.h
 */

/* ILUJAVA_JMON_PTR: Type definitions to define monitor pointers 
 * without knowing the actual type or the size...
 */

typedef struct  ilujava_sys_mon_size_unknown ilujava_sys_mon_t;
typedef ilujava_sys_mon_t* ILUJAVA_JMON_PTR;

/* Don't use this procedure; use the ILUJAVA_MON_ALLOC macro instead */
extern ILUJAVA_JMON_PTR ilujava_mon_allocate();

/* Don't use this procedure; use the ILUJAVA_MON_FREE macro instead */
extern void ilujava_mon_destroyDeallocate(ILUJAVA_JMON_PTR);



#define ILUJAVA_MON_ENTER(monitorHandle) \
    (int) sysMonitorEnter((sys_mon_t *) monitorHandle )
    /*
     * int     sysMonitorEnter(sys_mon_t *);
     */


#define ILUJAVA_MON_EXIT(monitorHandle) \
    (int) sysMonitorExit((sys_mon_t *) monitorHandle )
    /*
     * int     sysMonitorExit(sys_mon_t *);
     */


#define ILUJAVA_MON_NOTIFY(monitorHandle) \
    (int) sysMonitorNotify((sys_mon_t *) monitorHandle )
    /*
     * int     sysMonitorNotify(sys_mon_t *);
     */


#define ILUJAVA_MON_NOTIFYALL(monitorHandle) \
    (int) sysMonitorNotifyAll((sys_mon_t *) monitorHandle )
    /*
     * int     sysMonitorNotifyAll(sys_mon_t *);
     */


#if (ILU_JAVA_MAJOR_VERSION == 1 && ILU_JAVA_MINOR_VERSION >= 1)

#define ILUJAVA_MON_WAIT(monitorHandle, timeout) \
    (int) sysMonitorWait((sys_mon_t *) monitorHandle , timeout , FALSE)
    /*
     * int 	sysMonitorWait(sys_mon_t *, int, bool_t);
     */

#else

#define ILUJAVA_MON_WAIT(monitorHandle, timeout) \
    (int) sysMonitorWait((sys_mon_t *) monitorHandle , timeout);
    /*
     * int 	sysMonitorWait(sys_mon_t *, int);
     */

#endif

#define ILUJAVA_MON_SIZEOF() \
    (int) sysMonitorSizeof()
    /*
     * int     sysMonitorSizeof(void);
     */


#if (ILU_JAVA_MAJOR_VERSION == 1 && ILU_JAVA_MINOR_VERSION >= 1)
#define ILUJAVA_MON_INIT(monitorHandle) \
    (int) sysMonitorInit((sys_mon_t *) monitorHandle )
    /*
     * int     sysMonitorInit(sys_mon_t *);
     */
#else
#define ILUJAVA_MON_INIT(monitorHandle) \
    (int) sysMonitorInit((sys_mon_t *) monitorHandle, FALSE);
#endif      

 
/*
 * Threading primitives.
 * Sys threads and java threads may or may not be the same thing.
 * Very few primitives; most thread operations are done by
 * calling back into java.
 */


#define ILUJAVA_SYSTHREAD_sysThreadSelf() \
    (ILUJAVA_SYSTHREAD_stPtr) sysThreadSelf()
    
#define ILUJAVA_SYSTHREAD_javaThreadFromSysThread(sysThread) \
    (void *) sysThreadGetBackPtr((sys_thread_t *) sysThread)



/* **************** END Using ONI with system monitors on Solaris ************* */

#else   /* we're on WIN32 */


/* NOT RELIABLY TESTED */

/* Doc from the original implementation:
 * Macros to make it possible to switch the implementation
 * of monitors without disrupting the actual usage code.
 *
 * All the monitor locking of the ilu java runtime support uses 
 * this file.  Every monitor is either only used from java, or, 
 * used only from the native side.  Keeping monitor use strictly   
 * on one side allows to use different implementations for monitors 
 * of each side.  In the current, non-JNI implementations, the native
 * side monitors are system monitors and not java objects.
 *
 * Unlike java monitors, these native monitors may or may not be 
 * implemented thread reentrently; its use will never reenter a  
 * monitor held by the own thread.
 */

/*
 * ALTERNATE IMPLEMENTATION 
 * which does use java monitors instead of system monitors.
 * May be slower.
 */
 


#ifdef RNI
/* **************** we're using Microsoft's Raw Native Interface **************** */

typedef long ILUJAVA_SYSTHREAD_stPtr;

typedef struct  ilujava_sys_mon_size_unknown ilujava_sys_mon_t;
typedef HObject** ILUJAVA_JMON_PTR;

/* Don't use this procedure; use the ILUJAVA_MON_ALLOC macro instead */
extern ILUJAVA_JMON_PTR ilujava_mon_allocate();

/* Don't use this procedure; use the ILUJAVA_MON_FREE macro instead */
extern void ilujava_mon_destroyDeallocate(ILUJAVA_JMON_PTR);


#define ILUJAVA_MON_ENTER(monitorHandle) \
    monitorEnter((unsigned int) *monitorHandle )


#define ILUJAVA_MON_EXIT(monitorHandle) \
    monitorExit((unsigned int) *monitorHandle )


#define ILUJAVA_MON_NOTIFY(monitorHandle) \
    monitorNotify((unsigned int) *monitorHandle )


#define ILUJAVA_MON_NOTIFYALL(monitorHandle) \
    monitorNotifyAll((unsigned int) *monitorHandle )


#define ILUJAVA_MON_WAIT(monitorHandle, timeout) \
    monitorWait((unsigned int) *monitorHandle , (int) timeout )

/*
 * Threading primitives.
 * Sys threads and java threads may or may not be the same thing.
 * Very few primitives; most thread operations are done by
 * calling back into java.
 */

// xxx dll temp try out extern struct Hjava_lang_Thread *java_lang_Thread_currentThread(struct Hjava_lang_Thread *);
extern long rni_current_thread();
#define ILUJAVA_SYSTHREAD_sysThreadSelf() \
	rni_current_thread()
    //(ILUJAVA_SYSTHREAD_stPtr) java_lang_Thread_currentThread(0)

#define ILUJAVA_SYSTHREAD_javaThreadFromSysThread(sysThread) \
    (void *) (sysThread)

/* **************** END we're using Microsoft's Raw Native Interface ************ */



#else
/* **************** assume using ONI with java monitors on Win32 **************** */

typedef struct sys_thread java_sys_thread_t;
typedef java_sys_thread_t* ILUJAVA_SYSTHREAD_stPtr;

#define _ILUJAVA_MONSZ 8


typedef struct  ilujava_sys_mon_size_unknown ilujava_sys_mon_t;
typedef ilujava_sys_mon_t* ILUJAVA_JMON_PTR;

/* Don't use this procedure; use the ILUJAVA_MON_ALLOC macro instead */
extern ILUJAVA_JMON_PTR ilujava_mon_allocate();

/* Don't use this procedure; use the ILUJAVA_MON_FREE macro instead */
extern void ilujava_mon_destroyDeallocate(ILUJAVA_JMON_PTR);

#define ILUJAVA_MON_ENTER(monitorHandle) \
    monitorEnter((unsigned int) monitorHandle )


#define ILUJAVA_MON_EXIT(monitorHandle) \
    monitorExit((unsigned int) monitorHandle )


#define ILUJAVA_MON_NOTIFY(monitorHandle) \
    monitorNotify((unsigned int) monitorHandle )


#define ILUJAVA_MON_NOTIFYALL(monitorHandle) \
    monitorNotifyAll((unsigned int) monitorHandle )


#define ILUJAVA_MON_WAIT(monitorHandle, timeout) \
    monitorWait((unsigned int) monitorHandle , (int) timeout )


/*
 * Threading primitives.
 * Sys threads and java threads may or may not be the same thing.
 * Very few primitives; most thread operations are done by
 * calling back into java.
 */

#include <threads.h>
#define ILUJAVA_SYSTHREAD_sysThreadSelf() \
			(ILUJAVA_SYSTHREAD_stPtr) threadSelf()
    
#define ILUJAVA_SYSTHREAD_javaThreadFromSysThread(sysThread) \
    (void *) (sysThread)

/* **************** END assume using ONI with java monitors on Win32 ************ */
#endif  /* not RNI */

#endif  /*on WIN32 */

#endif  /* _ILUJAVA_JMON_H_ */


